/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.table;

import java.io.Serializable;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class DefaultTableModel
extends AbstractTableModel
implements Serializable {
    static final long serialVersionUID = 6680042567037222321L;
    protected Vector dataVector;
    protected Vector columnIdentifiers;

    public DefaultTableModel() {
        this(0, 0);
    }

    public DefaultTableModel(int n, int n2) {
        int n3;
        Vector vector = new Vector(n2);
        Vector vector2 = new Vector(n);
        for (n3 = 0; n3 < n2; ++n3) {
            vector.add(super.getColumnName(n3));
        }
        for (n3 = 0; n3 < n; ++n3) {
            Vector vector3 = new Vector(n2);
            vector3.setSize(n2);
            vector2.add(vector3);
        }
        this.setDataVector(vector2, vector);
    }

    public DefaultTableModel(Vector vector, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("numRows < 0");
        }
        Vector vector2 = new Vector();
        int n2 = 0;
        if (vector != null) {
            n2 = vector.size();
        }
        while (n-- > 0) {
            Vector vector3 = new Vector();
            vector3.setSize(n2);
            vector2.add(vector3);
        }
        this.setDataVector(vector2, vector);
    }

    public DefaultTableModel(Object[] objectArray, int n) {
        this(DefaultTableModel.convertToVector(objectArray), n);
    }

    public DefaultTableModel(Vector vector, Vector vector2) {
        this.setDataVector(vector, vector2);
    }

    public DefaultTableModel(Object[][] objectArray, Object[] objectArray2) {
        this(DefaultTableModel.convertToVector(objectArray), DefaultTableModel.convertToVector(objectArray2));
    }

    public Vector getDataVector() {
        return this.dataVector;
    }

    public void setDataVector(Vector vector, Vector vector2) {
        this.dataVector = vector == null ? new Vector() : vector;
        this.setColumnIdentifiers(vector2);
    }

    public void setDataVector(Object[][] objectArray, Object[] objectArray2) {
        this.setDataVector(DefaultTableModel.convertToVector(objectArray), DefaultTableModel.convertToVector(objectArray2));
    }

    public void newDataAvailable(TableModelEvent tableModelEvent) {
        this.fireTableChanged(tableModelEvent);
    }

    public void newRowsAdded(TableModelEvent tableModelEvent) {
        this.fireTableChanged(tableModelEvent);
    }

    public void rowsRemoved(TableModelEvent tableModelEvent) {
        this.fireTableChanged(tableModelEvent);
    }

    public void setColumnIdentifiers(Vector vector) {
        this.columnIdentifiers = vector;
        this.setColumnCount(vector == null ? 0 : vector.size());
    }

    public void setColumnIdentifiers(Object[] objectArray) {
        this.setColumnIdentifiers(DefaultTableModel.convertToVector(objectArray));
    }

    public void setNumRows(int n) {
        this.setRowCount(n);
    }

    public void setRowCount(int n) {
        int n2 = this.dataVector.size();
        if (n < n2) {
            this.dataVector.setSize(n);
            this.fireTableRowsDeleted(n, n2 - 1);
        } else {
            int n3 = n - n2;
            for (int i = 0; i < n3; ++i) {
                Vector vector = new Vector();
                vector.setSize(this.columnIdentifiers.size());
                this.dataVector.add(vector);
            }
            this.fireTableRowsInserted(n2, n - 1);
        }
    }

    public void setColumnCount(int n) {
        for (int i = 0; i < this.dataVector.size(); ++i) {
            ((Vector)this.dataVector.get(i)).setSize(n);
        }
        if (this.columnIdentifiers != null) {
            this.columnIdentifiers.setSize(n);
        }
        this.fireTableStructureChanged();
    }

    public void addColumn(Object object) {
        this.addColumn(object, (Object[])null);
    }

    public void addColumn(Object object, Vector vector) {
        Object[] objectArray = null;
        if (vector != null) {
            int n = this.dataVector.size();
            if (vector.size() < n) {
                vector.setSize(n);
            }
            objectArray = vector.toArray();
        }
        this.addColumn(object, objectArray);
    }

    public void addColumn(Object object, Object[] objectArray) {
        int n;
        if (objectArray != null) {
            if (objectArray.length > this.dataVector.size()) {
                n = objectArray.length - this.dataVector.size();
                for (int i = 0; i < n; ++i) {
                    Vector vector = new Vector();
                    vector.setSize(this.columnIdentifiers.size());
                    this.dataVector.add(vector);
                }
            } else if (objectArray.length < this.dataVector.size()) {
                Object[] objectArray2 = new Object[this.dataVector.size()];
                System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                objectArray = objectArray2;
            }
        }
        for (n = 0; n < this.dataVector.size(); ++n) {
            ((Vector)this.dataVector.get(n)).add(objectArray == null ? null : objectArray[n]);
        }
        this.columnIdentifiers.add(object);
        this.fireTableStructureChanged();
    }

    public void addRow(Vector vector) {
        int n = this.dataVector.size();
        this.dataVector.add(vector);
        this.newRowsAdded(new TableModelEvent(this, n, n, -1, 1));
    }

    public void addRow(Object[] objectArray) {
        this.addRow(DefaultTableModel.convertToVector(objectArray));
    }

    public void insertRow(int n, Vector vector) {
        this.dataVector.add(n, vector);
        this.fireTableRowsInserted(n, n);
    }

    public void insertRow(int n, Object[] objectArray) {
        this.insertRow(n, DefaultTableModel.convertToVector(objectArray));
    }

    public void moveRow(int n, int n2, int n3) {
        int n4;
        Vector vector = new Vector();
        for (n4 = n2; n4 >= n; --n4) {
            vector.add(this.dataVector.remove(n4));
        }
        for (n4 = 0; n4 <= n2 - n; ++n4) {
            this.dataVector.insertElementAt(vector.get(n4), n3);
        }
        n4 = Math.min(n, n3);
        int n5 = Math.max(n2, n3 + (n2 - n));
        this.fireTableRowsUpdated(n4, n5);
    }

    public void removeRow(int n) {
        this.dataVector.remove(n);
        this.fireTableRowsDeleted(n, n);
    }

    public int getRowCount() {
        return this.dataVector.size();
    }

    public int getColumnCount() {
        if (this.columnIdentifiers == null) {
            return 0;
        }
        return this.columnIdentifiers.size();
    }

    public String getColumnName(int n) {
        Object object;
        String string = "";
        string = this.columnIdentifiers == null ? super.getColumnName(n) : (n < this.getColumnCount() ? ((object = this.columnIdentifiers.get(n)) != null ? object.toString() : super.getColumnName(n)) : super.getColumnName(n));
        return string;
    }

    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    public Object getValueAt(int n, int n2) {
        return ((Vector)this.dataVector.get(n)).get(n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        ((Vector)this.dataVector.get(n)).set(n2, object);
        this.fireTableCellUpdated(n, n2);
    }

    protected static Vector convertToVector(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        Vector vector = new Vector(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            vector.add(objectArray[i]);
        }
        return vector;
    }

    protected static Vector convertToVector(Object[][] objectArray) {
        if (objectArray == null) {
            return null;
        }
        Vector vector = new Vector(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            vector.add(DefaultTableModel.convertToVector(objectArray[i]));
        }
        return vector;
    }
}

