/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.table;

import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class TableColumn
implements Serializable {
    static final long serialVersionUID = -6113660025878112608L;
    public static final String COLUMN_WIDTH_PROPERTY = "columWidth";
    public static final String HEADER_VALUE_PROPERTY = "headerValue";
    public static final String HEADER_RENDERER_PROPERTY = "headerRenderer";
    public static final String CELL_RENDERER_PROPERTY = "cellRenderer";
    protected int modelIndex;
    protected Object identifier;
    protected int width;
    protected int minWidth;
    private int preferredWidth;
    protected int maxWidth;
    protected TableCellRenderer headerRenderer;
    protected Object headerValue;
    protected TableCellRenderer cellRenderer;
    protected TableCellEditor cellEditor;
    protected boolean isResizable;
    protected transient int resizedPostingDisableCount;
    private SwingPropertyChangeSupport changeSupport;

    private /* synthetic */ void finit$() {
        this.minWidth = 15;
        this.maxWidth = Integer.MAX_VALUE;
        this.isResizable = true;
        this.changeSupport = new SwingPropertyChangeSupport(this);
    }

    public TableColumn() {
        this(0, 75, null, null);
    }

    public TableColumn(int n) {
        this(n, 75, null, null);
    }

    public TableColumn(int n, int n2) {
        this(n, n2, null, null);
    }

    public TableColumn(int n, int n2, TableCellRenderer tableCellRenderer, TableCellEditor tableCellEditor) {
        this.finit$();
        this.modelIndex = n;
        this.width = n2;
        this.preferredWidth = n2;
        this.cellRenderer = tableCellRenderer;
        this.cellEditor = tableCellEditor;
        this.headerValue = null;
        this.identifier = null;
    }

    private void firePropertyChange(String string, Object object, Object object2) {
        this.changeSupport.firePropertyChange(string, object, object2);
    }

    private void firePropertyChange(String string, int n, int n2) {
        this.firePropertyChange(string, new Integer(n), new Integer(n2));
    }

    private void firePropertyChange(String string, boolean bl, boolean bl2) {
        this.firePropertyChange(string, (Object)bl, (Object)bl2);
    }

    public void setModelIndex(int n) {
        this.modelIndex = n;
    }

    public int getModelIndex() {
        return this.modelIndex;
    }

    public void setIdentifier(Object object) {
        this.identifier = object;
    }

    public Object getIdentifier() {
        if (this.identifier == null) {
            return this.getHeaderValue();
        }
        return this.identifier;
    }

    public void setHeaderValue(Object object) {
        if (this.headerValue == object) {
            return;
        }
        Object object2 = this.headerValue;
        this.headerValue = object;
        this.firePropertyChange(HEADER_VALUE_PROPERTY, object2, object);
    }

    public Object getHeaderValue() {
        return this.headerValue;
    }

    public void setHeaderRenderer(TableCellRenderer tableCellRenderer) {
        if (this.headerRenderer == tableCellRenderer) {
            return;
        }
        TableCellRenderer tableCellRenderer2 = this.headerRenderer;
        this.headerRenderer = tableCellRenderer;
        this.firePropertyChange(HEADER_RENDERER_PROPERTY, tableCellRenderer2, this.headerRenderer);
    }

    public TableCellRenderer getHeaderRenderer() {
        return this.headerRenderer;
    }

    public void setCellRenderer(TableCellRenderer tableCellRenderer) {
        if (this.cellRenderer == tableCellRenderer) {
            return;
        }
        TableCellRenderer tableCellRenderer2 = this.cellRenderer;
        this.cellRenderer = tableCellRenderer;
        this.firePropertyChange(CELL_RENDERER_PROPERTY, tableCellRenderer2, this.cellRenderer);
    }

    public TableCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public void setCellEditor(TableCellEditor tableCellEditor) {
        this.cellEditor = tableCellEditor;
    }

    public TableCellEditor getCellEditor() {
        return this.cellEditor;
    }

    public void setWidth(int n) {
        int n2 = this.width;
        this.width = n < this.minWidth ? this.minWidth : (n > this.maxWidth ? this.maxWidth : n);
        if (this.width == n2) {
            return;
        }
        this.firePropertyChange("width", n2, this.width);
    }

    public int getWidth() {
        return this.width;
    }

    public void setPreferredWidth(int n) {
        int n2 = this.preferredWidth;
        this.preferredWidth = n < this.minWidth ? this.minWidth : (n > this.maxWidth ? this.maxWidth : n);
        this.firePropertyChange("preferredWidth", n2, this.preferredWidth);
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public void setMinWidth(int n) {
        this.minWidth = n;
        this.setWidth(this.getWidth());
        this.setPreferredWidth(this.getPreferredWidth());
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public void setMaxWidth(int n) {
        this.maxWidth = n;
        this.setWidth(this.getWidth());
        this.setPreferredWidth(this.getPreferredWidth());
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setResizable(boolean bl) {
        this.isResizable = bl;
    }

    public boolean getResizable() {
        return this.isResizable;
    }

    public void sizeWidthToFit() {
    }

    public void disableResizedPosting() {
    }

    public void enableResizedPosting() {
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.changeSupport.getPropertyChangeListeners();
    }

    protected TableCellRenderer createDefaultHeaderRenderer() {
        return new DefaultTableCellRenderer();
    }
}

