/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyleContext;
import javax.swing.tree.TreeNode;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

public abstract class AbstractDocument
implements Document,
Serializable {
    private static final long serialVersionUID = 6842927725919637215L;
    protected static final String BAD_LOCATION = "document location failure";
    public static final String BidiElementName = "bidi level";
    public static final String ContentElementName = "content";
    public static final String ParagraphElementName = "paragraph";
    public static final String SectionElementName = "section";
    public static final String ElementNameAttribute = "$ename";
    Content content;
    AttributeContext context;
    DocumentFilter documentFilter;
    Dictionary properties;
    protected EventListenerList listenerList;
    private Thread currentWriter;
    private int numReaders;
    private int numWritersWaiting;
    Object documentCV;

    private /* synthetic */ void finit$() {
        this.listenerList = new EventListenerList();
        this.currentWriter = null;
        this.numReaders = 0;
        this.numWritersWaiting = 0;
        this.documentCV = new Object();
    }

    protected AbstractDocument(Content content) {
        this(content, StyleContext.getDefaultStyleContext());
    }

    protected AbstractDocument(Content content, AttributeContext attributeContext) {
        this.finit$();
        this.content = content;
        this.context = attributeContext;
    }

    public abstract Element getParagraphElement(int var1);

    public abstract Element getDefaultRootElement();

    protected Element createBranchElement(Element element, AttributeSet attributeSet) {
        return new BranchElement(this, element, attributeSet);
    }

    protected Element createLeafElement(Element element, AttributeSet attributeSet, int n, int n2) {
        return new LeafElement(this, element, attributeSet, n, n2);
    }

    public Position createPosition(int n) throws BadLocationException {
        return this.content.createPosition(n);
    }

    protected void fireChangedUpdate(DocumentEvent documentEvent) {
        DocumentListener[] documentListenerArray = this.getDocumentListeners();
        for (int i = 0; i < documentListenerArray.length; ++i) {
            documentListenerArray[i].changedUpdate(documentEvent);
        }
    }

    protected void fireInsertUpdate(DocumentEvent documentEvent) {
        DocumentListener[] documentListenerArray = this.getDocumentListeners();
        for (int i = 0; i < documentListenerArray.length; ++i) {
            documentListenerArray[i].insertUpdate(documentEvent);
        }
    }

    protected void fireRemoveUpdate(DocumentEvent documentEvent) {
        DocumentListener[] documentListenerArray = this.getDocumentListeners();
        for (int i = 0; i < documentListenerArray.length; ++i) {
            documentListenerArray[i].removeUpdate(documentEvent);
        }
    }

    protected void fireUndoableEditUpdate(UndoableEditEvent undoableEditEvent) {
        UndoableEditListener[] undoableEditListenerArray = this.getUndoableEditListeners();
        for (int i = 0; i < undoableEditListenerArray.length; ++i) {
            undoableEditListenerArray[i].undoableEditHappened(undoableEditEvent);
        }
    }

    public int getAsynchronousLoadPriority() {
        return 0;
    }

    protected AttributeContext getAttributeContext() {
        return this.context;
    }

    public Element getBidiRootElement() {
        return null;
    }

    protected final Content getContent() {
        return this.content;
    }

    protected Thread getCurrentWriter() {
        return this.currentWriter;
    }

    public Dictionary getDocumentProperties() {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        return this.properties;
    }

    public Position getEndPosition() {
        return new Position(this){
            private /* synthetic */ AbstractDocument this$0;
            {
                this.this$0 = abstractDocument;
            }

            public int getOffset() {
                return this.this$0.getLength();
            }
        };
    }

    public int getLength() {
        return this.content.length() - 1;
    }

    public EventListener[] getListeners(Class clazz) {
        return this.listenerList.getListeners(clazz);
    }

    public Object getProperty(Object object) {
        Object object2 = null;
        if (this.properties != null) {
            object2 = this.properties.get(object);
        }
        return object2;
    }

    public Element[] getRootElements() {
        Element[] elementArray = new Element[]{this.getDefaultRootElement()};
        return elementArray;
    }

    public Position getStartPosition() {
        return new Position(this){
            private /* synthetic */ AbstractDocument this$0;
            {
                this.this$0 = abstractDocument;
            }

            public int getOffset() {
                return 0;
            }
        };
    }

    public String getText(int n, int n2) throws BadLocationException {
        return this.content.getString(n, n2);
    }

    public void getText(int n, int n2, Segment segment) throws BadLocationException {
        this.content.getChars(n, n2, segment);
    }

    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (string == null || string.length() == 0) {
            return;
        }
        DefaultDocumentEvent defaultDocumentEvent = new DefaultDocumentEvent(this, n, string.length(), DocumentEvent.EventType.INSERT);
        this.writeLock();
        UndoableEdit undoableEdit = this.content.insertString(n, string);
        this.insertUpdate(defaultDocumentEvent, attributeSet);
        this.writeUnlock();
        this.fireInsertUpdate(defaultDocumentEvent);
        if (undoableEdit != null) {
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, undoableEdit));
        }
    }

    protected void insertUpdate(DefaultDocumentEvent defaultDocumentEvent, AttributeSet attributeSet) {
    }

    protected void postRemoveUpdate(DefaultDocumentEvent defaultDocumentEvent) {
    }

    public void putProperty(Object object, Object object2) {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        this.properties.put(object, object2);
    }

    public void readLock() {
        if (this.currentWriter != null && this.currentWriter.equals(Thread.currentThread())) {
            return;
        }
        Object object = this.documentCV;
        synchronized (object) {
            try {
                while (this.currentWriter != null || this.numWritersWaiting > 0) {
                    try {
                        this.documentCV.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new Error("interrupted trying to get a readLock");
                    }
                }
                ++this.numReaders;
            }
            finally {
                Object var2_3 = null;
            }
            return;
        }
    }

    public void readUnlock() {
        if (this.numReaders == 0) {
            throw new IllegalStateException("document lock failure");
        }
        Object object = this.documentCV;
        synchronized (object) {
            block4: {
                try {
                    if (this.currentWriter != null) break block4;
                    --this.numReaders;
                    if (this.numReaders != 0 || this.numWritersWaiting == 0) break block4;
                    this.documentCV.notify();
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    throw throwable;
                }
            }
            Object var2_2 = null;
        }
    }

    public void remove(int n, int n2) throws BadLocationException {
        DefaultDocumentEvent defaultDocumentEvent = new DefaultDocumentEvent(this, n, n2, DocumentEvent.EventType.REMOVE);
        this.removeUpdate(defaultDocumentEvent);
        boolean bl = this.content.getString(n, n2).length() != 0;
        this.writeLock();
        UndoableEdit undoableEdit = this.content.remove(n, n2);
        this.writeUnlock();
        this.postRemoveUpdate(defaultDocumentEvent);
        if (bl) {
            this.fireRemoveUpdate(defaultDocumentEvent);
        }
    }

    public void replace(int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
        this.remove(n, n2);
        this.insertString(n, string, attributeSet);
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this.listenerList.add(AbstractDocument.class$("javax.swing.event.DocumentListener"), documentListener);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        this.listenerList.remove(AbstractDocument.class$("javax.swing.event.DocumentListener"), documentListener);
    }

    public DocumentListener[] getDocumentListeners() {
        return (DocumentListener[])this.getListeners(AbstractDocument.class$("javax.swing.event.DocumentListener"));
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listenerList.add(AbstractDocument.class$("javax.swing.event.UndoableEditListener"), undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listenerList.remove(AbstractDocument.class$("javax.swing.event.UndoableEditListener"), undoableEditListener);
    }

    public UndoableEditListener[] getUndoableEditListeners() {
        return (UndoableEditListener[])this.getListeners(AbstractDocument.class$("javax.swing.event.UndoableEditListener"));
    }

    protected void removeUpdate(DefaultDocumentEvent defaultDocumentEvent) {
    }

    public void render(Runnable runnable) {
        this.readLock();
        try {
            runnable.run();
        }
        finally {
            Object var2_2 = null;
            this.readUnlock();
        }
    }

    public void setAsynchronousLoadPriority(int n) {
    }

    public void setDocumentProperties(Dictionary dictionary) {
        this.properties = dictionary;
    }

    protected void writeLock() {
        if (this.currentWriter != null && this.currentWriter.equals(Thread.currentThread())) {
            return;
        }
        Object object = this.documentCV;
        synchronized (object) {
            try {
                ++this.numWritersWaiting;
                while (this.numReaders > 0) {
                    try {
                        this.documentCV.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new Error("interruped while trying to obtain write lock");
                    }
                }
                --this.numWritersWaiting;
                this.currentWriter = Thread.currentThread();
            }
            finally {
                Object var2_3 = null;
            }
            return;
        }
    }

    protected void writeUnlock() {
        Object object = this.documentCV;
        synchronized (object) {
            block3: {
                try {
                    if (!Thread.currentThread().equals(this.currentWriter)) break block3;
                    this.currentWriter = null;
                    this.documentCV.notifyAll();
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    throw throwable;
                }
            }
            Object var2_2 = null;
        }
    }

    public DocumentFilter getDocumentFilter() {
        return this.documentFilter;
    }

    public void setDocumentFilter(DocumentFilter documentFilter) {
        this.documentFilter = documentFilter;
    }

    public void dump(PrintStream printStream) {
        ((AbstractElement)this.getDefaultRootElement()).dump(printStream, 0);
    }

    public class LeafElement
    extends AbstractElement {
        private /* synthetic */ AbstractDocument this$0;
        private static final long serialVersionUID = -8906306331347768017L;
        Position startPos;
        Position endPos;

        public LeafElement(AbstractDocument abstractDocument, Element element, AttributeSet attributeSet, int n, int n2) {
            this.this$0 = abstractDocument;
            super(abstractDocument, element, attributeSet);
            try {
                if (element != null) {
                    this.startPos = element.getDocument().createPosition(n);
                    this.endPos = element.getDocument().createPosition(n2);
                } else {
                    this.startPos = abstractDocument.createPosition(n);
                    this.endPos = abstractDocument.createPosition(n2);
                }
            }
            catch (BadLocationException badLocationException) {
                AssertionError assertionError = new AssertionError((Object)("BadLocationException thrown here. start=" + n + ", end=" + n2 + ", length=" + abstractDocument.getLength()));
                ((Throwable)((Object)assertionError)).initCause(badLocationException);
                throw assertionError;
            }
        }

        public Enumeration children() {
            return null;
        }

        public boolean getAllowsChildren() {
            return false;
        }

        public Element getElement(int n) {
            return null;
        }

        public int getElementCount() {
            return 0;
        }

        public int getElementIndex(int n) {
            return -1;
        }

        public int getEndOffset() {
            return this.endPos.getOffset();
        }

        public String getName() {
            String string = super.getName();
            if (string == null) {
                string = AbstractDocument.ContentElementName;
            }
            return string;
        }

        public int getStartOffset() {
            return this.startPos.getOffset();
        }

        public boolean isLeaf() {
            return true;
        }

        public String toString() {
            return "LeafElement(" + this.getName() + ") " + this.getStartOffset() + "," + this.getEndOffset() + "\n";
        }
    }

    public static class ElementEdit
    extends AbstractUndoableEdit
    implements DocumentEvent.ElementChange {
        private static final long serialVersionUID = -1216620962142928304L;
        private Element elem;
        private int index;
        private Element[] removed;
        private Element[] added;

        public ElementEdit(Element element, int n, Element[] elementArray, Element[] elementArray2) {
            this.elem = element;
            this.index = n;
            this.removed = elementArray;
            this.added = elementArray2;
        }

        public Element[] getChildrenAdded() {
            return this.added;
        }

        public Element[] getChildrenRemoved() {
            return this.removed;
        }

        public Element getElement() {
            return this.elem;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public class DefaultDocumentEvent
    extends CompoundEdit
    implements DocumentEvent {
        private /* synthetic */ AbstractDocument this$0;
        private static final long serialVersionUID = 5230037221564563284L;
        private int offset;
        private int length;
        private DocumentEvent.EventType type;
        Hashtable changes;

        public DefaultDocumentEvent(AbstractDocument abstractDocument, int n, int n2, DocumentEvent.EventType eventType) {
            this.this$0 = abstractDocument;
            this.offset = n;
            this.length = n2;
            this.type = eventType;
            this.changes = new Hashtable();
        }

        public boolean addEdit(UndoableEdit undoableEdit) {
            if (undoableEdit instanceof DocumentEvent.ElementChange) {
                DocumentEvent.ElementChange elementChange = (DocumentEvent.ElementChange)((Object)undoableEdit);
                this.changes.put(elementChange.getElement(), elementChange);
            }
            return super.addEdit(undoableEdit);
        }

        public Document getDocument() {
            return this.this$0;
        }

        public int getLength() {
            return this.length;
        }

        public int getOffset() {
            return this.offset;
        }

        public DocumentEvent.EventType getType() {
            return this.type;
        }

        public DocumentEvent.ElementChange getChange(Element element) {
            return (DocumentEvent.ElementChange)this.changes.get(element);
        }
    }

    public class BranchElement
    extends AbstractElement {
        private /* synthetic */ AbstractDocument this$0;
        private static final long serialVersionUID = -6037216547466333183L;
        private Element[] children;

        private /* synthetic */ void finit$() {
            this.children = new Element[0];
        }

        public BranchElement(AbstractDocument abstractDocument, Element element, AttributeSet attributeSet) {
            this.this$0 = abstractDocument;
            super(abstractDocument, element, attributeSet);
            this.finit$();
        }

        public Enumeration children() {
            if (this.children.length == 0) {
                return null;
            }
            Vector vector = new Vector();
            for (int i = 0; i < this.children.length; ++i) {
                vector.add(this.children[i]);
            }
            return vector.elements();
        }

        public boolean getAllowsChildren() {
            return true;
        }

        public Element getElement(int n) {
            if (n < 0 || n >= this.children.length) {
                return null;
            }
            return this.children[n];
        }

        public int getElementCount() {
            return this.children.length;
        }

        public int getElementIndex(int n) {
            if (n < this.getStartOffset()) {
                return 0;
            }
            for (int i = 0; i < this.children.length - 1; ++i) {
                Element element = this.children[i];
                if (element.getStartOffset() <= n && n < element.getEndOffset()) {
                    return i;
                }
                if (this.children[i + 1].getStartOffset() <= n) continue;
                if (n - element.getEndOffset() > this.children[i + 1].getStartOffset() - n) {
                    return i + 1;
                }
                return i;
            }
            return this.getElementCount() - 1;
        }

        public int getEndOffset() {
            if (this.getElementCount() == 0) {
                throw new NullPointerException("This BranchElement has no children.");
            }
            return this.children[this.children.length - 1].getEndOffset();
        }

        public String getName() {
            return AbstractDocument.ParagraphElementName;
        }

        public int getStartOffset() {
            if (this.getElementCount() == 0) {
                throw new NullPointerException("This BranchElement has no children.");
            }
            return this.children[0].getStartOffset();
        }

        public boolean isLeaf() {
            return false;
        }

        public Element positionToElement(int n) {
            for (int i = 0; i < this.children.length; ++i) {
                Element element = this.children[i];
                if (element.getStartOffset() > n || n >= element.getEndOffset()) continue;
                return element;
            }
            return null;
        }

        public void replace(int n, int n2, Element[] elementArray) {
            Element[] elementArray2 = new Element[this.children.length - n2 + elementArray.length];
            System.arraycopy(this.children, 0, elementArray2, 0, n);
            System.arraycopy(elementArray, 0, elementArray2, n, elementArray.length);
            System.arraycopy(this.children, n + n2, elementArray2, n + elementArray.length, this.children.length - n - n2);
            this.children = elementArray2;
        }

        public String toString() {
            return "BranchElement(" + this.getName() + ") " + this.getStartOffset() + "," + this.getEndOffset() + "\n";
        }
    }

    public abstract class AbstractElement
    implements Element,
    MutableAttributeSet,
    TreeNode,
    Serializable {
        private /* synthetic */ AbstractDocument this$0;
        private static final long serialVersionUID = 1712240033321461704L;
        int count;
        int offset;
        AttributeSet attributes;
        Element element_parent;
        TreeNode tree_parent;
        Vector tree_children;

        public AbstractElement(AbstractDocument abstractDocument, Element element, AttributeSet attributeSet) {
            this.this$0 = abstractDocument;
            this.element_parent = element;
            AttributeContext attributeContext = abstractDocument.getAttributeContext();
            this.attributes = attributeContext.getEmptySet();
            if (attributeSet != null) {
                this.attributes = attributeContext.addAttributes(this.attributes, attributeSet);
            }
        }

        public abstract Enumeration children();

        public abstract boolean getAllowsChildren();

        public TreeNode getChildAt(int n) {
            return (TreeNode)this.tree_children.get(n);
        }

        public int getChildCount() {
            return this.tree_children.size();
        }

        public int getIndex(TreeNode treeNode) {
            return this.tree_children.indexOf(treeNode);
        }

        public TreeNode getParent() {
            return this.tree_parent;
        }

        public abstract boolean isLeaf();

        public void addAttribute(Object object, Object object2) {
            this.attributes = this.this$0.getAttributeContext().addAttribute(this.attributes, object, object2);
        }

        public void addAttributes(AttributeSet attributeSet) {
            this.attributes = this.this$0.getAttributeContext().addAttributes(this.attributes, attributeSet);
        }

        public void removeAttribute(Object object) {
            this.attributes = this.this$0.getAttributeContext().removeAttribute(this.attributes, object);
        }

        public void removeAttributes(AttributeSet attributeSet) {
            this.attributes = this.this$0.getAttributeContext().removeAttributes(this.attributes, attributeSet);
        }

        public void removeAttributes(Enumeration enumeration) {
            this.attributes = this.this$0.getAttributeContext().removeAttributes(this.attributes, enumeration);
        }

        public void setResolveParent(AttributeSet attributeSet) {
            this.attributes = this.this$0.getAttributeContext().addAttribute(this.attributes, AttributeSet.ResolveAttribute, attributeSet);
        }

        public boolean containsAttribute(Object object, Object object2) {
            return this.attributes.containsAttribute(object, object2);
        }

        public boolean containsAttributes(AttributeSet attributeSet) {
            return this.attributes.containsAttributes(attributeSet);
        }

        public AttributeSet copyAttributes() {
            return this.attributes.copyAttributes();
        }

        public Object getAttribute(Object object) {
            return this.attributes.getAttribute(object);
        }

        public int getAttributeCount() {
            return this.attributes.getAttributeCount();
        }

        public Enumeration getAttributeNames() {
            return this.attributes.getAttributeNames();
        }

        public AttributeSet getResolveParent() {
            if (this.attributes.getResolveParent() != null) {
                return this.attributes.getResolveParent();
            }
            return this.element_parent.getAttributes();
        }

        public boolean isDefined(Object object) {
            return this.attributes.isDefined(object);
        }

        public boolean isEqual(AttributeSet attributeSet) {
            return this.attributes.isEqual(attributeSet);
        }

        public AttributeSet getAttributes() {
            return this;
        }

        public Document getDocument() {
            return this.this$0;
        }

        public abstract Element getElement(int var1);

        public String getName() {
            return (String)this.getAttribute(AttributeSet.NameAttribute);
        }

        public Element getParentElement() {
            return this.element_parent;
        }

        public abstract int getEndOffset();

        public abstract int getElementCount();

        public abstract int getElementIndex(int var1);

        public abstract int getStartOffset();

        public void dump(PrintStream printStream, int n) {
            Object object;
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            for (n2 = 0; n2 < n; ++n2) {
                stringBuffer.append(' ');
            }
            stringBuffer.append('<');
            stringBuffer.append(this.getName());
            if (this.getAttributeCount() > 0) {
                stringBuffer.append('\n');
                Enumeration enumeration = this.getAttributeNames();
                while (enumeration.hasMoreElements()) {
                    for (int i = 0; i < n + 2; ++i) {
                        stringBuffer.append(' ');
                    }
                    Object object2 = enumeration.nextElement();
                    stringBuffer.append(object2);
                    stringBuffer.append('=');
                    object = this.getAttribute(object2);
                    stringBuffer.append(object);
                    stringBuffer.append('\n');
                }
            }
            stringBuffer.append(">\n");
            if (this.isLeaf()) {
                for (n2 = 0; n2 < n + 2; ++n2) {
                    stringBuffer.append(' ');
                }
                n2 = this.getStartOffset();
                int n3 = this.getEndOffset();
                stringBuffer.append('[');
                stringBuffer.append(n2);
                stringBuffer.append(',');
                stringBuffer.append(n3);
                stringBuffer.append("][");
                try {
                    stringBuffer.append(this.getDocument().getText(n2, n3 - n2));
                }
                catch (BadLocationException badLocationException) {
                    AssertionError assertionError = new AssertionError((Object)"BadLocationException must not be thrown here.");
                    ((Throwable)((Object)assertionError)).initCause(badLocationException);
                    throw assertionError;
                }
                stringBuffer.append("]\n");
            }
            printStream.print(stringBuffer.toString());
            n2 = this.getElementCount();
            for (int i = 0; i < n2; ++i) {
                object = this.getElement(i);
                if (!(object instanceof AbstractElement)) continue;
                ((AbstractElement)object).dump(printStream, n + 2);
            }
        }
    }

    public static interface Content {
        public Position createPosition(int var1) throws BadLocationException;

        public int length();

        public UndoableEdit insertString(int var1, String var2) throws BadLocationException;

        public UndoableEdit remove(int var1, int var2) throws BadLocationException;

        public String getString(int var1, int var2) throws BadLocationException;

        public void getChars(int var1, int var2, Segment var3) throws BadLocationException;
    }

    public static interface AttributeContext {
        public AttributeSet addAttribute(AttributeSet var1, Object var2, Object var3);

        public AttributeSet addAttributes(AttributeSet var1, AttributeSet var2);

        public AttributeSet getEmptySet();

        public void reclaim(AttributeSet var1);

        public AttributeSet removeAttribute(AttributeSet var1, Object var2);

        public AttributeSet removeAttributes(AttributeSet var1, AttributeSet var2);

        public AttributeSet removeAttributes(AttributeSet var1, Enumeration var2);
    }
}

