/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class GapContent
implements AbstractDocument.Content,
Serializable {
    private static final long serialVersionUID = -6226052713477823730L;
    static final int DEFAULT_BUFSIZE = 10;
    char[] buffer;
    int gapStart;
    int gapEnd;
    ArrayList positions;
    private static final /* synthetic */ boolean $assertionsDisabled;

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public GapContent() {
        this(10);
    }

    public GapContent(int n) {
        this.buffer = (char[])this.allocateArray(n);
        this.gapStart = 1;
        this.gapEnd = n;
        this.buffer[0] = 10;
        this.positions = new ArrayList();
    }

    protected Object allocateArray(int n) {
        return new char[n];
    }

    protected int getArrayLength() {
        return this.buffer.length;
    }

    public int length() {
        return this.buffer.length - (this.gapEnd - this.gapStart);
    }

    public UndoableEdit insertString(int n, String string) throws BadLocationException {
        int n2 = this.length();
        int n3 = string.length();
        if (n >= n2) {
            throw new BadLocationException("the where argument cannot be greater than the content length", n);
        }
        this.replace(n, 0, string.toCharArray(), n3);
        return new UndoInsertString(this, n, n3);
    }

    public UndoableEdit remove(int n, int n2) throws BadLocationException {
        int n3 = this.length();
        if (n >= n3) {
            throw new BadLocationException("the where argument cannot be greater than the content length", n);
        }
        if (n + n2 > n3) {
            throw new BadLocationException("where + nitems cannot be greater than the content length", n + n2);
        }
        String string = this.getString(n, n2);
        this.replace(n, n2, null, 0);
        return new UndoRemove(this, n, string);
    }

    public String getString(int n, int n2) throws BadLocationException {
        Segment segment = new Segment();
        try {
            this.getChars(n, n2, segment);
            return new String(segment.array, segment.offset, segment.count);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            int n3 = 0;
            n3 = segment.offset < 0 || segment.offset >= segment.array.length ? segment.offset : segment.offset + segment.count;
            throw new BadLocationException("Illegal location: array.length = " + segment.array.length + ", offset = " + segment.offset + ", count = " + segment.count, n3);
        }
    }

    public void getChars(int n, int n2, Segment segment) throws BadLocationException {
        int n3 = this.length();
        if (n >= n3) {
            throw new BadLocationException("the where argument cannot be greater than the content length", n);
        }
        if (n + n2 > n3) {
            throw new BadLocationException("len plus where cannot be greater than the content length", n2 + n);
        }
        if (n < this.gapStart && this.gapStart - n < n2) {
            char[] cArray = new char[n2];
            int n4 = this.gapStart - n;
            System.arraycopy(this.buffer, n, cArray, 0, n4);
            System.arraycopy(this.buffer, this.gapEnd, cArray, n4, n2 - n4);
            segment.array = cArray;
            segment.offset = 0;
            segment.count = n2;
        } else {
            segment.array = this.buffer;
            segment.offset = n < this.gapStart ? n : n + (this.gapEnd - this.gapStart);
            segment.count = n2;
        }
    }

    public Position createPosition(int n) throws BadLocationException {
        GapContentPosition gapContentPosition;
        int n2;
        if (n < 0 || n > this.length()) {
            throw new BadLocationException("The offset was out of the bounds of this buffer", n);
        }
        int n3 = n;
        if (n > this.gapStart) {
            n3 += this.gapEnd - this.gapStart;
        }
        if ((n2 = Collections.binarySearch(this.positions, gapContentPosition = new GapContentPosition(this, n3))) < 0) {
            n2 ^= 0xFFFFFFFF;
        }
        this.positions.add(n2, gapContentPosition);
        return gapContentPosition;
    }

    protected void shiftEnd(int n) {
        if (!$assertionsDisabled && this.gapEnd - this.gapStart >= n) {
            throw new AssertionError((Object)"The new gap size must be greater than the old gap size");
        }
        int n2 = n - this.gapEnd + this.gapStart;
        this.adjustPositionsInRange(this.gapEnd, this.buffer.length - this.gapEnd, n2);
        char[] cArray = (char[])this.allocateArray(this.length() + n);
        System.arraycopy(this.buffer, 0, cArray, 0, this.gapStart);
        System.arraycopy(this.buffer, this.gapEnd, cArray, this.gapStart + n, this.buffer.length - this.gapEnd);
        this.gapEnd = this.gapStart + n;
        this.buffer = cArray;
    }

    protected void shiftGap(int n) {
        if (n == this.gapStart) {
            return;
        }
        int n2 = n + this.gapEnd - this.gapStart;
        if (n < this.gapStart) {
            this.adjustPositionsInRange(n, this.gapStart - n, this.gapEnd - this.gapStart);
            System.arraycopy(this.buffer, n, this.buffer, n2, this.gapStart - n);
            this.gapStart = n;
            this.gapEnd = n2;
        } else {
            this.adjustPositionsInRange(this.gapEnd, n2 - this.gapEnd, this.gapStart - this.gapEnd);
            System.arraycopy(this.buffer, this.gapEnd, this.buffer, this.gapStart, n - this.gapStart);
            this.gapStart = n;
            this.gapEnd = n2;
        }
        if (this.gapStart == 0) {
            this.resetMarksAtZero();
        }
    }

    protected void shiftGapStartDown(int n) {
        if (n == this.gapStart) {
            return;
        }
        if (!$assertionsDisabled && this.gapStart <= n) {
            throw new AssertionError((Object)"The new gap start must be less than the old gap start.");
        }
        this.setPositionsInRange(n, this.gapStart - n, this.gapStart);
        this.gapStart = n;
    }

    protected void shiftGapEndUp(int n) {
        if (n == this.gapEnd) {
            return;
        }
        if (!$assertionsDisabled && this.gapEnd >= n) {
            throw new AssertionError((Object)"The new gap end must be greater than the old gap end.");
        }
        this.setPositionsInRange(this.gapEnd, n - this.gapEnd, n + 1);
        this.gapEnd = n;
    }

    protected Object getArray() {
        return this.buffer;
    }

    protected void replace(int n, int n2, Object object, int n3) {
        if (this.gapStart != n) {
            this.shiftGap(n);
        }
        if (n2 > 0) {
            this.shiftGapEndUp(this.gapEnd + n2);
        }
        if (this.gapEnd - this.gapStart <= n3) {
            this.shiftEnd((n3 - this.gapEnd + this.gapStart + 1) * 2 + this.gapEnd + 10);
        }
        if (object != null) {
            System.arraycopy(object, 0, this.buffer, this.gapStart, n3);
            this.gapStart += n3;
        }
    }

    protected final int getGapStart() {
        return this.gapStart;
    }

    protected final int getGapEnd() {
        return this.gapEnd;
    }

    protected Vector getPositionsInRange(Vector vector, int n, int n2) {
        Vector vector2 = vector;
        if (vector2 == null) {
            vector2 = new Vector();
        } else {
            vector2.clear();
        }
        int n3 = n + n2;
        int n4 = Collections.binarySearch(this.positions, new GapContentPosition(this, n));
        if (n4 < 0) {
            n4 ^= 0xFFFFFFFF;
        }
        ListIterator listIterator = this.positions.listIterator(n4);
        while (listIterator.hasNext()) {
            GapContentPosition gapContentPosition = (GapContentPosition)listIterator.next();
            if (gapContentPosition.mark > n3) break;
            if (gapContentPosition.mark < n || gapContentPosition.mark > n3) continue;
            vector2.add(gapContentPosition);
        }
        return vector2;
    }

    void setPositionsInRange(int n, int n2, int n3) {
        int n4 = n + n2;
        int n5 = Collections.binarySearch(this.positions, new GapContentPosition(this, n));
        if (n5 < 0) {
            n5 ^= 0xFFFFFFFF;
        }
        ListIterator listIterator = this.positions.listIterator(n5);
        while (listIterator.hasNext()) {
            GapContentPosition gapContentPosition = (GapContentPosition)listIterator.next();
            if (gapContentPosition.mark > n4) break;
            if (gapContentPosition.mark < n || gapContentPosition.mark > n4) continue;
            gapContentPosition.mark = n3;
        }
    }

    void adjustPositionsInRange(int n, int n2, int n3) {
        int n4 = n + n2;
        int n5 = Collections.binarySearch(this.positions, new GapContentPosition(this, n));
        if (n5 < 0) {
            n5 ^= 0xFFFFFFFF;
        }
        ListIterator listIterator = this.positions.listIterator(n5);
        while (listIterator.hasNext()) {
            GapContentPosition gapContentPosition = (GapContentPosition)listIterator.next();
            if (gapContentPosition.mark > n4) break;
            if (gapContentPosition.mark < n || gapContentPosition.mark > n4) continue;
            gapContentPosition.mark += n3;
        }
    }

    protected void resetMarksAtZero() {
        if (this.gapStart != 0) {
            return;
        }
        this.setPositionsInRange(this.gapEnd, 0, 0);
    }

    private void dump() {
        System.err.println("GapContent debug information");
        System.err.println("buffer length: " + this.buffer.length);
        System.err.println("gap start: " + this.gapStart);
        System.err.println("gap end: " + this.gapEnd);
        for (int i = 0; i < this.buffer.length; ++i) {
            if (i == this.gapStart) {
                System.err.print('<');
            }
            if (i == this.gapEnd) {
                System.err.print('>');
            }
            if (!Character.isISOControl(this.buffer[i])) {
                System.err.print(this.buffer[i]);
                continue;
            }
            System.err.print('.');
        }
        System.err.println();
    }

    private void dumpPositions() {
        Iterator iterator = this.positions.iterator();
        while (iterator.hasNext()) {
            GapContentPosition gapContentPosition = (GapContentPosition)iterator.next();
            System.err.println("position at: " + gapContentPosition.mark);
        }
    }

    static {
        $assertionsDisabled = GapContent.class$("javax.swing.text.GapContent").desiredAssertionStatus() ^ true;
    }

    class UndoRemove
    extends AbstractUndoableEdit {
        private /* synthetic */ GapContent this$0;
        public int where;
        String text;

        public UndoRemove(GapContent gapContent, int n, String string) {
            this.this$0 = gapContent;
            this.where = n;
            this.text = string;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            try {
                this.this$0.insertString(this.where, this.text);
            }
            catch (BadLocationException badLocationException) {
                throw new CannotUndoException();
            }
        }

        public void redo() throws CannotUndoException {
            super.redo();
            try {
                this.this$0.remove(this.where, this.text.length());
            }
            catch (BadLocationException badLocationException) {
                throw new CannotRedoException();
            }
        }
    }

    class UndoInsertString
    extends AbstractUndoableEdit {
        private /* synthetic */ GapContent this$0;
        public int where;
        public int length;
        String text;

        public UndoInsertString(GapContent gapContent, int n, int n2) {
            this.this$0 = gapContent;
            this.where = n;
            this.length = n2;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            try {
                this.text = this.this$0.getString(this.where, this.length);
                this.this$0.remove(this.where, this.length);
            }
            catch (BadLocationException badLocationException) {
                throw new CannotUndoException();
            }
        }

        public void redo() throws CannotUndoException {
            super.redo();
            try {
                this.this$0.insertString(this.where, this.text);
            }
            catch (BadLocationException badLocationException) {
                throw new CannotRedoException();
            }
        }
    }

    class GapContentPosition
    implements Position,
    Comparable {
        private /* synthetic */ GapContent this$0;
        int mark;
        private static final /* synthetic */ boolean $assertionsDisabled;

        GapContentPosition(GapContent gapContent, int n) {
            this.this$0 = gapContent;
            this.mark = n;
        }

        public int compareTo(Object object) {
            if (object instanceof Integer) {
                int n = (Integer)object;
                return this.mark - n;
            }
            GapContentPosition gapContentPosition = (GapContentPosition)object;
            return this.mark - gapContentPosition.mark;
        }

        public int getOffset() {
            if (!$assertionsDisabled && this.mark > this.this$0.gapStart && this.mark < this.this$0.gapEnd) {
                throw new AssertionError((Object)("mark: " + this.mark + ", gapStart: " + this.this$0.gapStart + ", gapEnd: " + this.this$0.gapEnd));
            }
            if (this.mark <= this.this$0.gapStart) {
                return this.mark;
            }
            return this.mark - (this.this$0.gapEnd - this.this$0.gapStart);
        }

        static {
            $assertionsDisabled = GapContent.class$("javax.swing.text.GapContent$GapContentPosition").desiredAssertionStatus() ^ true;
        }
    }
}

