/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.FlowView;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabExpander;
import javax.swing.text.TabSet;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class ParagraphView
extends FlowView
implements TabExpander {
    protected int firstLineIndent;
    private int justification;
    private float lineSpacing;
    private TabSet tabSet;

    public ParagraphView(Element element) {
        super(element, 1);
    }

    public float nextTabStop(float f, int n) {
        throw new InternalError("Not implemented yet");
    }

    protected View createRow() {
        return new Row(this, this.getElement());
    }

    public float getAlignment(int n) {
        if (n == 0) {
            return 0.0f;
        }
        if (this.getViewCount() > 0) {
            float f = this.getPreferredSpan(1);
            float f2 = this.getView(0).getPreferredSpan(1);
            return f2 / 2.0f / f;
        }
        return 0.0f;
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.setPropertiesFromAttributes();
    }

    protected void setPropertiesFromAttributes() {
        Element element = this.getElement();
        AttributeSet attributeSet = element.getAttributes();
        this.setFirstLineIndent(StyleConstants.getFirstLineIndent(attributeSet));
        this.setLineSpacing(StyleConstants.getLineSpacing(attributeSet));
        this.setJustification(StyleConstants.getAlignment(attributeSet));
        this.tabSet = StyleConstants.getTabSet(attributeSet);
    }

    protected void setFirstLineIndent(float f) {
        this.firstLineIndent = (int)f;
    }

    protected void setJustification(int n) {
        this.justification = n;
    }

    protected void setLineSpacing(float f) {
        this.lineSpacing = f;
    }

    protected View getLayoutView(int n) {
        return this.layoutPool.getView(n);
    }

    protected int getLayoutViewCount() {
        return this.layoutPool.getViewCount();
    }

    protected TabSet getTabSet() {
        return this.tabSet;
    }

    class Row
    extends BoxView {
        private /* synthetic */ ParagraphView this$0;

        Row(ParagraphView paragraphView, Element element) {
            this.this$0 = paragraphView;
            super(element, 0);
        }

        public float getAlignment(int n) {
            return 0.0f;
        }
    }
}

