/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class PlainView
extends View
implements TabExpander {
    Color selectedColor;
    Color unselectedColor;
    Color disabledColor;
    Font font;
    float maxLineLength;
    Element longestLine;
    protected FontMetrics metrics;
    private transient Segment lineBuffer;

    private /* synthetic */ void finit$() {
        this.maxLineLength = -1.0f;
        this.longestLine = null;
    }

    public PlainView(Element element) {
        super(element);
        this.finit$();
    }

    protected void updateMetrics() {
        Container container = this.getContainer();
        Font font = container.getFont();
        if (this.font != font) {
            this.font = font;
            this.metrics = container.getFontMetrics(font);
        }
    }

    protected Rectangle lineToRect(Shape shape, int n) {
        this.updateMetrics();
        Rectangle rectangle = shape.getBounds();
        int n2 = this.metrics.getHeight();
        return new Rectangle(rectangle.x, rectangle.y + n * n2, rectangle.width, n2);
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        this.updateMetrics();
        Document document = this.getDocument();
        int n2 = this.getElement().getElementIndex(n);
        Rectangle rectangle = this.lineToRect(shape, n2);
        Element element = this.getElement().getElement(n2);
        int n3 = element.getStartOffset();
        Segment segment = this.getLineBuffer();
        document.getText(n3, n - n3, segment);
        int n4 = Utilities.getTabbedTextWidth(segment, this.metrics, rectangle.x, this, n3);
        rectangle.x += n4;
        rectangle.width = 1;
        rectangle.height = this.metrics.getHeight();
        return rectangle;
    }

    protected void drawLine(int n, Graphics graphics, int n2, int n3) {
        try {
            this.metrics = graphics.getFontMetrics();
            Element element = this.getElement().getElement(n);
            this.drawUnselectedText(graphics, n2, n3, element.getStartOffset(), element.getEndOffset());
        }
        catch (BadLocationException badLocationException) {
            AssertionError assertionError = new AssertionError((Object)"Unexpected bad location");
            ((Throwable)((Object)assertionError)).initCause(badLocationException);
            throw assertionError;
        }
    }

    protected int drawSelectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        graphics.setColor(this.selectedColor);
        Segment segment = this.getLineBuffer();
        this.getDocument().getText(n3, n4 - n3, segment);
        return Utilities.drawTabbedText(segment, n, n2, graphics, this, 0);
    }

    protected int drawUnselectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        JTextComponent jTextComponent = (JTextComponent)this.getContainer();
        if (jTextComponent.isEnabled()) {
            graphics.setColor(this.unselectedColor);
        } else {
            graphics.setColor(this.disabledColor);
        }
        Segment segment = this.getLineBuffer();
        this.getDocument().getText(n3, n4 - n3, segment);
        return Utilities.drawTabbedText(segment, n, n2, graphics, this, segment.offset);
    }

    public void paint(Graphics graphics, Shape shape) {
        this.updateMetrics();
        JTextComponent jTextComponent = (JTextComponent)this.getContainer();
        graphics.setFont(jTextComponent.getFont());
        this.selectedColor = jTextComponent.getSelectedTextColor();
        this.unselectedColor = jTextComponent.getForeground();
        this.disabledColor = jTextComponent.getDisabledTextColor();
        Rectangle rectangle = shape.getBounds();
        Document document = jTextComponent.getDocument();
        Element element = document.getDefaultRootElement();
        int n = rectangle.y;
        for (int i = 0; i < element.getElementCount(); ++i) {
            this.drawLine(i, graphics, rectangle.x, n);
            n += this.metrics.getHeight();
        }
    }

    protected int getTabSize() {
        Object object = this.getDocument().getProperty("tabSize");
        if (object == null) {
            return 8;
        }
        return (Integer)object;
    }

    public float nextTabStop(float f, int n) {
        float f2 = this.getTabSize() * this.metrics.charWidth('m');
        return (float)(Math.floor(f / f2) + 1.0) * f2;
    }

    float determineMaxLineLength() {
        if (this.maxLineLength != -1.0f) {
            return this.maxLineLength;
        }
        Element element = this.getElement();
        Segment segment = this.getLineBuffer();
        float f = 0.0f;
        for (int i = 0; i < element.getElementCount(); ++i) {
            int n;
            Element element2 = element.getElement(i);
            int n2 = element2.getStartOffset();
            int n3 = element2.getEndOffset();
            try {
                element.getDocument().getText(n2, n3 - n2, segment);
            }
            catch (BadLocationException badLocationException) {
                AssertionError assertionError = new AssertionError((Object)"Unexpected bad location");
                ((Throwable)((Object)assertionError)).initCause(badLocationException);
                throw assertionError;
            }
            if (segment == null || segment.array == null || segment.count == 0 || !((float)(n = this.metrics.charsWidth(segment.array, segment.offset, segment.count)) > f)) continue;
            this.longestLine = element2;
            f = n;
        }
        this.maxLineLength = f;
        return this.maxLineLength;
    }

    public float getPreferredSpan(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException();
        }
        this.updateMetrics();
        float f = 0.0f;
        Element element = this.getElement();
        switch (n) {
            case 0: {
                f = this.determineMaxLineLength();
            }
        }
        f = this.metrics.getHeight() * element.getElementCount();
        return f;
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        Rectangle rectangle = shape.getBounds();
        Document document = this.getDocument();
        Element element = document.getDefaultRootElement();
        int n = (int)(f2 - (float)rectangle.y) / this.metrics.getHeight();
        if (n >= element.getElementCount()) {
            return this.getEndOffset() - 1;
        }
        Element element2 = element.getElement(n);
        Segment segment = this.getLineBuffer();
        int n2 = element2.getStartOffset();
        int n3 = element2.getEndOffset() - 1;
        try {
            document.getText(n2, n3 - n2, segment);
        }
        catch (BadLocationException badLocationException) {
            AssertionError assertionError = new AssertionError((Object)"Unexpected bad location");
            ((Throwable)((Object)assertionError)).initCause(badLocationException);
            throw assertionError;
        }
        int n4 = Utilities.getTabbedTextOffset(segment, this.metrics, rectangle.x, (int)f, this, n2);
        return Math.max(0, n4);
    }

    protected void updateDamage(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Element element = this.getElement();
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        if (elementChange == null) {
            int n = this.getElement().getElementIndex(documentEvent.getOffset());
            this.damageLineRange(n, n, shape, this.getContainer());
            return;
        }
        Element[] elementArray = elementChange.getChildrenRemoved();
        Element[] elementArray2 = elementChange.getChildrenAdded();
        if (elementArray == null && elementArray2 == null) {
            int n = this.getElement().getElementIndex(documentEvent.getOffset());
            this.damageLineRange(n, n, shape, this.getContainer());
            return;
        }
        if (elementArray != null) {
            for (int i = 0; i < elementArray.length; ++i) {
                if (!elementArray[i].equals(this.longestLine)) continue;
                this.maxLineLength = -1.0f;
                this.determineMaxLineLength();
                ((JTextComponent)this.getContainer()).repaint();
                return;
            }
        }
        if (elementArray2 == null) {
            ((JTextComponent)this.getContainer()).repaint();
            return;
        }
        this.updateMetrics();
        Segment segment = this.getLineBuffer();
        float f = 0.0f;
        Element element2 = null;
        for (int i = 0; i < elementArray2.length; ++i) {
            int n;
            Element element3 = elementArray2[i];
            int n2 = element3.getStartOffset();
            int n3 = element3.getEndOffset();
            try {
                element.getDocument().getText(n2, n3 - n2, segment);
            }
            catch (BadLocationException badLocationException) {
                AssertionError assertionError = new AssertionError((Object)"Unexpected bad location");
                ((Throwable)((Object)assertionError)).initCause(badLocationException);
                throw assertionError;
            }
            if (segment == null || segment.array == null || segment.count == 0 || !((float)(n = this.metrics.charsWidth(segment.array, segment.offset, segment.count)) > f)) continue;
            element2 = element3;
            f = n;
        }
        if (f > this.maxLineLength) {
            this.maxLineLength = f;
            this.longestLine = element2;
        }
        ((JTextComponent)this.getContainer()).repaint();
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateDamage(documentEvent, shape, viewFactory);
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateDamage(documentEvent, shape, viewFactory);
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateDamage(documentEvent, shape, viewFactory);
    }

    protected void damageLineRange(int n, int n2, Shape shape, Component component) {
        if (shape == null) {
            return;
        }
        Rectangle rectangle = this.lineToRect(shape, n);
        Rectangle rectangle2 = this.lineToRect(shape, n2);
        if (rectangle == null || rectangle2 == null) {
            component.repaint();
        } else {
            Rectangle rectangle3 = rectangle.union(rectangle2);
            component.repaint();
        }
    }

    protected Segment getLineBuffer() {
        if (this.lineBuffer == null) {
            this.lineBuffer = new Segment();
        }
        return this.lineBuffer;
    }

    public int getNextVisualPositionFrom(JTextComponent jTextComponent, int n, Position.Bias bias, int n2, Position.Bias[] biasArray) throws BadLocationException {
        throw new AssertionError((Object)"Not implemented yet.");
    }
}

