/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.BreakIterator;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabExpander;
import javax.swing.text.View;

public class Utilities {
    private static final int BUF_LENGTH = 64;

    public static final int drawTabbedText(Segment segment, int n, int n2, Graphics graphics, TabExpander tabExpander, int n3) {
        char[] cArray = segment.array;
        int n4 = n;
        int n5 = n2;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n6 = fontMetrics.getAscent();
        int n7 = 0;
        int n8 = segment.offset;
        int n9 = 0;
        block4: for (int i = segment.offset; i < segment.offset + segment.count; ++i) {
            char c = cArray[i];
            if (c == '\t' || c == '\n') {
                if (n9 > 0) {
                    graphics.drawChars(cArray, n8, n9, n4, n5 + n6);
                    n4 += n7;
                    n7 = 0;
                }
                n8 = i + 1;
                n9 = 0;
            }
            switch (c) {
                case '\t': {
                    if (tabExpander != null) {
                        n4 = (int)tabExpander.nextTabStop(n4, n3 + i - segment.offset);
                        continue block4;
                    }
                    n4 += fontMetrics.charWidth(' ');
                    continue block4;
                }
                case '\n': {
                    n5 += fontMetrics.getHeight();
                    n4 = n;
                    continue block4;
                }
                default: {
                    ++n9;
                    n7 += fontMetrics.charWidth(cArray[i]);
                }
            }
        }
        if (n9 > 0) {
            graphics.drawChars(cArray, n8, n9, n4, n5 + n6);
        }
        return n4;
    }

    public static final int getTabbedTextWidth(Segment segment, FontMetrics fontMetrics, int n, TabExpander tabExpander, int n2) {
        char[] cArray = segment.array;
        int n3 = n;
        int n4 = 0;
        block4: for (int i = segment.offset; i < segment.offset + segment.count; ++i) {
            switch (cArray[i]) {
                case '\t': {
                    if (tabExpander != null) {
                        n3 = (int)tabExpander.nextTabStop(n3, n2 + i - segment.offset);
                        continue block4;
                    }
                    n3 += fontMetrics.charWidth(' ');
                    continue block4;
                }
                case '\n': {
                    n4 = Math.max(n4, (n3 += fontMetrics.charWidth(cArray[i])) - n);
                    n3 = n;
                    continue block4;
                }
                default: {
                    n3 += fontMetrics.charWidth(cArray[i]);
                }
            }
        }
        n4 = Math.max(n4, n3 - n);
        return n4;
    }

    public static final int getTabbedTextOffset(Segment segment, FontMetrics fontMetrics, int n, int n2, TabExpander tabExpander, int n3, boolean bl) {
        int n4;
        int n5 = n;
        for (n4 = n3; n4 < segment.count; ++n4) {
            char c = segment.array[segment.offset + n4];
            if (c == '\u0000') {
                if (bl) break;
                --n4;
                break;
            }
            n5 = c != '\t' ? (n5 += fontMetrics.charWidth(c)) : (tabExpander == null ? (n5 += fontMetrics.charWidth(' ')) : (int)tabExpander.nextTabStop(n5, n4));
            if (n5 <= n2) continue;
            if (bl) break;
            --n4;
            break;
        }
        return n4;
    }

    public static final int getTabbedTextOffset(Segment segment, FontMetrics fontMetrics, int n, int n2, TabExpander tabExpander, int n3) {
        return Utilities.getTabbedTextOffset(segment, fontMetrics, n, n2, tabExpander, n3, true);
    }

    public static final int getNextWord(JTextComponent jTextComponent, int n) throws BadLocationException {
        if (n < 0 || n > jTextComponent.getText().length() - 1) {
            throw new BadLocationException("invalid offset specified", n);
        }
        String string = jTextComponent.getText();
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(string);
        int n2 = breakIterator.following(n);
        int n3 = breakIterator.next();
        while (n3 != -1) {
            for (int i = n2; i < n3; ++i) {
                if (!Character.isLetter(string.charAt(i))) continue;
                return n2;
            }
            n2 = n3;
            n3 = breakIterator.next();
        }
        return -1;
    }

    public static final int getPreviousWord(JTextComponent jTextComponent, int n) throws BadLocationException {
        if (n < 0 || n > jTextComponent.getText().length() - 1) {
            throw new BadLocationException("invalid offset specified", n);
        }
        String string = jTextComponent.getText();
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(string);
        int n2 = breakIterator.preceding(n);
        int n3 = breakIterator.previous();
        while (n3 != -1) {
            for (int i = n2; i < n; ++i) {
                if (!Character.isLetter(string.charAt(i))) continue;
                return n2;
            }
            n2 = n3;
            n3 = breakIterator.previous();
        }
        return 0;
    }

    public static final int getWordStart(JTextComponent jTextComponent, int n) throws BadLocationException {
        if (n < 0 || n >= jTextComponent.getText().length()) {
            throw new BadLocationException("invalid offset specified", n);
        }
        String string = jTextComponent.getText();
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(string);
        if (breakIterator.isBoundary(n)) {
            return n;
        }
        return breakIterator.preceding(n);
    }

    public static final int getWordEnd(JTextComponent jTextComponent, int n) throws BadLocationException {
        if (n < 0 || n >= jTextComponent.getText().length()) {
            throw new BadLocationException("invalid offset specified", n);
        }
        String string = jTextComponent.getText();
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(string);
        return breakIterator.following(n);
    }

    public static final int getRowEnd(JTextComponent jTextComponent, int n) throws BadLocationException {
        String string = jTextComponent.getText();
        if (string == null) {
            return -1;
        }
        int n2 = n + (string.length() - 1 - n) / 2;
        int n3 = n;
        int n4 = string.length() + 1;
        while (true) {
            if (jTextComponent.modelToView((int)n2).y != jTextComponent.modelToView((int)n).y) {
                n4 = n2;
                if (n4 != (n2 = n3 + (n2 + 1 - n3) / 2)) continue;
                return n2 - 1;
            }
            n3 = n2;
            if (n3 == (n2 += (n4 - n2) / 2)) break;
        }
        return n3;
    }

    public static final int getRowStart(JTextComponent jTextComponent, int n) throws BadLocationException {
        String string = jTextComponent.getText();
        if (string == null) {
            return -1;
        }
        int n2 = n;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            if (jTextComponent.modelToView((int)n3).y != jTextComponent.modelToView((int)n).y) {
                n4 = n3;
                if (n4 != (n3 = n2 - (n2 + 1 - n3) / 2)) continue;
                return n3 + 1;
            }
            if ((n3 -= (n3 - n4) / 2) == (n2 = n3)) break;
        }
        return n3;
    }

    public static final int getBreakLocation(Segment segment, FontMetrics fontMetrics, int n, int n2, TabExpander tabExpander, int n3) {
        int n4 = Utilities.getTabbedTextOffset(segment, fontMetrics, n, n2, tabExpander, n3);
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(segment.toString());
        if (n4 == segment.count) {
            return n4;
        }
        int n5 = breakIterator.preceding(n4 + 1);
        if (n5 != 0) {
            return n5;
        }
        return n4;
    }

    public static final Element getParagraphElement(JTextComponent jTextComponent, int n) {
        Document document = jTextComponent.getDocument();
        Element element = null;
        if (document instanceof StyledDocument) {
            StyledDocument styledDocument = (StyledDocument)document;
            element = styledDocument.getParagraphElement(n);
        } else {
            Element element2 = jTextComponent.getDocument().getDefaultRootElement();
            int n2 = element2.getElementIndex(n);
            element = element2.getElement(n2);
        }
        return element;
    }

    public static final int getPositionAbove(JTextComponent jTextComponent, int n, int n2) throws BadLocationException {
        View view = jTextComponent.getUI().getRootView(jTextComponent);
        Rectangle rectangle = jTextComponent.modelToView(n);
        int n3 = jTextComponent.viewToModel(new Point(n2, rectangle.y));
        int n4 = view.getNextVisualPositionFrom(jTextComponent, n3, Position.Bias.Forward, 1, new Position.Bias[1]);
        return n4;
    }

    public static final int getPositionBelow(JTextComponent jTextComponent, int n, int n2) throws BadLocationException {
        View view = jTextComponent.getUI().getRootView(jTextComponent);
        Rectangle rectangle = jTextComponent.modelToView(n);
        int n3 = jTextComponent.viewToModel(new Point(n2, rectangle.y));
        int n4 = view.getNextVisualPositionFrom(jTextComponent, n3, Position.Bias.Forward, 5, new Position.Bias[1]);
        return n4;
    }
}

