/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SwingConstants;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.ViewFactory;

public abstract class View
implements SwingConstants {
    public static final int BadBreakWeight = 0;
    public static final int ExcellentBreakWeight = 2000;
    public static final int ForcedBreakWeight = 3000;
    public static final int GoodBreakWeight = 1000;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    private float width;
    private float height;
    private Element elt;
    private View parent;

    public View(Element element) {
        this.elt = element;
    }

    public abstract void paint(Graphics var1, Shape var2);

    public void setParent(View view) {
        this.parent = view;
    }

    public View getParent() {
        return this.parent;
    }

    public Container getContainer() {
        View view = this.getParent();
        if (view == null) {
            return null;
        }
        return view.getContainer();
    }

    public Document getDocument() {
        return this.getElement().getDocument();
    }

    public Element getElement() {
        return this.elt;
    }

    public abstract float getPreferredSpan(int var1);

    public int getResizeWeight(int n) {
        return 0;
    }

    public float getMaximumSpan(int n) {
        if (this.getResizeWeight(n) <= 0) {
            return this.getPreferredSpan(n);
        }
        return 2.1474836E9f;
    }

    public float getMinimumSpan(int n) {
        if (this.getResizeWeight(n) <= 0) {
            return this.getPreferredSpan(n);
        }
        return 2.1474836E9f;
    }

    public void setSize(float f, float f2) {
    }

    public float getAlignment(int n) {
        return 0.5f;
    }

    public AttributeSet getAttributes() {
        return this.getElement().getAttributes();
    }

    public boolean isVisible() {
        return true;
    }

    public int getViewCount() {
        return 0;
    }

    public View getView(int n) {
        return null;
    }

    public ViewFactory getViewFactory() {
        View view = this.getParent();
        if (view != null) {
            return view.getViewFactory();
        }
        return null;
    }

    public void replace(int n, int n2, View[] viewArray) {
    }

    public void insert(int n, View view) {
        View[] viewArray = new View[]{view};
        this.replace(n, 1, viewArray);
    }

    public void append(View view) {
        View[] viewArray = new View[]{view};
        int n = this.getViewCount();
        this.replace(n, 0, viewArray);
    }

    public void removeAll() {
        this.replace(0, this.getViewCount(), new View[0]);
    }

    public void remove(int n) {
        this.replace(n, 1, null);
    }

    public View createFragment(int n, int n2) {
        return this;
    }

    public int getStartOffset() {
        return this.getElement().getStartOffset();
    }

    public int getEndOffset() {
        return this.getElement().getEndOffset();
    }

    public Shape getChildAllocation(int n, Shape shape) {
        return null;
    }

    public int getViewIndex(float f, float f2, Shape shape) {
        return -1;
    }

    public String getToolTipText(float f, float f2, Shape shape) {
        int n = this.getViewIndex(f, f2, shape);
        if (n < -1) {
            return null;
        }
        Shape shape2 = this.getChildAllocation(n, shape);
        if (shape2.getBounds().contains(f, f2)) {
            return this.getView(n).getToolTipText(f, f2, shape2);
        }
        return null;
    }

    public Graphics getGraphics() {
        return this.getContainer().getGraphics();
    }

    public void preferenceChanged(View view, boolean bl, boolean bl2) {
        if (this.parent != null) {
            this.parent.preferenceChanged(this, bl, bl2);
        }
    }

    public int getBreakWeight(int n, float f, float f2) {
        return 0;
    }

    public View breakView(int n, int n2, float f, float f2) {
        return this;
    }

    public int getViewIndex(int n, Position.Bias bias) {
        return -1;
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Element element = this.getElement();
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        if (elementChange != null) {
            this.updateChildren(elementChange, documentEvent, viewFactory);
        }
        this.forwardUpdate(elementChange, documentEvent, shape, viewFactory);
        this.updateLayout(elementChange, documentEvent, shape);
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Element element = this.getElement();
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        if (elementChange != null) {
            this.updateChildren(elementChange, documentEvent, viewFactory);
        }
        this.forwardUpdate(elementChange, documentEvent, shape, viewFactory);
        this.updateLayout(elementChange, documentEvent, shape);
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Element element = this.getElement();
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        if (elementChange != null) {
            this.updateChildren(elementChange, documentEvent, viewFactory);
        }
        this.forwardUpdate(elementChange, documentEvent, shape, viewFactory);
        this.updateLayout(elementChange, documentEvent, shape);
    }

    protected boolean updateChildren(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, ViewFactory viewFactory) {
        Element[] elementArray = elementChange.getChildrenAdded();
        Element[] elementArray2 = elementChange.getChildrenRemoved();
        int n = elementChange.getIndex();
        View[] viewArray = new View[elementArray.length];
        for (int i = 0; i < elementArray.length; ++i) {
            viewArray[i] = viewFactory.create(elementArray[i]);
        }
        this.replace(n, elementArray2.length, viewArray);
        return true;
    }

    protected void forwardUpdate(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        int n = this.getViewCount();
        for (int i = 0; i < n; ++i) {
            View view = this.getView(i);
            this.forwardUpdateToView(view, documentEvent, shape, viewFactory);
        }
    }

    protected void forwardUpdateToView(View view, DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        DocumentEvent.EventType eventType = documentEvent.getType();
        if (eventType == DocumentEvent.EventType.INSERT) {
            view.insertUpdate(documentEvent, shape, viewFactory);
        } else if (eventType == DocumentEvent.EventType.REMOVE) {
            view.removeUpdate(documentEvent, shape, viewFactory);
        } else if (eventType == DocumentEvent.EventType.CHANGE) {
            view.changedUpdate(documentEvent, shape, viewFactory);
        }
    }

    protected void updateLayout(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, Shape shape) {
        Rectangle rectangle = shape.getBounds();
        if (elementChange != null) {
            this.preferenceChanged(this, true, true);
        }
    }

    public abstract Shape modelToView(int var1, Shape var2, Position.Bias var3) throws BadLocationException;

    public Shape modelToView(int n, Position.Bias bias, int n2, Position.Bias bias2, Shape shape) throws BadLocationException {
        if (bias != Position.Bias.Forward && bias != Position.Bias.Backward) {
            throw new IllegalArgumentException("b1 must be either Position.Bias.Forward or Position.Bias.Backward");
        }
        if (bias2 != Position.Bias.Forward && bias2 != Position.Bias.Backward) {
            throw new IllegalArgumentException("b2 must be either Position.Bias.Forward or Position.Bias.Backward");
        }
        Shape shape2 = this.modelToView(n, shape, bias);
        Shape shape3 = this.modelToView(n2, shape, bias2);
        return shape2.getBounds().union(shape3.getBounds());
    }

    public Shape modelToView(int n, Shape shape) throws BadLocationException {
        return this.modelToView(n, shape, Position.Bias.Forward);
    }

    public abstract int viewToModel(float var1, float var2, Shape var3, Position.Bias[] var4);

    public int viewToModel(float f, float f2, Shape shape) {
        return this.viewToModel(f, f2, shape, new Position.Bias[0]);
    }

    void dump() {
        View view = this.getParent();
        if (view != null) {
            view.dump();
        } else {
            this.dump(0);
        }
    }

    void dump(int n) {
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            System.out.print('.');
        }
        System.out.println(this);
        n2 = this.getViewCount();
        for (int i = 0; i < n2; ++i) {
            this.getView(i).dump(n + 1);
        }
    }

    public abstract int getNextVisualPositionFrom(JTextComponent var1, int var2, Position.Bias var3, int var4, Position.Bias[] var5) throws BadLocationException;
}

