/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.rtf;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.swing.text.rtf.ControlWordToken;
import javax.swing.text.rtf.TextToken;
import javax.swing.text.rtf.Token;

class RTFScanner {
    private Reader in;
    private StringBuffer buffer = new StringBuffer();

    private RTFScanner() {
    }

    public RTFScanner(InputStream inputStream) {
        this();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        this.in = new BufferedReader(inputStreamReader);
    }

    public RTFScanner(Reader reader) {
        this();
        this.in = reader instanceof BufferedReader ? reader : new BufferedReader(reader);
    }

    public Token readToken() throws IOException {
        Token token = null;
        int n = this.in.read();
        switch (n) {
            case -1: {
                token = new Token(-1);
                break;
            }
            case 123: {
                token = new Token(1);
                break;
            }
            case 125: {
                token = new Token(2);
                break;
            }
            case 92: {
                this.buffer.delete(0, this.buffer.length());
                this.buffer.append((char)n);
                token = this.readControlWord();
                break;
            }
            default: {
                this.buffer.delete(0, this.buffer.length());
                this.buffer.append((char)n);
                token = this.readText();
            }
        }
        return token;
    }

    private Token readControlWord() throws IOException {
        boolean bl = true;
        String string = null;
        String string2 = null;
        while (true) {
            this.in.mark(1);
            int n = this.in.read();
            if (bl && n >= 97 && n <= 122) {
                this.buffer.append((char)n);
                continue;
            }
            if (n < 48 || n > 57) break;
            if (bl) {
                string = this.buffer.toString();
                this.buffer.delete(0, this.buffer.length());
                bl = false;
            }
            this.buffer.append((char)n);
        }
        if (bl) {
            string = this.buffer.toString();
        } else {
            string2 = this.buffer.toString();
        }
        this.buffer.delete(0, this.buffer.length());
        this.in.reset();
        ControlWordToken controlWordToken = null;
        controlWordToken = string2 == null ? new ControlWordToken(string) : new ControlWordToken(string, Integer.parseInt(string2));
        return controlWordToken;
    }

    private Token readText() throws IOException {
        boolean bl = true;
        block3: while (bl) {
            this.in.mark(1);
            int n = this.in.read();
            switch (n) {
                case -1: 
                case 92: 
                case 123: 
                case 125: {
                    bl = false;
                    this.in.reset();
                    continue block3;
                }
            }
            this.buffer.append((char)n);
        }
        String string = this.buffer.toString();
        TextToken textToken = new TextToken(string);
        this.buffer.delete(0, this.buffer.length());
        return textToken;
    }
}

