/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.stream;

import gnu.xml.stream.XMLInputFactoryImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;
import javax.xml.stream.EventFilter;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.XMLEventAllocator;
import javax.xml.transform.Source;

public abstract class XMLInputFactory {
    public static final String IS_NAMESPACE_AWARE = "javax.xml.stream.isNamespaceAware";
    public static final String IS_VALIDATING = "javax.xml.stream.isValidating";
    public static final String IS_COALESCING = "javax.xml.stream.isCoalescing";
    public static final String IS_REPLACING_ENTITY_REFERENCES = "javax.xml.stream.isReplacingEntityReferences";
    public static final String IS_SUPPORTING_EXTERNAL_ENTITIES = "javax.xml.stream.isSupportingExternalEntities";
    public static final String SUPPORT_DTD = "javax.xml.stream.supportDTD";
    public static final String REPORTER = "javax.xml.stream.reporter";
    public static final String RESOLVER = "javax.xml.stream.resolver";
    public static final String ALLOCATOR = "javax.xml.stream.allocator";

    protected XMLInputFactory() {
    }

    public static XMLInputFactory newInstance() throws FactoryConfigurationError {
        return XMLInputFactory.newInstance(null, null);
    }

    public static XMLInputFactory newInstance(String string, ClassLoader classLoader) throws FactoryConfigurationError {
        ClassLoader classLoader2 = classLoader;
        if (classLoader2 == null) {
            classLoader2 = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader2 == null) {
            classLoader2 = XMLInputFactory.class$("javax.xml.stream.XMLInputFactory").getClassLoader();
        }
        String string2 = null;
        int n = 0;
        do {
            if ((string2 = XMLInputFactory.getFactoryClassName(classLoader2, n++)) == null) continue;
            try {
                Class clazz = classLoader2 != null ? classLoader2.loadClass(string2) : Class.forName(string2);
                return (XMLInputFactory)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                string2 = null;
            }
            catch (Exception exception) {
                throw new FactoryConfigurationError(exception, "error instantiating class " + string2);
            }
        } while (string2 == null && n < 3);
        return new XMLInputFactoryImpl();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static String getFactoryClassName(ClassLoader classLoader, int n) {
        String string = "javax.xml.stream.XMLInputFactory";
        switch (n) {
            case 0: {
                return System.getProperty(string);
            }
            case 1: {
                try {
                    File file = new File(System.getProperty("java.home"));
                    file = new File(file, "lib");
                    file = new File(file, "stax.properties");
                    FileInputStream fileInputStream = new FileInputStream(file);
                    Properties properties = new Properties();
                    properties.load(fileInputStream);
                    ((InputStream)fileInputStream).close();
                    return properties.getProperty(string);
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            case 2: {
                try {
                    InputStream inputStream;
                    String string2 = "/META-INF/services/" + string;
                    InputStream inputStream2 = inputStream = classLoader != null ? classLoader.getResourceAsStream(string2) : XMLInputFactory.class$("javax.xml.stream.XMLInputFactory").getResourceAsStream(string2);
                    if (inputStream != null) {
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                        String string3 = bufferedReader.readLine();
                        bufferedReader.close();
                        return string3;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        }
        return null;
    }

    public abstract XMLStreamReader createXMLStreamReader(Reader var1) throws XMLStreamException;

    public abstract XMLStreamReader createXMLStreamReader(Source var1) throws XMLStreamException;

    public abstract XMLStreamReader createXMLStreamReader(InputStream var1) throws XMLStreamException;

    public abstract XMLStreamReader createXMLStreamReader(InputStream var1, String var2) throws XMLStreamException;

    public abstract XMLEventReader createXMLEventReader(Reader var1) throws XMLStreamException;

    public abstract XMLEventReader createXMLEventReader(XMLStreamReader var1) throws XMLStreamException;

    public abstract XMLEventReader createXMLEventReader(Source var1) throws XMLStreamException;

    public abstract XMLEventReader createXMLEventReader(InputStream var1) throws XMLStreamException;

    public abstract XMLEventReader createXMLEventReader(InputStream var1, String var2) throws XMLStreamException;

    public abstract XMLStreamReader createFilteredReader(XMLStreamReader var1, StreamFilter var2) throws XMLStreamException;

    public abstract XMLEventReader createFilteredReader(XMLEventReader var1, EventFilter var2) throws XMLStreamException;

    public abstract XMLResolver getXMLResolver();

    public abstract void setXMLResolver(XMLResolver var1);

    public abstract XMLReporter getXMLReporter();

    public abstract void setXMLReporter(XMLReporter var1);

    public abstract void setProperty(String var1, Object var2) throws IllegalArgumentException;

    public abstract Object getProperty(String var1) throws IllegalArgumentException;

    public abstract boolean isPropertySupported(String var1);

    public abstract void setEventAllocator(XMLEventAllocator var1);

    public abstract XMLEventAllocator getEventAllocator();

    public abstract void setCoalescing(boolean var1);

    public abstract boolean isCoalescing();
}

