/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.stream;

import gnu.xml.stream.XMLOutputFactoryImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Properties;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public abstract class XMLOutputFactory {
    public static final String IS_PREFIX_DEFAULTING = "javax.xml.stream.isPrefixDefaulting";

    protected XMLOutputFactory() {
    }

    public static XMLOutputFactory newInstance() throws FactoryConfigurationError {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = XMLOutputFactory.class$("javax.xml.stream.XMLOutputFactory").getClassLoader();
        }
        String string = null;
        int n = 0;
        do {
            if ((string = XMLOutputFactory.getFactoryClassName(classLoader, n++)) == null) continue;
            try {
                Class clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
                return (XMLOutputFactory)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                string = null;
            }
            catch (Exception exception) {
                throw new FactoryConfigurationError(exception, "error instantiating class " + string);
            }
        } while (string == null && n < 3);
        return new XMLOutputFactoryImpl();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static String getFactoryClassName(ClassLoader classLoader, int n) {
        String string = "javax.xml.stream.XMLOutputFactory";
        switch (n) {
            case 0: {
                return System.getProperty(string);
            }
            case 1: {
                try {
                    File file = new File(System.getProperty("java.home"));
                    file = new File(file, "lib");
                    file = new File(file, "stax.properties");
                    FileInputStream fileInputStream = new FileInputStream(file);
                    Properties properties = new Properties();
                    properties.load(fileInputStream);
                    ((InputStream)fileInputStream).close();
                    return properties.getProperty(string);
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            case 2: {
                try {
                    InputStream inputStream;
                    String string2 = "/META-INF/services/" + string;
                    InputStream inputStream2 = inputStream = classLoader != null ? classLoader.getResourceAsStream(string2) : XMLOutputFactory.class$("javax.xml.stream.XMLOutputFactory").getResourceAsStream(string2);
                    if (inputStream != null) {
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                        String string3 = bufferedReader.readLine();
                        bufferedReader.close();
                        return string3;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        }
        return null;
    }

    public static XMLInputFactory newInstance(String string, ClassLoader classLoader) throws FactoryConfigurationError {
        return XMLInputFactory.newInstance(string, classLoader);
    }

    public abstract XMLStreamWriter createXMLStreamWriter(Writer var1) throws XMLStreamException;

    public abstract XMLStreamWriter createXMLStreamWriter(OutputStream var1) throws XMLStreamException;

    public abstract XMLStreamWriter createXMLStreamWriter(OutputStream var1, String var2) throws XMLStreamException;

    public abstract XMLEventWriter createXMLEventWriter(OutputStream var1) throws XMLStreamException;

    public abstract XMLEventWriter createXMLEventWriter(OutputStream var1, String var2) throws XMLStreamException;

    public abstract XMLEventWriter createXMLEventWriter(Writer var1) throws XMLStreamException;

    public abstract void setProperty(String var1, Object var2) throws IllegalArgumentException;

    public abstract Object getProperty(String var1) throws IllegalArgumentException;

    public abstract boolean isPrefixDefaulting();

    public abstract boolean isPropertySupported(String var1);

    public abstract void setPrefixDefaulting(boolean var1);
}

