#!/bin/bash

config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then
    # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

config etc/dbus-1/session.conf.new
config etc/dbus-1/system.conf.new
config etc/rc.d/rc.messagebus.new

( cd usr/lib ; rm -rf libdbus-1.so )
( cd usr/lib ; ln -sf libdbus-1.so.3.2.0 libdbus-1.so )
( cd usr/lib ; rm -rf libdbus-1.so.3 )
( cd usr/lib ; ln -sf libdbus-1.so.3.2.0 libdbus-1.so.3 )
