/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.GTKConstants;
import com.sun.java.swing.plaf.gtk.GTKLookAndFeel;
import com.sun.java.swing.plaf.gtk.GTKNativeEngine;
import com.sun.java.swing.plaf.gtk.GTKStyle;
import com.sun.java.swing.plaf.gtk.PangoFonts;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import sun.awt.UNIXToolkit;
import sun.awt.image.CachingSurfaceManager;
import sun.awt.image.SurfaceManager;

class GTKNativeStyle
extends GTKStyle {
    private final int widgetType;
    private final int xThickness;
    private final int yThickness;
    private final Font pangoFont;
    private Object[] images = new Object[5];
    private static final Object EMPTY_IMAGE_TAG = "<none>";

    private native int native_get_xthickness(int var1);

    private native int native_get_ythickness(int var1);

    private native int native_get_color_for_state(int var1, int var2, int var3);

    private native Object native_get_class_value(int var1, String var2);

    private native String native_get_pango_font_name(int var1);

    private native Dimension native_get_image_dimension(int var1, int var2);

    private native void native_get_image(int[] var1, int var2, int var3, int var4, int var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GTKNativeStyle(Font font, GTKNativeEngine.WidgetType widgetType) {
        super(font);
        this.widgetType = widgetType.ordinal();
        String string = null;
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            this.xThickness = this.native_get_xthickness(this.widgetType);
            this.yThickness = this.native_get_ythickness(this.widgetType);
            string = this.native_get_pango_font_name(this.widgetType);
        }
        this.pangoFont = string != null ? PangoFonts.lookupFont(string) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Color getStyleSpecificColor(SynthContext synthContext, int n, ColorType colorType) {
        n = GTKLookAndFeel.synthStateToGTKStateType(n).ordinal();
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            int n2 = this.native_get_color_for_state(this.widgetType, n, colorType.getID());
            return new ColorUIResource(n2);
        }
    }

    protected Font getFontForState(JComponent jComponent, Region region, int n) {
        if (this.pangoFont != null) {
            return this.pangoFont;
        }
        return super.getFontForState(jComponent, region, n);
    }

    int getXThickness() {
        return this.xThickness;
    }

    int getYThickness() {
        return this.yThickness;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getClassSpecificValue(Region region, String string) {
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            return this.native_get_class_value(this.widgetType, string);
        }
    }

    boolean fillBackground(SynthContext synthContext, int n) {
        Object object = this.getBackgroundImage(n);
        return object == EMPTY_IMAGE_TAG;
    }

    Image getBackgroundImage(SynthContext synthContext, int n) {
        Object object = this.getBackgroundImage(n);
        return object == EMPTY_IMAGE_TAG ? null : (Image)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getBackgroundImage(int n) {
        if (this.images[n = GTKLookAndFeel.synthStateToGTKStateType(n).ordinal()] != null) {
            return this.images[n];
        }
        Dimension dimension = null;
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            dimension = this.native_get_image_dimension(this.widgetType, n);
        }
        if (dimension != null) {
            object = new BufferedImage(dimension.width, dimension.height, 1);
            boolean bl = false;
            CachingSurfaceManager cachingSurfaceManager = null;
            SurfaceManager surfaceManager = SurfaceManager.getManager((Image)object);
            if (surfaceManager instanceof CachingSurfaceManager) {
                cachingSurfaceManager = (CachingSurfaceManager)surfaceManager;
                bl = cachingSurfaceManager.isLocalAccelerationEnabled();
            }
            DataBufferInt dataBufferInt = (DataBufferInt)((BufferedImage)object).getRaster().getDataBuffer();
            Object object2 = UNIXToolkit.GTK_LOCK;
            synchronized (object2) {
                this.native_get_image(dataBufferInt.getData(), dimension.width, dimension.height, this.widgetType, n);
            }
            if (cachingSurfaceManager != null && bl != cachingSurfaceManager.isLocalAccelerationEnabled()) {
                cachingSurfaceManager.setLocalAccelerationEnabled(bl);
                cachingSurfaceManager.rasterChanged();
            }
            this.images[n] = object;
            return this.images[n];
        }
        this.images[n] = EMPTY_IMAGE_TAG;
        return this.images[n];
    }

    Icon getStyleSpecificIcon(String string, GTKConstants.TextDirection textDirection, int n) {
        BufferedImage bufferedImage = ((UNIXToolkit)Toolkit.getDefaultToolkit()).getStockIcon(this.widgetType, string, n, textDirection.ordinal(), null);
        return bufferedImage != null ? new ImageIcon(bufferedImage) : null;
    }
}

