/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Fonts;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java2d.AnimatingSurface;

public class Highlighting
extends AnimatingSurface {
    private static String[] text = new String[]{"HILIGHTING", "Java2D"};
    private static Color[] colors = new Color[]{Color.CYAN, Color.LIGHT_GRAY};
    private static Font smallF = new Font("Monospaced", 0, 8);
    private int[] curPos;
    private TextLayout[] layouts;
    private Font[] fonts;

    public Highlighting() {
        this.setBackground(Color.WHITE);
        this.fonts = new Font[2];
        this.layouts = new TextLayout[this.fonts.length];
        this.curPos = new int[this.fonts.length];
    }

    public void reset(int n, int n2) {
        this.fonts[0] = new Font("Monospaced", 0, n / text[0].length() + 8);
        this.fonts[1] = new Font("Serif", 1, n / text[1].length());
        for (int i = 0; i < this.layouts.length; ++i) {
            this.curPos[i] = 0;
        }
    }

    public void step(int n, int n2) {
        this.setSleepAmount(900L);
        for (int i = 0; i < 2; ++i) {
            if (this.layouts[i] == null) continue;
            int n3 = i;
            int n4 = this.curPos[n3];
            this.curPos[n3] = n4 + 1;
            if (n4 != this.layouts[i].getCharacterCount()) continue;
            this.curPos[i] = 0;
        }
    }

    public void render(int n, int n2, Graphics2D graphics2D) {
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        for (int i = 0; i < 2; ++i) {
            this.layouts[i] = new TextLayout(text[i], this.fonts[i], fontRenderContext);
            float f = this.layouts[i].getAdvance();
            float f2 = this.layouts[i].getAscent() + this.layouts[i].getDescent();
            float f3 = ((float)n - f) / 2.0f;
            float f4 = i == 0 ? (float)(n2 / 3) : (float)n2 * 0.75f;
            Shape shape = this.layouts[i].getLogicalHighlightShape(0, this.curPos[i]);
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(f3, f4);
            shape = affineTransform.createTransformedShape(shape);
            float f5 = (float)shape.getBounds2D().getY();
            float f6 = (float)shape.getBounds2D().getHeight();
            graphics2D.setColor(colors[i]);
            graphics2D.fill(shape);
            Shape[] shapeArray = this.layouts[i].getCaretShapes(this.curPos[i]);
            Shape shape2 = affineTransform.createTransformedShape(shapeArray[0]);
            graphics2D.setColor(Color.BLACK);
            this.layouts[i].draw(graphics2D, f3, f4);
            graphics2D.draw(shape2);
            graphics2D.draw(new Rectangle2D.Float(f3, f5, f, f6));
            for (int j = 0; j <= this.layouts[i].getCharacterCount(); ++j) {
                float[] fArray = this.layouts[i].getCaretInfo(TextHitInfo.leading(j));
                String string = String.valueOf((int)fArray[0]);
                TextLayout textLayout = new TextLayout(string, smallF, fontRenderContext);
                textLayout.draw(graphics2D, f3 + fArray[0] - textLayout.getAdvance() / 2.0f, f5 + f6 + textLayout.getAscent() + 1.0f);
            }
        }
    }

    public static void main(String[] stringArray) {
        Highlighting.createDemoFrame(new Highlighting());
    }
}

