/*
 * Decompiled with CFR 0.152.
 */
package com.sun.inputmethods.internal.codepointim;

import java.awt.AWTEvent;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodHighlight;
import java.awt.im.spi.InputMethod;
import java.awt.im.spi.InputMethodContext;
import java.io.IOException;
import java.text.AttributedString;
import java.util.Locale;

public class CodePointInputMethod
implements InputMethod {
    private static final int UNSET = 0;
    private static final int ESCAPE = 1;
    private static final int SPECIAL_ESCAPE = 2;
    private static final int SURROGATE_PAIR = 3;
    private InputMethodContext context;
    private Locale locale;
    private StringBuffer buffer;
    private int insertionPoint;
    private int format = 0;

    public void dispatchEvent(AWTEvent aWTEvent) {
        boolean bl;
        if (!(aWTEvent instanceof KeyEvent)) {
            return;
        }
        KeyEvent keyEvent = (KeyEvent)aWTEvent;
        int n = aWTEvent.getID();
        boolean bl2 = bl = this.buffer.length() == 0;
        if (n == 401) {
            if (bl) {
                return;
            }
            switch (keyEvent.getKeyCode()) {
                case 37: {
                    this.moveCaretLeft();
                    break;
                }
                case 39: {
                    this.moveCaretRight();
                }
            }
        } else if (n == 400) {
            char c = keyEvent.getKeyChar();
            if (bl) {
                if (c != '\\') {
                    return;
                }
                this.startComposition();
            } else {
                switch (c) {
                    case ' ': {
                        this.finishComposition();
                        break;
                    }
                    case '\u007f': {
                        this.deleteCharacter();
                        break;
                    }
                    case '\b': {
                        this.deletePreviousCharacter();
                        break;
                    }
                    case '\u001b': {
                        this.cancelComposition();
                        break;
                    }
                    case '\t': 
                    case '\n': {
                        this.sendCommittedText();
                        break;
                    }
                    default: {
                        this.composeUnicodeEscape(c);
                    }
                }
            }
        } else if (bl) {
            return;
        }
        keyEvent.consume();
    }

    private void composeUnicodeEscape(char c) {
        switch (this.buffer.length()) {
            case 1: {
                this.waitEscapeCharacter(c);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.waitDigit(c);
                break;
            }
            case 5: {
                if (this.format == 2) {
                    this.waitDigit(c);
                    break;
                }
                this.waitDigit2(c);
                break;
            }
            case 6: {
                if (this.format == 2) {
                    this.waitDigit(c);
                    break;
                }
                if (this.format == 3) {
                    this.waitBackSlashOrLowSurrogate(c);
                    break;
                }
                CodePointInputMethod.beep();
                break;
            }
            case 7: {
                this.waitDigit(c);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                if (this.format == 3) {
                    this.waitDigit(c);
                    break;
                }
                CodePointInputMethod.beep();
                break;
            }
            default: {
                CodePointInputMethod.beep();
            }
        }
    }

    private void waitEscapeCharacter(char c) {
        if (c == 'u' || c == 'U') {
            this.buffer.append(c);
            ++this.insertionPoint;
            this.sendComposedText();
            this.format = c == 'u' ? 1 : 2;
        } else {
            if (c != '\\') {
                this.buffer.append(c);
                ++this.insertionPoint;
            }
            this.sendCommittedText();
        }
    }

    private void waitDigit(char c) {
        if (Character.digit(c, 16) != -1) {
            this.buffer.insert(this.insertionPoint++, c);
            this.sendComposedText();
        } else {
            CodePointInputMethod.beep();
        }
    }

    private void waitDigit2(char c) {
        if (Character.digit(c, 16) != -1) {
            this.buffer.insert(this.insertionPoint++, c);
            char c2 = (char)this.getCodePoint(this.buffer, 2, 5);
            if (Character.isHighSurrogate(c2)) {
                this.format = 3;
                this.buffer.append("\\u");
                this.insertionPoint = 8;
            } else {
                this.format = 1;
            }
            this.sendComposedText();
        } else {
            CodePointInputMethod.beep();
        }
    }

    private void waitBackSlashOrLowSurrogate(char c) {
        if (this.insertionPoint == 6) {
            if (c == '\\') {
                this.buffer.append(c);
                this.buffer.append('u');
                this.insertionPoint = 8;
                this.sendComposedText();
            } else if (Character.digit(c, 16) != -1) {
                this.buffer.append("\\u");
                this.buffer.append(c);
                this.insertionPoint = 9;
                this.sendComposedText();
            } else {
                CodePointInputMethod.beep();
            }
        } else {
            CodePointInputMethod.beep();
        }
    }

    private void sendComposedText() {
        AttributedString attributedString = new AttributedString(this.buffer.toString());
        attributedString.addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT, InputMethodHighlight.SELECTED_RAW_TEXT_HIGHLIGHT);
        this.context.dispatchInputMethodEvent(1100, attributedString.getIterator(), 0, TextHitInfo.leading(this.insertionPoint), null);
    }

    private void sendCommittedText() {
        AttributedString attributedString = new AttributedString(this.buffer.toString());
        this.context.dispatchInputMethodEvent(1100, attributedString.getIterator(), this.buffer.length(), TextHitInfo.leading(this.insertionPoint), null);
        this.buffer.setLength(0);
        this.insertionPoint = 0;
        this.format = 0;
    }

    private void moveCaretLeft() {
        int n = this.buffer.length();
        if (--this.insertionPoint < 2) {
            ++this.insertionPoint;
            CodePointInputMethod.beep();
        } else if (this.format == 3 && this.insertionPoint == 7) {
            this.insertionPoint = 8;
            CodePointInputMethod.beep();
        }
        this.context.dispatchInputMethodEvent(1101, null, 0, TextHitInfo.leading(this.insertionPoint), null);
    }

    private void moveCaretRight() {
        int n = this.buffer.length();
        if (++this.insertionPoint > n) {
            this.insertionPoint = n;
            CodePointInputMethod.beep();
        }
        this.context.dispatchInputMethodEvent(1101, null, 0, TextHitInfo.leading(this.insertionPoint), null);
    }

    private void deletePreviousCharacter() {
        if (this.insertionPoint == 2) {
            if (this.buffer.length() == 2) {
                this.cancelComposition();
            } else {
                CodePointInputMethod.beep();
            }
        } else if (this.insertionPoint == 8) {
            if (this.buffer.length() == 8) {
                if (this.format == 3) {
                    this.buffer.deleteCharAt(--this.insertionPoint);
                }
                this.buffer.deleteCharAt(--this.insertionPoint);
                this.sendComposedText();
            } else {
                CodePointInputMethod.beep();
            }
        } else {
            this.buffer.deleteCharAt(--this.insertionPoint);
            if (this.buffer.length() == 0) {
                this.sendCommittedText();
            } else {
                this.sendComposedText();
            }
        }
    }

    private void deleteCharacter() {
        if (this.insertionPoint < this.buffer.length()) {
            this.buffer.deleteCharAt(this.insertionPoint);
            this.sendComposedText();
        } else {
            CodePointInputMethod.beep();
        }
    }

    private void startComposition() {
        this.buffer.append('\\');
        this.insertionPoint = 1;
        this.sendComposedText();
    }

    private void cancelComposition() {
        this.buffer.setLength(0);
        this.insertionPoint = 0;
        this.sendCommittedText();
    }

    private void finishComposition() {
        char[] cArray;
        int n = this.buffer.length();
        if (n == 6 && this.format != 2) {
            char c = (char)this.getCodePoint(this.buffer, 2, 5);
            if (Character.isValidCodePoint(c) && c != '\uffff') {
                this.buffer.setLength(0);
                this.buffer.append(c);
                this.sendCommittedText();
                return;
            }
        } else if (n == 8 && this.format == 2) {
            int n2 = this.getCodePoint(this.buffer, 2, 7);
            if (Character.isValidCodePoint(n2) && n2 != 65535) {
                this.buffer.setLength(0);
                this.buffer.appendCodePoint(n2);
                this.sendCommittedText();
                return;
            }
        } else if (n == 12 && this.format == 3 && Character.isHighSurrogate((cArray = new char[]{(char)this.getCodePoint(this.buffer, 2, 5), (char)this.getCodePoint(this.buffer, 8, 11)})[0]) && Character.isLowSurrogate(cArray[1])) {
            this.buffer.setLength(0);
            this.buffer.append(cArray);
            this.sendCommittedText();
            return;
        }
        CodePointInputMethod.beep();
    }

    private int getCodePoint(StringBuffer stringBuffer, int n, int n2) {
        int n3 = 0;
        for (int i = n; i <= n2; ++i) {
            n3 = (n3 << 4) + Character.digit(stringBuffer.charAt(i), 16);
        }
        return n3;
    }

    private static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public void activate() {
        if (this.buffer == null) {
            this.buffer = new StringBuffer(12);
            this.insertionPoint = 0;
        }
    }

    public void deactivate(boolean bl) {
        if (!bl) {
            this.buffer = null;
        }
    }

    public void dispose() {
    }

    public Object getControlObject() {
        return null;
    }

    public void endComposition() {
        this.sendCommittedText();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void hideWindows() {
    }

    public boolean isCompositionEnabled() {
        return true;
    }

    public void notifyClientWindowChange(Rectangle rectangle) {
    }

    public void reconvert() {
        throw new UnsupportedOperationException();
    }

    public void removeNotify() {
    }

    public void setCharacterSubsets(Character.Subset[] subsetArray) {
    }

    public void setCompositionEnabled(boolean bl) {
        throw new UnsupportedOperationException();
    }

    public void setInputMethodContext(InputMethodContext inputMethodContext) {
        this.context = inputMethodContext;
    }

    public boolean setLocale(Locale locale) {
        this.locale = locale;
        return true;
    }
}

