#!/bin/sh
config() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "$(cat $OLD | md5sum)" = "$(cat $NEW | md5sum)" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/sensors.conf.new
( cd usr/lib ; rm -rf libsensors.so.3 )
( cd usr/lib ; ln -sf libsensors.so.3.1.5 libsensors.so.3 )
( cd usr/lib ; rm -rf libsensors.so )
( cd usr/lib ; ln -sf libsensors.so.3 libsensors.so )
