/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.sasl.crammd5;

import gnu.javax.crypto.sasl.NoSuchUserException;
import gnu.javax.crypto.sasl.UserAlreadyExistsException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class PasswordFile {
    private static String DEFAULT_FILE = System.getProperty("gnu.crypto.sasl.crammd5.password.file", "/etc/passwd");
    private HashMap entries;
    private File passwdFile;
    private long lastmod;

    public PasswordFile() throws IOException {
        this(DEFAULT_FILE);
    }

    public PasswordFile(File file) throws IOException {
        this(file.getAbsolutePath());
    }

    public PasswordFile(String string) throws IOException {
        this.passwdFile = new File(string);
        this.update();
    }

    public synchronized void add(String string, String string2, String[] stringArray) throws IOException {
        this.checkCurrent();
        if (this.entries.containsKey(string)) {
            throw new UserAlreadyExistsException(string);
        }
        if (stringArray.length != 5) {
            throw new IllegalArgumentException("Wrong number of attributes");
        }
        String[] stringArray2 = new String[7];
        stringArray2[0] = string;
        stringArray2[1] = string2;
        System.arraycopy(stringArray, 0, stringArray2, 2, 5);
        this.entries.put(string, stringArray2);
        this.savePasswd();
    }

    public synchronized void changePasswd(String string, String string2) throws IOException {
        this.checkCurrent();
        if (!this.entries.containsKey(string)) {
            throw new NoSuchUserException(string);
        }
        String[] stringArray = (String[])this.entries.get(string);
        stringArray[1] = string2;
        this.entries.remove(string);
        this.entries.put(string, stringArray);
        this.savePasswd();
    }

    public synchronized String[] lookup(String string) throws IOException {
        this.checkCurrent();
        if (!this.entries.containsKey(string)) {
            throw new NoSuchUserException(string);
        }
        return (String[])this.entries.get(string);
    }

    public synchronized boolean contains(String string) throws IOException {
        this.checkCurrent();
        return this.entries.containsKey(string);
    }

    private synchronized void update() throws IOException {
        this.lastmod = this.passwdFile.lastModified();
        this.readPasswd(new FileInputStream(this.passwdFile));
    }

    private void checkCurrent() throws IOException {
        if (this.passwdFile.lastModified() > this.lastmod) {
            this.update();
        }
    }

    private synchronized void readPasswd(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        this.entries = new HashMap();
        while ((string = bufferedReader.readLine()) != null) {
            String[] stringArray;
            block13: {
                stringArray = new String[7];
                StringTokenizer stringTokenizer = new StringTokenizer(string, ":", true);
                try {
                    stringArray[0] = stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    stringArray[1] = stringTokenizer.nextToken();
                    if (stringArray[1].equals(":")) {
                        stringArray[1] = "";
                    } else {
                        stringTokenizer.nextToken();
                    }
                    stringArray[2] = stringTokenizer.nextToken();
                    if (stringArray[2].equals(":")) {
                        stringArray[2] = "";
                    } else {
                        stringTokenizer.nextToken();
                    }
                    stringArray[3] = stringTokenizer.nextToken();
                    if (stringArray[3].equals(":")) {
                        stringArray[3] = "";
                    } else {
                        stringTokenizer.nextToken();
                    }
                    stringArray[4] = stringTokenizer.nextToken();
                    if (stringArray[4].equals(":")) {
                        stringArray[4] = "";
                    } else {
                        stringTokenizer.nextToken();
                    }
                    stringArray[5] = stringTokenizer.nextToken();
                    if (stringArray[5].equals(":")) {
                        stringArray[5] = "";
                    } else {
                        stringTokenizer.nextToken();
                    }
                    stringArray[6] = stringTokenizer.nextToken();
                    if (!stringArray[6].equals(":")) break block13;
                    stringArray[6] = "";
                }
                catch (NoSuchElementException noSuchElementException) {
                    continue;
                }
            }
            this.entries.put(stringArray[0], stringArray);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private synchronized void savePasswd() throws IOException {
        if (this.passwdFile != null) {
            Object object2;
            FileOutputStream fileOutputStream;
            block14: {
                fileOutputStream = new FileOutputStream(this.passwdFile);
                PrintWriter printWriter = null;
                try {
                    printWriter = new PrintWriter(fileOutputStream);
                    Iterator iterator = this.entries.keySet().iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        object2 = (String[])this.entries.get(string);
                        StringBuffer stringBuffer = new StringBuffer(object2[0]);
                        for (int i = 1; i < ((String[])object2).length; ++i) {
                            stringBuffer.append(":").append(object2[i]);
                        }
                        printWriter.println(stringBuffer.toString());
                    }
                    Object var3_5 = null;
                    if (printWriter == null) break block14;
                }
                catch (Throwable throwable) {
                    IOException iOException2;
                    Object var3_6 = null;
                    if (printWriter != null) {
                        try {
                            printWriter.flush();
                        }
                        finally {
                            iOException2 = null;
                            printWriter.close();
                        }
                    }
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    this.lastmod = this.passwdFile.lastModified();
                    throw throwable;
                }
                try {
                    printWriter.flush();
                }
                finally {
                    object2 = null;
                    printWriter.close();
                }
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException object2) {
                // empty catch block
            }
            this.lastmod = this.passwdFile.lastModified();
        }
    }
}

