/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class DateFormatSymbols
implements Serializable,
Cloneable {
    String[] ampms;
    String[] eras;
    private String localPatternChars;
    String[] months;
    String[] shortMonths;
    String[] shortWeekdays;
    String[] weekdays;
    private String[][] zoneStrings;
    private static final long serialVersionUID = -5987973545549424702L;
    private static final String[] formatPrefixes = new String[]{"full", "long", "medium", "short"};
    transient String[] dateFormats;
    transient String[] timeFormats;

    private String[] formatsForKey(ResourceBundle resourceBundle, String string) {
        String[] stringArray = new String[formatPrefixes.length];
        for (int i = 0; i < formatPrefixes.length; ++i) {
            stringArray[i] = resourceBundle.getString(formatPrefixes[i] + string);
        }
        return stringArray;
    }

    public DateFormatSymbols(Locale locale) throws MissingResourceException {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("gnu.java.locale.LocaleInformation", locale, ClassLoader.getSystemClassLoader());
        this.ampms = resourceBundle.getStringArray("ampms");
        this.eras = resourceBundle.getStringArray("eras");
        this.localPatternChars = resourceBundle.getString("localPatternChars");
        this.months = resourceBundle.getStringArray("months");
        this.shortMonths = resourceBundle.getStringArray("shortMonths");
        this.shortWeekdays = resourceBundle.getStringArray("shortWeekdays");
        this.weekdays = resourceBundle.getStringArray("weekdays");
        this.zoneStrings = (String[][])resourceBundle.getObject("zoneStrings");
        this.dateFormats = this.formatsForKey(resourceBundle, "DateFormat");
        this.timeFormats = this.formatsForKey(resourceBundle, "TimeFormat");
    }

    public DateFormatSymbols() throws MissingResourceException {
        this(Locale.getDefault());
    }

    public String[] getAmPmStrings() {
        return this.ampms;
    }

    public String[] getEras() {
        return this.eras;
    }

    public String getLocalPatternChars() {
        return this.localPatternChars;
    }

    public String[] getMonths() {
        return this.months;
    }

    public String[] getShortMonths() {
        return this.shortMonths;
    }

    public String[] getShortWeekdays() {
        return this.shortWeekdays;
    }

    public String[] getWeekdays() {
        return this.weekdays;
    }

    public String[][] getZoneStrings() {
        return this.zoneStrings;
    }

    public void setAmPmStrings(String[] stringArray) {
        this.ampms = stringArray;
    }

    public void setEras(String[] stringArray) {
        this.eras = stringArray;
    }

    public void setLocalPatternChars(String string) {
        this.localPatternChars = string;
    }

    public void setMonths(String[] stringArray) {
        this.months = stringArray;
    }

    public void setShortMonths(String[] stringArray) {
        this.shortMonths = stringArray;
    }

    public void setShortWeekdays(String[] stringArray) {
        this.shortWeekdays = stringArray;
    }

    public void setWeekdays(String[] stringArray) {
        this.weekdays = stringArray;
    }

    public void setZoneStrings(String[][] stringArray) {
        this.zoneStrings = stringArray;
    }

    private static boolean equals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (!(object instanceof Object[]) || !(object2 instanceof Object[])) {
            return object.equals(object2);
        }
        Object[] objectArray = (Object[])object;
        Object[] objectArray2 = (Object[])object2;
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        int n = objectArray.length;
        while (--n >= 0) {
            if (DateFormatSymbols.equals(objectArray[n], objectArray2[n])) continue;
            return false;
        }
        return true;
    }

    private static int hashCode(Object object) {
        if (object == null) {
            return 0;
        }
        if (!(object instanceof Object[])) {
            return object.hashCode();
        }
        Object[] objectArray = (Object[])object;
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            n = 37 * DateFormatSymbols.hashCode(objectArray[i]);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DateFormatSymbols)) {
            return false;
        }
        DateFormatSymbols dateFormatSymbols = (DateFormatSymbols)object;
        return DateFormatSymbols.equals(this.ampms, dateFormatSymbols.ampms) && DateFormatSymbols.equals(this.eras, dateFormatSymbols.eras) && DateFormatSymbols.equals(this.localPatternChars, dateFormatSymbols.localPatternChars) && DateFormatSymbols.equals(this.months, dateFormatSymbols.months) && DateFormatSymbols.equals(this.shortMonths, dateFormatSymbols.shortMonths) && DateFormatSymbols.equals(this.shortWeekdays, dateFormatSymbols.shortWeekdays) && DateFormatSymbols.equals(this.weekdays, dateFormatSymbols.weekdays) && DateFormatSymbols.equals(this.zoneStrings, dateFormatSymbols.zoneStrings);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public int hashCode() {
        return DateFormatSymbols.hashCode(this.ampms) ^ DateFormatSymbols.hashCode(this.eras) ^ DateFormatSymbols.hashCode(this.localPatternChars) ^ DateFormatSymbols.hashCode(this.months) ^ DateFormatSymbols.hashCode(this.shortMonths) ^ DateFormatSymbols.hashCode(this.shortWeekdays) ^ DateFormatSymbols.hashCode(this.weekdays) ^ DateFormatSymbols.hashCode(this.zoneStrings);
    }
}

