#!/bin/sh
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/gtk-2.0/im-multipress.conf.new

# Since the use of icon caching is optional, and has to be kept in sync
# somehow (like a "registry" through a cron job, or whatever, I tend to
# think the user should be the one to choose if they really want to set
# this up or not:
#
# Example:
#for dir in /usr/share/icons/* ; do
#  if [ -d $dir ]; then
#    /usr/bin/gtk-update-icon-cache -f -t $dir 1> /dev/null 2> /dev/null
#  fi
#done
mkdir -p etc/gtk-2.0

chroot . rm -f /usr/share/icons/*/icon-theme.cache 1> /dev/null 2> /dev/null

# This has a lot of X deps, so check for the obvious one first:
if [ -e usr/lib/libX11.so.6 ]; then
  chroot . usr/bin/gtk-query-immodules-2.0 > etc/gtk-2.0/gtk.immodules
fi
( cd usr/lib ; rm -rf libgdk_pixbuf-2.0.so )
( cd usr/lib ; ln -sf libgdk_pixbuf-2.0.so.0.1200.9 libgdk_pixbuf-2.0.so )
( cd usr/lib ; rm -rf libgdk-x11-2.0.so.0 )
( cd usr/lib ; ln -sf libgdk-x11-2.0.so.0.1200.9 libgdk-x11-2.0.so.0 )
( cd usr/lib ; rm -rf libgdk_pixbuf_xlib-2.0.so )
( cd usr/lib ; ln -sf libgdk_pixbuf_xlib-2.0.so.0.1200.9 libgdk_pixbuf_xlib-2.0.so )
( cd usr/lib ; rm -rf libgdk_pixbuf-2.0.so.0 )
( cd usr/lib ; ln -sf libgdk_pixbuf-2.0.so.0.1200.9 libgdk_pixbuf-2.0.so.0 )
( cd usr/lib ; rm -rf libgtk-x11-2.0.so )
( cd usr/lib ; ln -sf libgtk-x11-2.0.so.0.1200.9 libgtk-x11-2.0.so )
( cd usr/lib ; rm -rf libgdk_pixbuf_xlib-2.0.so.0 )
( cd usr/lib ; ln -sf libgdk_pixbuf_xlib-2.0.so.0.1200.9 libgdk_pixbuf_xlib-2.0.so.0 )
( cd usr/lib ; rm -rf libgdk-x11-2.0.so )
( cd usr/lib ; ln -sf libgdk-x11-2.0.so.0.1200.9 libgdk-x11-2.0.so )
( cd usr/lib ; rm -rf libgtk-x11-2.0.so.0 )
( cd usr/lib ; ln -sf libgtk-x11-2.0.so.0.1200.9 libgtk-x11-2.0.so.0 )
