/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.config.Config;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class CachedJarFile
extends JarFile {
    private Reference signersRef;
    private Reference signerMapRef = null;
    private Reference manRef = null;
    private String resourceURL;
    static /* synthetic */ Class class$java$util$jar$Manifest;
    static /* synthetic */ Class class$java$util$jar$Attributes;

    public Object clone() throws CloneNotSupportedException {
        try {
            return new CachedJarFile(new File(this.getName()), this.signersRef, this.signerMapRef, this.manRef, this.resourceURL);
        }
        catch (IOException iOException) {
            Trace.ignoredException(iOException);
            throw new CloneNotSupportedException(iOException.getMessage());
        }
    }

    private CachedJarFile(File file, Reference reference, Reference reference2, Reference reference3, String string) throws IOException {
        super(file, false);
        this.signersRef = reference;
        this.signerMapRef = reference2;
        this.manRef = reference3;
        this.resourceURL = string;
        CachedJarFile.ensureAncestorKnowsAboutManifest(this);
        MemoryCache.addResourceReference(this, string);
    }

    static void ensureAncestorKnowsAboutManifest(final JarFile jarFile) throws IOException {
        if (!Config.isJavaVersionAtLeast16()) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        try {
                            Field field = (class$java$util$jar$Manifest == null ? (class$java$util$jar$Manifest = CachedJarFile.class$("java.util.jar.Manifest")) : class$java$util$jar$Manifest).getDeclaredField("manLoaded");
                            if (field != null) {
                                field.setAccessible(true);
                                field.setBoolean(jarFile, true);
                                return null;
                            }
                        }
                        catch (Exception exception) {
                            jarFile.getManifest();
                            Trace.println("Had to use super.getManifest() to set manLoaded", TraceLevel.CACHE);
                            Trace.ignoredException(new Exception("AAA"));
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getException();
            }
        }
    }

    protected CachedJarFile(CacheEntry cacheEntry) throws IOException {
        super(new File(cacheEntry.getResourceFilename()), false);
        this.resourceURL = cacheEntry.getURL();
        CodeSigner[] codeSignerArray = cacheEntry.getCodeSigners();
        Map map = cacheEntry.getSignerMap();
        Manifest manifest = cacheEntry.getManifest();
        this.signersRef = codeSignerArray != null ? new SoftReference<CodeSigner[]>(codeSignerArray) : null;
        this.signerMapRef = map != null ? new SoftReference<Map>(map) : null;
        if (manifest != null) {
            this.manRef = new SoftReference<Manifest>(manifest);
        }
        CachedJarFile.ensureAncestorKnowsAboutManifest(this);
        MemoryCache.addResourceReference(this, this.resourceURL);
    }

    public ZipEntry getEntry(String string) {
        ZipEntry zipEntry = super.getEntry(string);
        if (zipEntry != null) {
            return new JarFileEntry(zipEntry);
        }
        return null;
    }

    public Enumeration entries() {
        final Enumeration<JarEntry> enumeration = super.entries();
        return new Enumeration(){

            public boolean hasMoreElements() {
                return enumeration.hasMoreElements();
            }

            public Object nextElement() {
                ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                return new JarFileEntry(zipEntry);
            }
        };
    }

    public Manifest getManifest() throws IOException {
        if (this.manRef == null) {
            return null;
        }
        Manifest manifest = (Manifest)this.manRef.get();
        if (manifest == null) {
            CacheEntry cacheEntry = this.getCacheEntry();
            Manifest manifest2 = null;
            if (cacheEntry != null) {
                manifest2 = cacheEntry.getManifest();
            }
            if (manifest2 != null) {
                this.manRef = new SoftReference<Manifest>(manifest2);
            }
        }
        return manifest;
    }

    private CacheEntry getCacheEntry() {
        if (this.resourceURL == null) {
            return null;
        }
        CacheEntry cacheEntry = (CacheEntry)MemoryCache.getLoadedResource(this.resourceURL);
        if (cacheEntry == null) {
            Trace.println("Missing CacheEntry for " + this.resourceURL + "\n" + cacheEntry, TraceLevel.CACHE);
        }
        return cacheEntry;
    }

    private Map getSignerMap() {
        CacheEntry cacheEntry;
        if (this.signerMapRef == null) {
            return null;
        }
        Map map = (Map)this.signerMapRef.get();
        if (map == null && (cacheEntry = this.getCacheEntry()) != null && (map = cacheEntry.getSignerMap()) != null) {
            this.signerMapRef = new SoftReference<Map>(map);
        }
        return map;
    }

    private CodeSigner[] getSigners() {
        CacheEntry cacheEntry;
        if (this.signersRef == null) {
            return null;
        }
        CodeSigner[] codeSignerArray = (CodeSigner[])this.signersRef.get();
        if (codeSignerArray == null && (cacheEntry = this.getCacheEntry()) != null && (codeSignerArray = cacheEntry.getCodeSigners()) != null) {
            this.signersRef = new SoftReference<CodeSigner[]>(codeSignerArray);
        }
        return codeSignerArray;
    }

    private static void replaceMapFieldWithImmutableMap(Class clazz, Object object, String string) {
        try {
            Field field = clazz.getDeclaredField(string);
            field.setAccessible(true);
            Map map = (Map)field.get(object);
            if (map != null) {
                map = Collections.unmodifiableMap(map);
                field.set(object, map);
            }
        }
        catch (Exception exception) {
            Trace.ignoredException(exception);
        }
    }

    private static Map makeAttributesImmutable(Attributes attributes) {
        Iterator<Object> iterator = attributes.keySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            Object object2 = attributes.get(object);
            if (!(object2 instanceof Attributes)) continue;
            CachedJarFile.makeAttributesImmutable((Attributes)object2);
        }
        CachedJarFile.replaceMapFieldWithImmutableMap(class$java$util$jar$Attributes == null ? (class$java$util$jar$Attributes = CachedJarFile.class$("java.util.jar.Attributes")) : class$java$util$jar$Attributes, attributes, "map");
        return attributes;
    }

    static void makeManifestImmutable(Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        CachedJarFile.makeAttributesImmutable(attributes);
        CachedJarFile.replaceMapFieldWithImmutableMap(class$java$util$jar$Manifest == null ? (class$java$util$jar$Manifest = CachedJarFile.class$("java.util.jar.Manifest")) : class$java$util$jar$Manifest, manifest, "entries");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class JarFileEntry
    extends JarEntry {
        JarFileEntry(ZipEntry zipEntry) {
            super(zipEntry);
        }

        public Attributes getAttributes() throws IOException {
            Manifest manifest = CachedJarFile.this.getManifest();
            if (manifest != null) {
                Attributes attributes = manifest.getAttributes(this.getName());
                return attributes;
            }
            return null;
        }

        public Certificate[] getCertificates() {
            Certificate[] certificateArray = null;
            int[] nArray = this.getSignerIndices();
            CodeSigner[] codeSignerArray = CachedJarFile.this.getSigners();
            if (nArray != null) {
                ArrayList<? extends Certificate> arrayList = new ArrayList<Certificate>();
                for (int i = 0; i < nArray.length; ++i) {
                    arrayList.addAll(codeSignerArray[nArray[i]].getSignerCertPath().getCertificates());
                }
                return arrayList.toArray(new Certificate[arrayList.size()]);
            }
            return certificateArray;
        }

        public CodeSigner[] getCodeSigners() {
            CodeSigner[] codeSignerArray = null;
            int[] nArray = this.getSignerIndices();
            CodeSigner[] codeSignerArray2 = CachedJarFile.this.getSigners();
            if (codeSignerArray2 != null && nArray != null) {
                codeSignerArray = new CodeSigner[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    if (codeSignerArray2 == null) continue;
                    codeSignerArray[i] = codeSignerArray2[nArray[i]];
                }
            }
            return codeSignerArray;
        }

        private int[] getSignerIndices() {
            Map map = CachedJarFile.this.getSignerMap();
            if (map != null && !map.isEmpty()) {
                return (int[])map.get(this.getName());
            }
            return null;
        }
    }
}

