#!/bin/sh
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/iproute2/ematch_map.new
config etc/iproute2/rt_dsfield.new
config etc/iproute2/rt_protos.new
config etc/iproute2/rt_realms.new
config etc/iproute2/rt_scopes.new
config etc/iproute2/rt_tables.new

( cd sbin ; rm -rf ctstat )
( cd sbin ; ln -sf lnstat ctstat )
( cd sbin ; rm -rf rtstat )
( cd sbin ; ln -sf lnstat rtstat )
( cd usr/man/man8 ; rm -rf tc-pfifo.8.gz )
( cd usr/man/man8 ; ln -sf tc-pbfifo.8.gz tc-pfifo.8.gz )
( cd usr/man/man8 ; rm -rf tc-bfifo.8.gz )
( cd usr/man/man8 ; ln -sf tc-pbfifo.8.gz tc-bfifo.8.gz )
