#!/bin/sh
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/X11/xserver/SecurityPolicy.new
( cd usr/bin ; rm -rf outb )
( cd usr/bin ; ln -sf ioport outb )
( cd usr/bin ; rm -rf X )
( cd usr/bin ; ln -sf Xorg X )
( cd usr/bin ; rm -rf inl )
( cd usr/bin ; ln -sf ioport inl )
( cd usr/bin ; rm -rf inw )
( cd usr/bin ; ln -sf ioport inw )
( cd usr/bin ; rm -rf inb )
( cd usr/bin ; ln -sf ioport inb )
( cd usr/bin ; rm -rf outl )
( cd usr/bin ; ln -sf ioport outl )
( cd usr/bin ; rm -rf outw )
( cd usr/bin ; ln -sf ioport outw )
( cd usr/lib ; rm -rf xserver )
( cd usr/lib ; ln -sf ../../etc/X11/xserver xserver )
( cd usr/lib ; rm -rf modules )
( cd usr/lib ; ln -sf xorg/modules modules )
