/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.java2d;

import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;

public class ImagePaint
implements Paint {
    RenderedImage image;
    AffineTransform transform;

    ImagePaint(RenderedImage renderedImage, AffineTransform affineTransform) {
        this.image = renderedImage;
        this.transform = affineTransform;
    }

    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        return new ImagePaintContext(this);
    }

    public int getTransparency() {
        return 1;
    }

    private class ImagePaintContext
    implements PaintContext {
        private /* synthetic */ ImagePaint this$0;
        private WritableRaster target;

        public void dispose() {
        }

        public ColorModel getColorModel() {
            return this.this$0.image.getColorModel();
        }

        public Raster getRaster(int n, int n2, int n3, int n4) {
            this.ensureRasterSize(n3, n4);
            int n5 = n + n3;
            int n6 = n2 + n4;
            float[] fArray = new float[2];
            float[] fArray2 = new float[2];
            Raster raster = this.this$0.image.getData();
            int n7 = raster.getMinX();
            int n8 = raster.getWidth() + n7;
            int n9 = raster.getMinY();
            int n10 = raster.getHeight() + n9;
            Object object = null;
            for (int i = n2; i < n6; ++i) {
                for (int j = n; j < n5; ++j) {
                    fArray[0] = j;
                    fArray[1] = i;
                    this.this$0.transform.transform(fArray, 0, fArray2, 0, 1);
                    int n11 = (int)fArray2[0];
                    int n12 = (int)fArray2[1];
                    if (n11 < n7 || n11 >= n8 || n12 < n9 || n12 >= n10) continue;
                    object = raster.getDataElements(n11, n12, object);
                    this.target.setDataElements(j - n, i - n2, object);
                }
            }
            return this.target;
        }

        private void ensureRasterSize(int n, int n2) {
            if (this.target == null || this.target.getWidth() < n || this.target.getHeight() < n2) {
                Raster raster = this.this$0.image.getData();
                this.target = raster.createCompatibleWritableRaster(n, n2);
            }
        }

        ImagePaintContext(ImagePaint imagePaint) {
            this.this$0 = imagePaint;
        }
    }
}

