/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.png;

import gnu.javax.imageio.IIOInputStream;
import gnu.javax.imageio.png.PNGFile;
import gnu.javax.imageio.png.PNGImageReaderSpi;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;

public class PNGImageReader
extends ImageReader {
    private PNGFile pngFile;
    private BufferedImage image;
    private ArrayList imageTypes;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public PNGImageReader(PNGImageReaderSpi pNGImageReaderSpi) {
        super(pNGImageReaderSpi);
    }

    public int getHeight(int n) throws IOException {
        this.checkIndex(n);
        this.readImage();
        return this.image.getHeight();
    }

    public int getWidth(int n) throws IOException {
        this.checkIndex(n);
        this.readImage();
        return this.image.getWidth();
    }

    public Iterator getImageTypes(int n) throws IOException {
        this.checkIndex(n);
        this.readImage();
        if (this.imageTypes == null) {
            this.imageTypes = new ArrayList();
            this.imageTypes.add(new ImageTypeSpecifier(this.image.getColorModel(), this.image.getSampleModel()));
        }
        return this.imageTypes.iterator();
    }

    public int getNumImages(boolean bl) throws IOException {
        return 1;
    }

    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        this.checkIndex(n);
        this.readImage();
        return this.image;
    }

    public void setInput(Object object, boolean bl, boolean bl2) {
        super.setInput(object, bl, bl2);
        if (!(object instanceof InputStream) && !(object instanceof ImageInputStream)) {
            throw new IllegalArgumentException("Input not an ImageInputStream");
        }
    }

    public IIOMetadata getImageMetadata(int n) throws IOException {
        this.checkIndex(n);
        return null;
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    private void checkIndex(int n) {
        if (n > 0) {
            throw new IndexOutOfBoundsException("Image index out of bounds");
        }
    }

    private void readImage() throws IOException {
        if (this.pngFile == null) {
            if (this.input instanceof InputStream) {
                this.pngFile = new PNGFile((InputStream)this.input);
            } else if (this.input instanceof ImageInputStream) {
                this.pngFile = new PNGFile(new IIOInputStream((ImageInputStream)this.input));
            } else if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Must not happen");
            }
        }
        if (this.pngFile != null && this.image == null) {
            this.image = this.pngFile.getBufferedImage();
        }
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = PNGImageReader.class$("gnu.javax.imageio.png.PNGImageReader").desiredAssertionStatus() ^ true;
    }
}

