/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.Handshake;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.Util;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class Finished
implements Handshake.Body {
    private final byte[] verifyData;
    private final byte[] md5;
    private final byte[] sha;

    Finished(byte[] byArray) {
        this.verifyData = byArray;
        this.sha = null;
        this.md5 = null;
    }

    Finished(byte[] byArray, byte[] byArray2) {
        this.md5 = byArray;
        this.sha = byArray2;
        this.verifyData = null;
    }

    static Finished read(InputStream inputStream, CipherSuite cipherSuite) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        if (cipherSuite.getVersion().equals(ProtocolVersion.SSL_3)) {
            byte[] byArray = new byte[16];
            byte[] byArray2 = new byte[20];
            dataInputStream.readFully(byArray);
            dataInputStream.readFully(byArray2);
            return new Finished(byArray, byArray2);
        }
        byte[] byArray = new byte[12];
        dataInputStream.readFully(byArray);
        return new Finished(byArray);
    }

    public void write(OutputStream outputStream) throws IOException {
        if (this.verifyData != null) {
            outputStream.write(this.verifyData);
        } else {
            outputStream.write(this.md5);
            outputStream.write(this.sha);
        }
    }

    byte[] getVerifyData() {
        return this.verifyData;
    }

    byte[] getMD5Hash() {
        return this.md5;
    }

    byte[] getSHAHash() {
        return this.sha;
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        if (this.verifyData != null) {
            return "struct {" + string + "  verifyData = " + Util.toHexString(this.verifyData, ':') + ";" + string + "} Finished;" + string;
        }
        return "struct {" + string + "  md5Hash = " + Util.toHexString(this.md5, ':') + ";" + string + "  shaHash = " + Util.toHexString(this.sha, ':') + ";" + string + "} Finished;" + string;
    }
}

