/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Menu;
import java.awt.peer.PopupMenuPeer;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;

public class PopupMenu
extends Menu {
    private static transient long next_popup_number;
    private static final long serialVersionUID = -4620452533522760060L;

    public PopupMenu() {
    }

    public PopupMenu(String string) {
        super(string);
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createPopupMenu(this);
        }
        super.addNotify();
    }

    public void show(Component component, int n, int n2) {
        PopupMenuPeer popupMenuPeer;
        if (this.getPeer() == null) {
            this.addNotify();
        }
        if ((popupMenuPeer = (PopupMenuPeer)this.getPeer()) != null) {
            popupMenuPeer.show(component, n, n2);
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTPopupMenu(this);
        }
        return this.accessibleContext;
    }

    String generateName() {
        return "popup" + PopupMenu.getUniqueLong();
    }

    private static synchronized long getUniqueLong() {
        return next_popup_number++;
    }

    protected class AccessibleAWTPopupMenu
    extends Menu.AccessibleAWTMenu {
        private /* synthetic */ PopupMenu this$0;
        private static final long serialVersionUID = -4282044795947239955L;

        protected AccessibleAWTPopupMenu(PopupMenu popupMenu) {
            this.this$0 = popupMenu;
            super(popupMenu);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.POPUP_MENU;
        }
    }
}

