/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.FloatBuffer;

final class FloatBufferImpl
extends FloatBuffer {
    private boolean readOnly;

    FloatBufferImpl(int n) {
        this(new float[n], 0, n, n, 0, -1, false);
    }

    FloatBufferImpl(float[] fArray, int n, int n2, int n3, int n4, int n5, boolean bl) {
        super(n2, n3, n4, n5);
        this.backing_buffer = fArray;
        this.array_offset = n;
        this.readOnly = bl;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public FloatBuffer slice() {
        return new FloatBufferImpl(this.backing_buffer, this.array_offset + this.position(), this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    public FloatBuffer duplicate() {
        return new FloatBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, this.isReadOnly());
    }

    public FloatBuffer asReadOnlyBuffer() {
        return new FloatBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, true);
    }

    public FloatBuffer compact() {
        this.checkIfReadOnly();
        this.mark = -1;
        int n = this.position();
        int n2 = this.limit() - n;
        if (n2 > 0) {
            System.arraycopy(this.backing_buffer, this.array_offset + n, this.backing_buffer, this.array_offset, n2);
        }
        this.position(n2);
        this.limit(this.capacity());
        return this;
    }

    public boolean isDirect() {
        return false;
    }

    public float get() {
        this.checkForUnderflow();
        float f = this.backing_buffer[this.position()];
        this.position(this.position() + 1);
        return f;
    }

    public FloatBuffer put(float f) {
        this.checkIfReadOnly();
        this.checkForOverflow();
        this.backing_buffer[this.position()] = f;
        this.position(this.position() + 1);
        return this;
    }

    public float get(int n) {
        this.checkIndex(n);
        return this.backing_buffer[n];
    }

    public FloatBuffer put(int n, float f) {
        this.checkIfReadOnly();
        this.checkIndex(n);
        this.backing_buffer[n] = f;
        return this;
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

