/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertSelector;
import java.security.cert.PKIXParameters;
import java.util.Set;

public class PKIXBuilderParameters
extends PKIXParameters {
    private int maxPathLength;

    public PKIXBuilderParameters(KeyStore keyStore, CertSelector certSelector) throws KeyStoreException, InvalidAlgorithmParameterException {
        super(keyStore);
        this.setTargetCertConstraints(certSelector);
        this.maxPathLength = 5;
    }

    public PKIXBuilderParameters(Set set, CertSelector certSelector) throws InvalidAlgorithmParameterException {
        super(set);
        this.setTargetCertConstraints(certSelector);
        this.maxPathLength = 5;
    }

    public int getMaxPathLength() {
        return this.maxPathLength;
    }

    public void setMaxPathLength(int n) {
        if (n < -1) {
            throw new IllegalArgumentException();
        }
        this.maxPathLength = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.insert(stringBuffer.length() - 2, "; Max Path Length=" + this.maxPathLength);
        return stringBuffer.toString();
    }
}

