( cd usr/lib ; rm -rf libscim-1.0.so )
( cd usr/lib ; ln -sf libscim-1.0.so.8.2.3 libscim-1.0.so )
( cd usr/lib ; rm -rf libscim-x11utils-1.0.so )
( cd usr/lib ; ln -sf libscim-x11utils-1.0.so.8.2.3 libscim-x11utils-1.0.so )
( cd usr/lib ; rm -rf libscim-x11utils-1.0.so.8 )
( cd usr/lib ; ln -sf libscim-x11utils-1.0.so.8.2.3 libscim-x11utils-1.0.so.8 )
( cd usr/lib ; rm -rf libscim-gtkutils-1.0.so )
( cd usr/lib ; ln -sf libscim-gtkutils-1.0.so.8.2.3 libscim-gtkutils-1.0.so )
( cd usr/lib ; rm -rf libscim-1.0.so.8 )
( cd usr/lib ; ln -sf libscim-1.0.so.8.2.3 libscim-1.0.so.8 )
( cd usr/lib ; rm -rf libscim-gtkutils-1.0.so.8 )
( cd usr/lib ; ln -sf libscim-gtkutils-1.0.so.8.2.3 libscim-gtkutils-1.0.so.8 )


# Handle the incoming configuration files:
config() {
  for infile in $1; do
    NEW="$infile"
    OLD="`dirname $NEW`/`basename $NEW .new`"
    # If there's no config file by that name, mv it over:
    if [ ! -r $OLD ]; then
      mv $NEW $OLD
    elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then
      # toss the redundant copy
      rm $NEW
    fi
    # Otherwise, we leave the .new copy for the admin to consider...
  done
}

# Prepare the new configuration files
for file in etc/scim/config.new etc/scim/global.new etc/profile.d/scim.sh.new etc/profile.d/scim.csh.new ; do
  if [ -e $(dirname $file)/$(basename $file .new) -a -x $(dirname $file)/$(basename $file .new) ]; then
    chmod 755 $file
  else
    chmod 644 $file
  fi
  config $file
done

# Run gtk-query-immodules so that "scim" will appear under Imput Method
# when you right- click your mouse in a text box.
if [ -x usr/bin/gtk-query-immodules-2.0 ]; then
  mkdir -p etc/gtk-2.0
  chroot . usr/bin/gtk-query-immodules-2.0 > etc/gtk-2.0/gtk.immodules
fi

