/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.concurrent.locks;

import info.aduna.concurrent.locks.AbstractDebugLock;
import info.aduna.concurrent.locks.AbstractLock;
import info.aduna.concurrent.locks.Lock;
import info.aduna.concurrent.locks.Properties;
import java.lang.ref.WeakReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExclusiveLockManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final boolean trackLocks;
    private boolean lockInUse = false;
    private WeakReference<Lock> activeLock;

    public ExclusiveLockManager() {
        this(false);
    }

    public ExclusiveLockManager(boolean trackLocks) {
        this.trackLocks = trackLocks || Properties.lockTrackingEnabled();
    }

    public synchronized Lock tryExclusiveLock() {
        if (this.lockInUse) {
            return null;
        }
        return this.createLock();
    }

    public synchronized Lock getExclusiveLock() throws InterruptedException {
        while (this.lockInUse) {
            this.wait();
        }
        return this.createLock();
    }

    private Lock createLock() {
        this.lockInUse = true;
        if (this.trackLocks) {
            ExclusiveDebugLock lock = new ExclusiveDebugLock(this.logger, true);
            this.activeLock = new WeakReference<ExclusiveDebugLock>(lock);
            return lock;
        }
        return new ExclusiveLock();
    }

    private synchronized void releaseExclusiveLock() {
        this.lockInUse = false;
        this.activeLock = null;
        this.notifyAll();
    }

    protected class ExclusiveDebugLock
    extends AbstractDebugLock {
        public ExclusiveDebugLock(Logger logger, boolean enableTrace) {
            super(logger, enableTrace);
        }

        protected void releaseLock() {
            ExclusiveLockManager.this.releaseExclusiveLock();
        }
    }

    protected class ExclusiveLock
    extends AbstractLock {
        protected ExclusiveLock() {
        }

        protected void releaseLock() {
            ExclusiveLockManager.this.releaseExclusiveLock();
        }
    }
}

