/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.io.Serializable;

public class MenuShortcut
implements Serializable {
    int key;
    boolean usesShift;
    private static final long serialVersionUID = 143448358473180225L;

    public MenuShortcut(int n2) {
        this(n2, false);
    }

    public MenuShortcut(int n2, boolean bl2) {
        this.key = n2;
        this.usesShift = bl2;
    }

    public int getKey() {
        return this.key;
    }

    public boolean usesShiftModifier() {
        return this.usesShift;
    }

    public boolean equals(MenuShortcut menuShortcut) {
        return menuShortcut != null && menuShortcut.getKey() == this.key && menuShortcut.usesShiftModifier() == this.usesShift;
    }

    public boolean equals(Object object) {
        if (object instanceof MenuShortcut) {
            return this.equals((MenuShortcut)object);
        }
        return false;
    }

    public int hashCode() {
        return this.usesShift ? ~this.key : this.key;
    }

    public String toString() {
        int n2 = 0;
        if (!GraphicsEnvironment.isHeadless()) {
            n2 = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        }
        if (this.usesShiftModifier()) {
            n2 |= 1;
        }
        return KeyEvent.getKeyModifiersText(n2) + "+" + KeyEvent.getKeyText(this.key);
    }

    protected String paramString() {
        String string = "key=" + this.key;
        if (this.usesShiftModifier()) {
            string = string + ",usesShiftModifier";
        }
        return string;
    }
}

