/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.navig.motif;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.BufferedInputStream;
import java.io.CharConversionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Properties;
import sun.awt.CharsetString;
import sun.awt.PlatformFont;
import sun.awt.motif.MFontPeer;
import sun.io.CharToByteConverter;
import sun.plugin.navig.motif.PluginPSGraphics;

public class PluginPSPrintStream {
    PrintStream ps;
    PrintJob job;
    public String title;
    public Dimension paperDim;
    Properties fontProps;
    int curPage = -1;
    Rectangle curClip;
    Color curColor;
    Font curFont;
    int[] curColormap;
    boolean prologSent = false;
    boolean lastFirst = false;
    Color paperColor = Color.white;
    static String SetColorName = "SC";
    static String SetFontName = "SF";
    static String RectClipName = "RC";
    static String InitClipName = "IC";
    static String RectFillName = "RF";
    static String RectStrokeName = "RS";
    static String RRectFillName = "RRF";
    static String RRectStrokeName = "RRS";
    static String ArcFillName = "AF";
    static String ArcStrokeName = "AS";
    static String PolygonFillName = "PYF";
    static String PolygonStrokeName = "PYS";
    static String DrawStringName = "DS";
    static String DrawLineName = "DL";
    static String ScaleName = "S";
    static String StartPageName = "SP";
    static String EndPageName = "EP";
    static String GsaveName = "GS";
    static String GrestoreName = "GR";
    static String SetColormapName = "CM";
    static String DrawImageName = "DI";
    static String DrawIndexImageName = "DII";
    static String testString = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ 1234567890";
    private static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public PluginPSPrintStream(PrintJob printJob, PrintStream printStream, String string, Dimension dimension, boolean bl) {
        this.job = printJob;
        this.ps = printStream;
        this.title = string;
        this.paperDim = dimension;
        this.lastFirst = bl;
        this.fontProps = this.initProps();
    }

    private Properties initProps() {
        String string = System.getProperty("java.home");
        if (string != null) {
            String string2 = System.getProperty("user.language", "en");
            try {
                File file = new File(string + File.separator + "lib" + File.separator + "psfont.properties." + string2);
                if (!file.canRead() && !(file = new File(string + File.separator + "lib" + File.separator + "psfont.properties")).canRead()) {
                    return null;
                }
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file.getPath()));
                Properties properties = new Properties();
                properties.load(bufferedInputStream);
                ((InputStream)bufferedInputStream).close();
                return properties;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public void startPage(int n) {
        this.curClip = null;
        this.curColor = null;
        this.curFont = null;
        this.curColormap = null;
        this.curPage = n;
        if (this.job != null) {
            this.ps.println("\n%%Page:  " + n + " " + n);
        }
        this.ps.println(StartPageName);
    }

    public void endPage() {
        this.ps.println(EndPageName);
        this.curPage = -1;
        this.ps.flush();
    }

    public void close(int n) {
        if (this.job != null) {
            this.ps.println("%%Trailer");
            this.ps.println("%%Pages: " + n);
        }
        this.ps.println("%%EOF");
        this.ps.flush();
    }

    private void outPoint(PluginPSGraphics pluginPSGraphics, int n, int n2) {
        this.ps.print(pluginPSGraphics.adjustX + n + " " + (pluginPSGraphics.adjustY - n2) + " ");
    }

    private void outRect(PluginPSGraphics pluginPSGraphics, int n, int n2, int n3, int n4) {
        this.outPoint(pluginPSGraphics, n, n2);
        this.ps.print(n3 + " " + -n4 + " ");
    }

    private void outClip(PluginPSGraphics pluginPSGraphics) {
        Rectangle rectangle = pluginPSGraphics.clipRect;
        if (this.curClip != rectangle) {
            this.ps.println(InitClipName);
            if (rectangle != null) {
                this.outRect(pluginPSGraphics, rectangle.x - pluginPSGraphics.originX, rectangle.y - pluginPSGraphics.originY, rectangle.width, rectangle.height);
                this.ps.println(RectClipName);
            }
            this.curClip = rectangle;
        }
    }

    private void outColor(Color color) {
        if (this.curColor != color) {
            this.ps.println(color.getRed() + " " + color.getGreen() + " " + color.getBlue() + " " + SetColorName);
            this.curColor = color;
        }
    }

    private void outFont(PluginPSGraphics pluginPSGraphics) {
        Font font = pluginPSGraphics.font;
        if (this.curFont != font) {
            this.curFont = font;
            FontMetrics fontMetrics = pluginPSGraphics.curMetrics;
            if (pluginPSGraphics.curMetrics == null) {
                pluginPSGraphics.curMetrics = fontMetrics = pluginPSGraphics.getFontMetrics(font);
            }
            int n = fontMetrics.stringWidth(testString);
            int n2 = font.getStyle();
            n2 = font.getFamily().startsWith("Helvetica") || font.getFamily().startsWith("SansSerif") ? 0 : (font.getFamily().startsWith("Dialog") ? 0 : (font.getFamily().startsWith("Times") || font.getFamily().startsWith("Serif") ? 4 : 8));
            if (font.isBold()) {
                ++n2;
            }
            if (font.isItalic()) {
                n2 += 2;
            }
            this.ps.println("% Font[" + font.getFamily() + ", " + font.getStyle() + ", " + font.getSize() + "]");
            this.ps.println(n + " " + font.getSize() + " " + n2 + " " + SetFontName);
        }
    }

    private void outStr(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '(' || c == ')' || c == '\\') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
            ++n;
        }
        stringBuffer.append(')');
        this.ps.print(stringBuffer.toString());
    }

    public synchronized void sendLine(PluginPSGraphics pluginPSGraphics, int n, int n2, int n3, int n4) {
        if (pluginPSGraphics.pageNumber != this.curPage) {
            return;
        }
        this.outClip(pluginPSGraphics);
        this.outColor(pluginPSGraphics.foreground);
        this.outPoint(pluginPSGraphics, n, n2);
        this.outPoint(pluginPSGraphics, n3, n4);
        this.ps.println(DrawLineName);
    }

    public synchronized void sendRect(PluginPSGraphics pluginPSGraphics, int n, int n2, int n3, int n4, Color color, boolean bl) {
        if (pluginPSGraphics.pageNumber != this.curPage) {
            return;
        }
        this.outClip(pluginPSGraphics);
        this.outColor(color);
        this.outRect(pluginPSGraphics, n, n2, n3, n4);
        this.ps.println(bl ? RectFillName : RectStrokeName);
    }

    void sendRect(PluginPSGraphics pluginPSGraphics, int n, int n2, int n3, int n4, boolean bl) {
        this.sendRect(pluginPSGraphics, n, n2, n3, n4, pluginPSGraphics.foreground, bl);
    }

    void fillRect(PluginPSGraphics pluginPSGraphics, int n, int n2, int n3, int n4, Color color) {
        this.sendRect(pluginPSGraphics, n, n2, n3, n4, color, true);
    }

    synchronized void sendRoundRect(PluginPSGraphics pluginPSGraphics, int n, int n2, int n3, int n4, float f, float f2, boolean bl) {
        if (pluginPSGraphics.pageNumber != this.curPage) {
            return;
        }
        this.outClip(pluginPSGraphics);
        this.outColor(pluginPSGraphics.foreground);
        this.outRect(pluginPSGraphics, n, n2, n3, n4);
        this.ps.print(f + " " + f2 + " ");
        this.ps.println(bl ? RRectFillName : RRectStrokeName);
    }

    synchronized void sendArc(PluginPSGraphics pluginPSGraphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (pluginPSGraphics.pageNumber != this.curPage) {
            return;
        }
        this.outClip(pluginPSGraphics);
        this.outColor(pluginPSGraphics.foreground);
        this.outPoint(pluginPSGraphics, n, n2);
        this.ps.print(n3 + " " + n4 + " " + n5 + " " + n6 + " ");
        this.ps.println(bl ? ArcFillName : ArcStrokeName);
    }

    synchronized void sendPolygon(PluginPSGraphics pluginPSGraphics, int[] nArray, int[] nArray2, int n, boolean bl, boolean bl2) {
        if (pluginPSGraphics.pageNumber != this.curPage) {
            return;
        }
        this.outClip(pluginPSGraphics);
        this.outColor(pluginPSGraphics.foreground);
        this.ps.print(bl + " ");
        int n2 = 0;
        while (n2 < n) {
            this.outPoint(pluginPSGraphics, nArray[n2], nArray2[n2]);
            ++n2;
        }
        this.ps.print(n + " ");
        this.ps.println(bl2 ? PolygonFillName : PolygonStrokeName);
    }

    synchronized void sendString(PluginPSGraphics pluginPSGraphics, String string, int n, int n2) {
        if (pluginPSGraphics.pageNumber != this.curPage) {
            return;
        }
        this.outClip(pluginPSGraphics);
        this.outColor(pluginPSGraphics.foreground);
        Font font = pluginPSGraphics.font;
        FontMetrics fontMetrics = pluginPSGraphics.curMetrics;
        if (fontMetrics == null) {
            pluginPSGraphics.curMetrics = fontMetrics = pluginPSGraphics.getFontMetrics(font);
        }
        if (this.fontProps == null) {
            this.outFont(pluginPSGraphics);
            this.outStr(string);
            this.ps.print(" " + fontMetrics.stringWidth(string) + " ");
            this.outPoint(pluginPSGraphics, n, n2);
            this.ps.println(DrawStringName);
            return;
        }
        CharsetString[] charsetStringArray = ((MFontPeer)font.getPeer()).makeMultiCharsetString(string);
        int n3 = 0;
        while (n3 < charsetStringArray.length) {
            block14: {
                int n4;
                int n5;
                int n6;
                CharsetString charsetString = charsetStringArray[n3];
                CharToByteConverter charToByteConverter = charsetString.fontDescriptor.fontCharset;
                int n7 = fontMetrics.charsWidth(charsetString.charsetChars, charsetString.offset, charsetString.length);
                String string2 = this.makeCharsetName(charToByteConverter.toString());
                String string3 = PlatformFont.styleStr((int)font.getStyle());
                String string4 = this.fontProps.getProperty(font.getName().toLowerCase(), "serif");
                String string5 = this.fontProps.getProperty(string4 + "." + string2 + "." + string3, "Courier ISOF");
                try {
                    n6 = Integer.parseInt(this.fontProps.getProperty(string5));
                }
                catch (NumberFormatException numberFormatException) {
                    n6 = 0;
                }
                StringBuffer stringBuffer = new StringBuffer();
                byte[] byArray = new byte[charsetString.length * 2];
                try {
                    n5 = charToByteConverter.convert(charsetString.charsetChars, charsetString.offset, charsetString.offset + charsetString.length, byArray, 0, byArray.length);
                }
                catch (CharConversionException charConversionException) {
                    break block14;
                }
                stringBuffer.append('<');
                int n8 = 0;
                while (n8 < n5) {
                    n4 = byArray[n8];
                    String string6 = Integer.toHexString(n4);
                    int n9 = string6.length();
                    if (n9 > 2) {
                        string6 = string6.substring(n9 - 2, n9);
                    } else if (n9 == 1) {
                        string6 = "0" + string6;
                    } else if (n9 == 0) {
                        string6 = "00";
                    }
                    stringBuffer.append(string6);
                    ++n8;
                }
                stringBuffer.append('>');
                this.ps.println("/testString " + stringBuffer.toString() + " D");
                this.ps.println("% Font[" + font.getName() + ", " + PlatformFont.styleStr((int)font.getStyle()) + ", " + font.getSize() + "]");
                this.ps.println(n7 + " " + font.getSize() + " " + n6 + " " + SetFontName);
                this.ps.println(stringBuffer.toString());
                n4 = fontMetrics.charsWidth(charsetString.charsetChars, charsetString.offset, charsetString.length);
                this.ps.print(" " + n4 + " ");
                this.outPoint(pluginPSGraphics, n, n2);
                this.ps.println(DrawStringName);
                n += n4;
            }
            ++n3;
        }
    }

    private String makeCharsetName(String string) {
        if (string.indexOf("8859_1") != -1) {
            return "latin1";
        }
        return string.toLowerCase();
    }

    private static final int blend(int n, int n2, int n3) {
        return (n * n2 + (255 - n) * n3) / 255;
    }

    private int sendColors(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        while (n2-- > 0) {
            if (n3 + 3 > byArray2.length) {
                byArray2[n3++] = 10;
                this.ps.write(byArray2, 0, n3);
                n3 = 0;
            }
            byte by = byArray[n++];
            byArray2[n3++] = (byte)hexDigits[by >>> 4 & 0xF];
            byArray2[n3++] = (byte)hexDigits[by >>> 0 & 0xF];
        }
        return n3;
    }

    private int sendColors(int[] nArray, int n, int n2, byte[] byArray, int n3) {
        while (n2-- > 0) {
            if (n3 + 7 > byArray.length) {
                byArray[n3++] = 10;
                this.ps.write(byArray, 0, n3);
                n3 = 0;
            }
            int n4 = nArray[n++];
            byArray[n3++] = (byte)hexDigits[n4 >>> 20 & 0xF];
            byArray[n3++] = (byte)hexDigits[n4 >>> 16 & 0xF];
            byArray[n3++] = (byte)hexDigits[n4 >>> 12 & 0xF];
            byArray[n3++] = (byte)hexDigits[n4 >>> 8 & 0xF];
            byArray[n3++] = (byte)hexDigits[n4 >>> 4 & 0xF];
            byArray[n3++] = (byte)hexDigits[n4 >>> 0 & 0xF];
        }
        return n3;
    }

    private void sendSubPixels(PluginPSGraphics pluginPSGraphics, byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, float f, float f2) {
        int n8 = n4 - n2;
        int n9 = n5 - n3;
        int n10 = n3 * n + n2;
        int n11 = 0;
        byte[] byArray2 = new byte[73];
        this.ps.print(n2 + " " + n3 + " ");
        this.ps.print(n8 + " " + n9 + " ");
        this.ps.print(f * (float)n8 + " " + f2 * (float)n9 + " ");
        this.outPoint(pluginPSGraphics, n6, n7);
        this.ps.println(DrawIndexImageName);
        int n12 = n3;
        while (n12 < n5) {
            n11 = this.sendColors(byArray, n10, n8, byArray2, n11);
            n10 += n;
            ++n12;
        }
        if (n11 > 0) {
            byArray2[n11++] = 10;
            this.ps.write(byArray2, 0, n11);
        }
    }

    private void sendSubPixels(PluginPSGraphics pluginPSGraphics, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, float f, float f2) {
        int n8 = n4 - n2;
        int n9 = n5 - n3;
        int n10 = n3 * n + n2;
        int n11 = 0;
        byte[] byArray = new byte[73];
        this.ps.print(n2 + " " + n3 + " ");
        this.ps.print(n8 + " " + n9 + " ");
        this.ps.print(f * (float)n8 + " " + f2 * (float)n9 + " ");
        this.outPoint(pluginPSGraphics, n6, n7);
        this.ps.println(DrawImageName);
        int n12 = n3;
        while (n12 < n5) {
            n11 = this.sendColors(nArray, n10, n8, byArray, n11);
            n10 += n;
            ++n12;
        }
        if (n11 > 0) {
            byArray[n11++] = 10;
            this.ps.write(byArray, 0, n11);
        }
    }

    private void sendColormap(PluginPSGraphics pluginPSGraphics, int[] nArray, int n) {
        int n2;
        if (this.curColormap != null) {
            boolean bl = true;
            n2 = 0;
            while (n2 < n) {
                if (nArray[n2] != this.curColormap[n2]) {
                    bl = false;
                    break;
                }
                ++n2;
            }
            if (bl) {
                return;
            }
        }
        this.curColormap = nArray;
        byte[] byArray = new byte[73];
        this.ps.println(n + " " + SetColormapName);
        n2 = this.sendColors(nArray, 0, n, byArray, 0);
        if (n2 > 0) {
            byArray[n2++] = 10;
            this.ps.write(byArray, 0, n2);
        }
    }

    synchronized void sendPixels(PluginPSGraphics pluginPSGraphics, byte[] byArray, IndexColorModel indexColorModel, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color) {
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        if (pluginPSGraphics.pageNumber != this.curPage) {
            return;
        }
        int[] nArray = new int[256];
        int n15 = indexColorModel.getMapSize();
        boolean[] blArray = new boolean[256];
        boolean bl = false;
        if (color != null) {
            n14 = color.getRed();
            n13 = color.getGreen();
            n12 = color.getBlue();
        } else {
            n12 = 0;
            n13 = 0;
            n14 = 0;
        }
        while (--n15 >= 0) {
            n11 = indexColorModel.getRGB(n15);
            n10 = n11 >>> 24;
            if (n10 != 255) {
                if (color != null) {
                    int n16 = PluginPSPrintStream.blend(n10, n11 >>> 16 & 0xFF, n14);
                    int n17 = PluginPSPrintStream.blend(n10, n11 >>> 8 & 0xFF, n13);
                    n9 = PluginPSPrintStream.blend(n10, n11 >>> 0 & 0xFF, n12);
                    n11 = n16 << 16 | n17 << 8 | n9;
                } else if (n10 < 128) {
                    blArray[n15] = true;
                    bl = true;
                }
            }
            nArray[n15] = n11;
        }
        this.outClip(pluginPSGraphics);
        this.sendColormap(pluginPSGraphics, nArray, indexColorModel.getMapSize());
        n11 = n7 - n5;
        n10 = n8 - n6;
        float f = (float)(n3 - n) / (float)n11;
        float f2 = (float)(n4 - n2) / (float)n10;
        if (bl) {
            n15 = 0;
            n9 = 0;
            while (n9 < n10) {
                int n18 = -1;
                int n19 = 0;
                while (n19 < n11) {
                    if (blArray[byArray[n15++] & 0xFF]) {
                        if (n18 >= 0) {
                            this.sendSubPixels(pluginPSGraphics, byArray, n11, n18, n9, n19, n9 + 1, n, n2, f, f2);
                            n18 = -1;
                        }
                    } else if (n18 < 0) {
                        n18 = n19;
                    }
                    ++n19;
                }
                if (n18 >= 0) {
                    this.sendSubPixels(pluginPSGraphics, byArray, n11, n18, n9, n11, n9 + 1, n, n2, f, f2);
                }
                ++n9;
            }
        } else {
            this.sendSubPixels(pluginPSGraphics, byArray, n11, 0, 0, n11, n10, n, n2, f, f2);
        }
    }

    synchronized void sendPixels(PluginPSGraphics pluginPSGraphics, int[] nArray, ColorModel colorModel, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color) {
        int n9;
        int n10;
        int n11;
        if (pluginPSGraphics.pageNumber != this.curPage) {
            return;
        }
        int n12 = n7 - n5;
        int n13 = n8 - n6;
        float f = (float)(n3 - n) / (float)n12;
        float f2 = (float)(n4 - n2) / (float)n13;
        if (color != null) {
            n11 = color.getRed();
            n10 = color.getGreen();
            n9 = color.getBlue();
        } else {
            n9 = 0;
            n10 = 0;
            n11 = 0;
        }
        this.outClip(pluginPSGraphics);
        int n14 = 0;
        int n15 = -1;
        int n16 = 0;
        while (n16 < n13) {
            int n17 = -1;
            int n18 = 0;
            while (n18 < n12) {
                int n19 = colorModel.getRGB(nArray[n14]);
                int n20 = n19 >>> 24;
                if (n20 != 255) {
                    if (color != null) {
                        int n21 = PluginPSPrintStream.blend(n20, n19 >>> 16 & 0xFF, n11);
                        int n22 = PluginPSPrintStream.blend(n20, n19 >>> 8 & 0xFF, n10);
                        int n23 = PluginPSPrintStream.blend(n20, n19 >>> 0 & 0xFF, n9);
                        nArray[n14] = n21 << 16 | n22 << 8 | n23;
                        if (n17 < 0) {
                            n17 = n18;
                        }
                    } else if (n17 >= 0) {
                        if (n15 >= 0) {
                            this.sendSubPixels(pluginPSGraphics, nArray, n12, 0, n15, n12, n16, n, n2, f, f2);
                            n15 = -1;
                        }
                        this.sendSubPixels(pluginPSGraphics, nArray, n12, n17, n16, n18, n16 + 1, n, n2, f, f2);
                        n17 = -1;
                    }
                } else {
                    nArray[n14] = n19;
                    if (n17 < 0) {
                        n17 = n18;
                    }
                }
                ++n14;
                ++n18;
            }
            if (n17 == 0) {
                if (n15 < 0) {
                    n15 = n16;
                }
            } else if (n17 > 0) {
                this.sendSubPixels(pluginPSGraphics, nArray, n12, n17, n16, n12, n16 + 1, n, n2, f, f2);
            }
            ++n16;
        }
        if (n15 >= 0) {
            this.sendSubPixels(pluginPSGraphics, nArray, n12, 0, n15, n12, n13, n, n2, f, f2);
        }
    }

    public void sendProlog() {
        if (this.prologSent) {
            return;
        }
        if (this.job != null) {
            this.ps.println("%!PS-Adobe-3.0");
        } else {
            this.ps.println("%!PS-Adobe-3.0 EPSF-3.0");
        }
        this.ps.println("%%Title: " + this.title);
        if (this.job != null) {
            this.ps.println("%%Pages: (atend)");
            this.ps.println("%%PageOrder: " + (this.lastFirst ? "Special" : "Ascend"));
        } else {
            this.ps.println("%%BoundingBox: 0 0 " + this.paperDim.width + " " + this.paperDim.height);
        }
        this.ps.println("%%DocumentFonts: Helvetica Helvetica-Bold");
        this.ps.println("%%+Helvetica-Oblique Helvetica-BoldOblique");
        this.ps.println("%%+Times-Roman Times-Bold Times-Italic Times-BoldItalic");
        this.ps.println("%%+Courier Courier-Bold Courier-Oblique Courier-BoldOblique");
        this.ps.println("%%EndComments");
        this.ps.println("%%BeginProlog");
        this.ps.println("/BD {bind def} bind def");
        this.ps.println("/D {def} BD");
        this.ps.println("/ISOF {");
        this.ps.println("    dup findfont dup length 1 add dict begin {");
        this.ps.println("            1 index /FID eq {pop pop} {D} ifelse");
        this.ps.println("    } forall /Encoding ISOLatin1Encoding D");
        this.ps.println("    currentdict end definefont");
        this.ps.println("} BD");
        this.ps.println("/F [");
        if (this.fontProps == null) {
            this.ps.println("        /Helvetica ISOF");
            this.ps.println("        /Helvetica-Bold ISOF");
            this.ps.println("        /Helvetica-Oblique ISOF");
            this.ps.println("        /Helvetica-BoldOblique ISOF");
            this.ps.println("        /Times-Roman ISOF");
            this.ps.println("        /Times-Bold ISOF");
            this.ps.println("        /Times-Italic ISOF");
            this.ps.println("        /Times-BoldItalic ISOF");
            this.ps.println("        /Courier ISOF");
            this.ps.println("        /Courier-Bold ISOF");
            this.ps.println("        /Courier-Oblique ISOF");
            this.ps.println("        /Courier-BoldOblique ISOF");
        } else {
            int n = Integer.parseInt(this.fontProps.getProperty("font.num", "9"));
            int n2 = 0;
            while (n2 < n) {
                this.ps.println("    /" + this.fontProps.getProperty("font." + String.valueOf(n2), "Courier ISOF"));
                ++n2;
            }
        }
        this.ps.println("] D");
        this.ps.println("/R {4 2 roll moveto 1 index 0 rlineto");
        this.ps.println("    0 exch rlineto neg 0 rlineto closepath} BD");
        this.ps.println("/Adict 8 dict D");
        this.ps.println("Adict /mtrx matrix put");
        this.ps.println("/A { Adict begin");
        this.ps.println("    /endangle exch D /startangle exch D");
        this.ps.println("    /yrad exch D /xrad exch D");
        this.ps.println("    /y exch D /x exch D");
        this.ps.println("    /savematrix mtrx currentmatrix D");
        this.ps.println("    x y translate xrad yrad scale");
        this.ps.println("    0 0 1 startangle endangle arc");
        this.ps.println("    savematrix setmatrix");
        this.ps.println("    end } BD");
        this.ps.println("/PY {");
        this.ps.println("    dup 1 ge {3 1 roll moveto} if");
        this.ps.println("    -1 2 {pop lineto} for");
        this.ps.println("    {closepath} if");
        this.ps.println("} BD");
        this.ps.println("/CL { dup 0 exch -1 1 arct} BD");
        this.ps.println("/RCL { dup 0 exch 1 1 arct} BD");
        this.ps.println("/RRdict 8 dict D");
        this.ps.println("RRdict /mtrx matrix put");
        this.ps.println("/RR {RRdict begin");
        this.ps.println("    /yrad exch D /xrad exch D");
        this.ps.println("    /height exch abs D /width exch D");
        this.ps.println("    /y exch D /x exch D");
        this.ps.println("    /width width xrad div D /height height yrad div D");
        this.ps.println("    /savematrix mtrx currentmatrix D");
        this.ps.println("    x y translate xrad yrad scale -90 rotate");
        this.ps.println("    1 0 moveto width RCL width 0 translate -90 rotate");
        this.ps.println("    height CL height 0 translate -90 rotate");
        this.ps.println("    width RCL width 0 translate -90 rotate height CL closepath");
        this.ps.println("    savematrix setmatrix");
        this.ps.println("    end } BD");
        this.ps.println("/" + SetColorName + " {3 {255 div 3 1 roll} repeat setrgbcolor} BD");
        this.ps.println("/" + SetFontName + " {");
        this.ps.println("    F exch get exch scalefont setfont");
        if (this.fontProps == null) {
            this.ps.println("        (" + testString + ") stringwidth pop div");
        } else {
            this.ps.println(" testString stringwidth pop div");
        }
        this.ps.println("    currentfont exch scalefont setfont} BD");
        this.ps.println("/" + RectClipName + " {R clip newpath} BD");
        this.ps.println("/" + InitClipName + " {initclip} BD");
        this.ps.println("/" + RectFillName + " {R fill} BD");
        this.ps.println("/" + RectStrokeName + " {R stroke} BD");
        this.ps.println("/" + RRectFillName + " {RR fill} BD");
        this.ps.println("/" + RRectStrokeName + " {RR stroke} BD");
        this.ps.println("/" + ArcStrokeName + " {A stroke} BD");
        this.ps.println("/" + ArcFillName + " {6 -2 roll 2 copy moveto 6 2 roll A fill} BD");
        this.ps.println("/" + PolygonStrokeName + " {PY stroke} BD");
        this.ps.println("/" + PolygonFillName + " {PY eofill} BD");
        this.ps.println("/NZ {dup 1 lt {pop 1} if} BD");
        this.ps.println("/" + DrawStringName + " {");
        this.ps.println("    moveto 1 index stringwidth pop NZ sub");
        this.ps.println("    1 index length 1 sub NZ div 0");
        this.ps.println("    3 2 roll ashow} BD");
        this.ps.println("/" + DrawLineName + " {moveto lineto stroke} BD");
        this.ps.println("/" + ScaleName + " {scale} BD");
        this.ps.println("/" + StartPageName + " {/P save D} BD");
        this.ps.println("/" + EndPageName + " {showpage P restore} BD");
        this.ps.println("/" + GsaveName + " {gsave} BD");
        this.ps.println("/" + GrestoreName + " {grestore} BD");
        this.ps.println("/" + SetColormapName + " {");
        this.ps.println("    /cmapr 256 array D");
        this.ps.println("    /cmapg 256 array D");
        this.ps.println("    /cmapb 256 array D");
        this.ps.println("    /cmapgray null D");
        this.ps.println("    3 string exch 0 exch 1 exch 1 sub {");
        this.ps.println("            currentfile 2 index readhexstring pop");
        this.ps.println("            cmapr 2 index 2 index 0 get put");
        this.ps.println("            cmapg 2 index 2 index 1 get put");
        this.ps.println("            cmapb 2 index 2 index 2 get put");
        this.ps.println("    pop pop } for pop");
        this.ps.println("} BD");
        this.ps.println("/" + DrawIndexImageName + " {");
        this.ps.println("    GS");
        this.ps.println("    /imgsave save D");
        this.ps.println("    translate scale");
        this.ps.println("    /imgh exch D");
        this.ps.println("    /imgw exch D");
        this.ps.println("    /imgy exch neg D");
        this.ps.println("    /imgx exch neg D");
        this.ps.println("    /imgstr imgw string D");
        this.ps.println("    /colorimage where {");
        this.ps.println("            pop");
        this.ps.println("            /cimgstr imgw 3 mul string D");
        this.ps.println("            imgw imgh 8 [imgw 0 0 imgh neg imgx imgy] {");
        this.ps.println("                    currentfile imgstr readhexstring pop");
        this.ps.println("                    0 1 imgw 1 sub {");
        this.ps.println("                            2 copy get");
        this.ps.println("                            cmapr 1 index get");
        this.ps.println("                            cimgstr exch 3 index");
        this.ps.println("                            3 mul exch put");
        this.ps.println("                            cmapg 1 index get");
        this.ps.println("                            cimgstr exch 3 index");
        this.ps.println("                            3 mul 1 add exch put");
        this.ps.println("                            cmapb 1 index get");
        this.ps.println("                            cimgstr exch 3 index");
        this.ps.println("                            3 mul 2 add exch put");
        this.ps.println("                    pop pop } for pop cimgstr");
        this.ps.println("            } false 3 colorimage");
        this.ps.println("    } {");
        this.ps.println("            cmapgray null eq {");
        this.ps.println("                    /cmapgray cmapr length array D");
        this.ps.println("                    0 1 cmapr length 1 sub {");
        this.ps.println("                            cmapgray exch");
        this.ps.println("                            cmapr 1 index get .299 mul");
        this.ps.println("                            cmapg 2 index get .587 mul");
        this.ps.println("                            cmapb 3 index get .114 mul");
        this.ps.println("                            add add cvi put");
        this.ps.println("                    } for");
        this.ps.println("            } if");
        this.ps.println("            imgw imgh 8 [imgw 0 0 imgh neg 0 0] {");
        this.ps.println("                    currentfile imgstr readhexstring pop");
        this.ps.println("                    0 1 imgw 1 sub {");
        this.ps.println("                            imgstr exch 2 copy get");
        this.ps.println("                            cmapgray exch get put");
        this.ps.println("                    } for");
        this.ps.println("            } image");
        this.ps.println("    } ifelse");
        this.ps.println("    imgsave restore");
        this.ps.println("    GR");
        this.ps.println("} BD");
        this.ps.println("/" + DrawImageName + " {");
        this.ps.println("    GS");
        this.ps.println("    /imgsave save D");
        this.ps.println("    translate scale");
        this.ps.println("    /imgh exch D");
        this.ps.println("    /imgw exch D");
        this.ps.println("    /imgy exch neg D");
        this.ps.println("    /imgx exch neg D");
        this.ps.println("    /imgstr imgw 3 mul string D");
        this.ps.println("    imgw imgh 8 [imgw 0 0 imgh neg imgx imgy] {");
        this.ps.println("            currentfile imgstr readhexstring pop");
        this.ps.println("    } bind false 3 colorimage");
        this.ps.println("    imgsave restore");
        this.ps.println("    GR");
        this.ps.println("} BD");
        this.ps.println("%%EndProlog");
        this.ps.println("%%BeginSetup");
        this.ps.println("%%EndSetup");
        this.ps.flush();
        this.prologSent = true;
    }

    public void sendBeginEPSF() {
        this.ps.println("BeginEPSF");
    }

    public void sendEndEPSF() {
        this.ps.println("EndEPSF");
    }

    public void sendBeginDoc() {
        this.ps.println("%%%%BeginDocument: JavaPluginApplet");
    }

    public void sendEndDoc() {
        this.ps.println("%%%%EndDocument: JavaPluginApplet");
    }

    public void sendPosition(int n, int n2, int n3, int n4, float f, float f2) {
        this.ps.println(n + " " + n2 + " moveto");
        this.ps.print(n3 + " 0" + " rlineto");
        this.ps.print(" 0 -" + n4 + " rlineto");
        this.ps.println(" -" + n3 + " 0 rlineto closepath clip");
        this.ps.println(n + " " + (n2 - n4) + " translate");
        this.ps.println(f + " " + f2 + " scale");
    }
}

