/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.net.protocol.file;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.FileNameMap;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import sun.net.www.MessageHeader;
import sun.net.www.ParseUtil;
import sun.plugin.usability.ProgressInputStream;

public class PluginFileURLConnection
extends sun.net.www.URLConnection {
    static String CONTENT_LENGTH = "content-length";
    static String CONTENT_TYPE = "content-type";
    static String TEXT_PLAIN = "text/plain";
    static String LAST_MODIFIED = "last-modified";
    String contentType;
    InputStream is;
    URLConnection conn;
    File file;
    String filename;
    boolean isDirectory = false;
    boolean exists = false;
    List files;
    private boolean initializedHeaders = false;
    long length = 0L;
    long lastModified = 0L;
    Permission permission;

    PluginFileURLConnection(URL uRL, URLConnection uRLConnection) {
        super(uRL);
        this.conn = uRLConnection;
    }

    public synchronized InputStream getInputStream() throws IOException {
        InputStream inputStream = this.conn.getInputStream();
        return new ProgressInputStream(inputStream, this.conn);
    }

    public void connect() throws IOException {
        if (!this.connected) {
            String string = ParseUtil.decode(this.url.getPath());
            this.file = new File(string.replace('/', File.separatorChar));
            this.filename = this.file.toString();
            this.isDirectory = this.file.isDirectory();
            if (this.isDirectory) {
                this.files = Arrays.asList(this.file.list());
            } else {
                this.is = new BufferedInputStream(new FileInputStream(this.filename));
            }
            this.connected = true;
        }
    }

    private void initializeHeaders() {
        try {
            this.connect();
            this.exists = this.file.exists();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!this.initializedHeaders || !this.exists) {
            this.length = this.file.length();
            this.lastModified = this.file.lastModified();
            if (!this.isDirectory) {
                FileNameMap fileNameMap = URLConnection.getFileNameMap();
                this.contentType = fileNameMap.getContentTypeFor(this.filename);
                if (this.contentType != null) {
                    this.properties.add(CONTENT_TYPE, this.contentType);
                }
                this.properties.add(CONTENT_LENGTH, String.valueOf(this.length));
                if (this.lastModified != 0L) {
                    Date date = new Date(this.lastModified);
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
                    simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                    this.properties.add(LAST_MODIFIED, simpleDateFormat.format(date));
                }
            } else {
                this.properties.add(CONTENT_TYPE, TEXT_PLAIN);
            }
            this.initializedHeaders = true;
        }
    }

    public String getHeaderField(String string) {
        this.initializeHeaders();
        return super.getHeaderField(string);
    }

    public String getHeaderField(int n) {
        this.initializeHeaders();
        return super.getHeaderField(n);
    }

    public int getContentLength() {
        this.initializeHeaders();
        return super.getContentLength();
    }

    public String getHeaderFieldKey(int n) {
        this.initializeHeaders();
        return super.getHeaderFieldKey(n);
    }

    public MessageHeader getProperties() {
        this.initializeHeaders();
        return super.getProperties();
    }

    public Permission getPermission() throws IOException {
        if (this.permission == null) {
            String string = ParseUtil.decode(this.url.getPath());
            this.permission = File.separatorChar == '/' ? new FilePermission(string, "read") : new FilePermission(string.replace('/', File.separatorChar), "read");
        }
        return this.permission;
    }
}

