/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.panel;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import sun.plugin.panel.MessageHandler;
import sun.plugin.security.HttpsRootCACertStore;
import sun.plugin.security.PluginCertificateStore;
import sun.plugin.security.PluginHttpsCertStore;
import sun.plugin.security.RootCACertificateStore;
import sun.plugin.usability.DialogFactory;
import sun.plugin.usability.Trace;
import sun.plugin.usability.UserProfile;

public class ConfigurationInfo {
    private static File theUserPropertiesFile;
    private Properties props;
    private boolean debugMode = false;
    private boolean javapluginEnabled = true;
    private String showConsole = "hide";
    private boolean showException = false;
    private String debugPort = "2502";
    private String[][] installedJREs;
    private String[][] installedJDKs;
    private boolean useDefaultProxy = true;
    private String proxySettings;
    private String proxyByPass;
    private String autoProxyURL;
    private String javaParms;
    private String javaVersion;
    private String javaRuntimePath = null;
    private String javaRuntimeType = "Default";
    private boolean cacheEnabled;
    private String cacheLocation = null;
    private String cacheSize;
    private int JARCacheCompression;
    private File defaultCacheLocation;
    private boolean iexplorerDefault = false;
    private boolean netscape6Default = false;
    private boolean showBrowserPanel = false;
    private HashMap activeCertsMap = new HashMap();
    private HashMap inactiveCertsMap = new HashMap();
    private HashMap inactiveImpCertsMap = new HashMap();
    private HashMap activeHttpsCertsMap = new HashMap();
    private HashMap inactiveHttpsCertsMap = new HashMap();
    private HashMap inactiveImpHttpsCertsMap = new HashMap();
    private HashMap activeRootCACertsMap = new HashMap();
    private HashMap activeHttpsRootCACertsMap = new HashMap();
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private MessageHandler mh = new MessageHandler("config");

    public ConfigurationInfo() {
        if (theUserPropertiesFile == null) {
            theUserPropertiesFile = new File(UserProfile.getPropertyFile());
            new File(theUserPropertiesFile.getParent()).mkdirs();
        }
        this.reset();
    }

    public void setJavaEnabled(boolean bl) {
        this.javapluginEnabled = bl;
        this.firePropertyChange();
    }

    public boolean isJavaEnabled() {
        return this.javapluginEnabled;
    }

    public void setConsoleEnabled(String string) {
        this.showConsole = string;
        this.firePropertyChange();
    }

    public String isConsoleEnabled() {
        return this.showConsole;
    }

    public void setShowException(boolean bl) {
        this.showException = bl;
        this.firePropertyChange();
    }

    public boolean isShowExceptionEnabled() {
        return this.showException;
    }

    public void setDebugEnabled(boolean bl) {
        this.debugMode = bl;
        this.firePropertyChange();
    }

    public boolean isDebugEnabled() {
        return this.debugMode;
    }

    public void setDebugPort(String string) {
        this.debugPort = string;
        this.firePropertyChange();
    }

    public String getDebugPort() {
        return this.debugPort;
    }

    public void setInstalledJREList(Vector vector) {
        this.installedJREs = new String[vector.size() / 2][2];
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.installedJREs[n][0] = (String)enumeration.nextElement();
            this.installedJREs[n][1] = (String)enumeration.nextElement();
            ++n;
        }
    }

    public String[][] getInstalledJREList() {
        return this.installedJREs;
    }

    public void setInstalledJDKList(Vector vector) {
        this.installedJDKs = new String[vector.size() / 2][2];
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.installedJDKs[n][0] = (String)enumeration.nextElement();
            this.installedJDKs[n][1] = (String)enumeration.nextElement();
            ++n;
        }
    }

    public String[][] getInstalledJDKList() {
        return this.installedJDKs;
    }

    public void setJavaRuntimeVersion(String string) {
        if (this.javaVersion == string) {
            return;
        }
        this.javaVersion = string;
        this.firePropertyChange();
    }

    public String getJavaRuntimeVersion() {
        return this.javaVersion;
    }

    public void setJavaRuntimeType(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("Default")) {
                this.javaRuntimeType = "Default";
                this.javaRuntimePath = null;
            } else if (string.equalsIgnoreCase("JDK")) {
                this.javaRuntimeType = "JDK";
                this.javaRuntimePath = null;
            } else if (string.equalsIgnoreCase("JRE")) {
                this.javaRuntimeType = "JRE";
                this.javaRuntimePath = null;
            } else {
                this.javaRuntimeType = "Other";
                this.javaRuntimePath = string;
            }
            this.firePropertyChange();
        }
    }

    public String getJavaRuntimeType() {
        if (this.javaRuntimeType != null && this.javaRuntimeType.equalsIgnoreCase("Other")) {
            return this.javaRuntimePath;
        }
        return this.javaRuntimeType;
    }

    public boolean isIExplorerDefault() {
        return this.iexplorerDefault;
    }

    public void setIExplorerDefault(boolean bl) {
        this.iexplorerDefault = bl;
        this.firePropertyChange();
    }

    public boolean isNetscape6Default() {
        return this.netscape6Default;
    }

    public void setNetscape6Default(boolean bl) {
        this.netscape6Default = bl;
        this.firePropertyChange();
    }

    public boolean useDefaultProxy() {
        return this.useDefaultProxy;
    }

    public void setDefaultProxySettings(boolean bl) {
        this.useDefaultProxy = bl;
        this.firePropertyChange();
    }

    public void setProxySettingsString(String string) {
        this.proxySettings = string;
        this.firePropertyChange();
    }

    public String getProxyByPass() {
        return this.proxyByPass;
    }

    public void setProxyByPass(String string) {
        this.proxyByPass = string;
        this.firePropertyChange();
    }

    public String getAutoProxyURL() {
        return this.autoProxyURL;
    }

    public void setAutoProxyURL(String string) {
        this.autoProxyURL = string;
        this.firePropertyChange();
    }

    public String getProxySettingsString() {
        return this.proxySettings;
    }

    public void setJavaParms(String string) {
        this.javaParms = string;
        this.firePropertyChange();
    }

    public String getJavaParms() {
        return this.javaParms;
    }

    public Collection getCertificateAliases() {
        return this.activeCertsMap.keySet();
    }

    public Collection getHttpsCertificateAliases() {
        return this.activeHttpsCertsMap.keySet();
    }

    public Collection getRootCACertificateAliases() {
        return this.activeRootCACertsMap.keySet();
    }

    public Collection getHttpsRootCACertAliases() {
        return this.activeHttpsRootCACertsMap.keySet();
    }

    public Certificate getCertificate(String string) {
        try {
            PluginCertificateStore pluginCertificateStore = new PluginCertificateStore();
            pluginCertificateStore.load();
            Iterator iterator = pluginCertificateStore.iterator();
            while (iterator.hasNext()) {
                X509Certificate x509Certificate = (X509Certificate)iterator.next();
                String string2 = this.extractAliasName(x509Certificate);
                if (!string2.equals(string)) continue;
                return x509Certificate;
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
        return null;
    }

    public Certificate getHttpsCertificate(String string) {
        try {
            PluginHttpsCertStore pluginHttpsCertStore = new PluginHttpsCertStore();
            pluginHttpsCertStore.load();
            Iterator iterator = pluginHttpsCertStore.iterator();
            while (iterator.hasNext()) {
                X509Certificate x509Certificate = (X509Certificate)iterator.next();
                String string2 = this.extractAliasName(x509Certificate);
                if (!string2.equals(string)) continue;
                return x509Certificate;
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
        return null;
    }

    public Certificate getRootCACertificate(String string) {
        try {
            RootCACertificateStore rootCACertificateStore = new RootCACertificateStore();
            rootCACertificateStore.load();
            Iterator iterator = rootCACertificateStore.iterator();
            while (iterator.hasNext()) {
                X509Certificate x509Certificate = (X509Certificate)iterator.next();
                String string2 = this.extractAliasName(x509Certificate);
                if (!string2.equals(string)) continue;
                return x509Certificate;
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
        return null;
    }

    public Certificate getHttpsRootCACertificate(String string) {
        try {
            HttpsRootCACertStore httpsRootCACertStore = new HttpsRootCACertStore();
            httpsRootCACertStore.load();
            Iterator iterator = httpsRootCACertStore.iterator();
            while (iterator.hasNext()) {
                X509Certificate x509Certificate = (X509Certificate)iterator.next();
                String string2 = this.extractAliasName(x509Certificate);
                if (!string2.equals(string)) continue;
                return x509Certificate;
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
        return null;
    }

    public void deactivateCertificate(String string) {
        Object v = this.activeCertsMap.remove(string);
        this.inactiveCertsMap.put(string, v);
        this.firePropertyChange();
    }

    public void deactivateImpCertificate(X509Certificate x509Certificate) {
        String string = this.extractAliasName(x509Certificate);
        this.activeCertsMap.put(string, x509Certificate);
        this.inactiveImpCertsMap.put(string, x509Certificate);
        this.firePropertyChange();
    }

    public X509Certificate getImpCertificate(String string) {
        Object v = this.inactiveImpCertsMap.get(string);
        return (X509Certificate)v;
    }

    public void deactivateHttpsCertificate(String string) {
        Object v = this.activeHttpsCertsMap.remove(string);
        this.inactiveHttpsCertsMap.put(string, v);
        this.firePropertyChange();
    }

    public void deactivateImpHttpsCertificate(X509Certificate x509Certificate) {
        String string = this.extractAliasName(x509Certificate);
        this.activeHttpsCertsMap.put(string, x509Certificate);
        this.inactiveImpHttpsCertsMap.put(string, x509Certificate);
        this.firePropertyChange();
    }

    public X509Certificate getImpHttpsCertificate(String string) {
        Object v = this.inactiveImpHttpsCertsMap.get(string);
        return (X509Certificate)v;
    }

    private String extractAliasName(X509Certificate x509Certificate) {
        Object object;
        String string = "Unknown subject";
        String string2 = "Unknown Issuer";
        int n = 0;
        int n2 = 0;
        try {
            object = x509Certificate.getSubjectDN();
            Principal principal = x509Certificate.getIssuerDN();
            String string3 = object.getName();
            String string4 = principal.getName();
            n = string3.indexOf("CN=");
            if (n < 0) {
                string = "Unknown subject";
            } else {
                n2 = string3.charAt(n += 3) == '\"' ? string3.indexOf(34, ++n) : string3.indexOf(44, n);
                string = n2 < 0 ? string3.substring(n) : string3.substring(n, n2);
            }
            n = string4.indexOf("CN=");
            n2 = 0;
            if (n < 0) {
                string = "Unknown issuer";
            } else {
                string2 = (n2 = string4.charAt(n += 3) == '\"' ? string4.indexOf(34, ++n) : string4.indexOf(44, n)) < 0 ? string4.substring(n) : string4.substring(n, n2);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
        object = string + "(" + string2 + ")";
        return object;
    }

    public void applyChanges() throws IOException {
        Object object;
        Object object2;
        this.props.put("javaplugin.console", this.showConsole);
        this.props.put("javaplugin.exception", this.showException ? "true" : "false");
        this.props.put("javaplugin.enabled", this.javapluginEnabled ? "true" : "false");
        if (this.debugMode) {
            this.props.put("javaplugin.debug.mode", "true");
            this.props.put("javaplugin.debug.port", this.debugPort);
        } else {
            this.props.put("javaplugin.debug.mode", "false");
        }
        if (this.useDefaultProxy) {
            this.props.put("javaplugin.proxy.usebrowsersettings", "true");
        } else {
            this.props.put("javaplugin.proxy.usebrowsersettings", "false");
        }
        if (this.proxySettings != null) {
            this.props.put("javaplugin.proxy.settings", this.proxySettings);
        } else {
            this.props.remove("javaplugin.proxy.settings");
        }
        if (this.proxyByPass != null) {
            this.props.put("javaplugin.proxy.bypass", this.proxyByPass);
        } else {
            this.props.remove("javaplugin.proxy.bypass");
        }
        try {
            if (this.autoProxyURL != null && !this.autoProxyURL.trim().equals("")) {
                object2 = new URL(this.autoProxyURL);
                this.props.put("javaplugin.proxy.auto.url", this.autoProxyURL);
            }
        }
        catch (MalformedURLException malformedURLException) {
            DialogFactory.showExceptionDialog(malformedURLException);
            this.props.remove("javaplugin.proxy.auto.url");
            this.autoProxyURL = null;
        }
        if (this.javaRuntimeType != null) {
            this.props.put("javaplugin.jre.type", this.javaRuntimeType);
        } else {
            this.javaRuntimeType = "Default";
            this.props.put("javaplugin.jre.type", "Default");
        }
        object2 = null;
        if (this.javaVersion != null && this.javaVersion.length() > 0) {
            object = null;
            if (this.javaRuntimeType.equalsIgnoreCase("JRE")) {
                object = this.getInstalledJREList();
            }
            if (this.javaRuntimeType.equalsIgnoreCase("JDK")) {
                object = this.getInstalledJDKList();
            }
            if (object != null) {
                int n = 0;
                while (n < ((String[][])object).length) {
                    if (object[n][0].equalsIgnoreCase(this.javaVersion)) {
                        object2 = object[n][1];
                    }
                    ++n;
                }
            }
        }
        if (this.javaRuntimeType.equalsIgnoreCase("Other") && this.javaRuntimePath != null && !this.javaRuntimePath.trim().equals("")) {
            object2 = this.javaRuntimePath;
        }
        if (object2 != null) {
            this.props.put("javaplugin.jre.path", object2);
        } else {
            this.props.put("javaplugin.jre.type", "Default");
            this.props.put("javaplugin.jre.path", "Default");
        }
        if (this.javaVersion != null && this.javaVersion.length() > 0) {
            this.props.put("javaplugin.jre.version", this.javaVersion);
        } else {
            this.props.remove("javaplugin.jre.version");
        }
        if (this.javaParms != null && this.javaParms.length() > 0) {
            this.props.put("javaplugin.jre.params", this.javaParms);
        } else {
            this.props.remove("javaplugin.jre.params");
        }
        if (!this.cacheEnabled) {
            this.props.put("javaplugin.cache.disabled", "true");
        } else {
            this.props.remove("javaplugin.cache.disabled");
        }
        object = new File(this.cacheLocation);
        if (((File)object).equals(this.defaultCacheLocation)) {
            this.props.remove("javaplugin.cache.directory");
        } else {
            this.props.put("javaplugin.cache.directory", this.cacheLocation);
        }
        if (!this.cacheSize.equals("50m")) {
            this.props.put("javaplugin.cache.size", this.cacheSize);
        } else {
            this.props.remove("javaplugin.cache.size");
        }
        if (this.JARCacheCompression != 0) {
            this.props.put("javaplugin.cache.compression", String.valueOf(this.JARCacheCompression));
        } else {
            this.props.remove("javaplugin.cache.compression");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(theUserPropertiesFile);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        PrintWriter printWriter = new PrintWriter(bufferedOutputStream);
        printWriter.println(this.mh.getMessage("property_file_header"));
        printWriter.flush();
        this.props.store(bufferedOutputStream, "");
        bufferedOutputStream.close();
        fileOutputStream.close();
        try {
            PluginCertificateStore pluginCertificateStore = new PluginCertificateStore();
            PluginHttpsCertStore pluginHttpsCertStore = new PluginHttpsCertStore();
            pluginCertificateStore.load();
            pluginHttpsCertStore.load();
            Collection collection = this.inactiveCertsMap.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                pluginCertificateStore.remove((Certificate)iterator.next());
            }
            Collection collection2 = this.inactiveImpCertsMap.values();
            Iterator iterator2 = collection2.iterator();
            while (iterator2.hasNext()) {
                pluginCertificateStore.add((Certificate)iterator2.next());
            }
            Collection collection3 = this.inactiveHttpsCertsMap.values();
            Iterator iterator3 = collection3.iterator();
            while (iterator3.hasNext()) {
                pluginHttpsCertStore.remove((Certificate)iterator3.next());
            }
            Collection collection4 = this.inactiveImpHttpsCertsMap.values();
            Iterator iterator4 = collection4.iterator();
            while (iterator4.hasNext()) {
                pluginHttpsCertStore.add((Certificate)iterator4.next());
            }
            pluginCertificateStore.save();
            pluginHttpsCertStore.save();
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
        this.inactiveCertsMap.clear();
        this.inactiveImpCertsMap.clear();
        this.inactiveHttpsCertsMap.clear();
        this.inactiveImpHttpsCertsMap.clear();
    }

    public void reset() {
        Object object;
        Object object2;
        Object object3;
        this.firePropertyChange();
        this.props = new Properties();
        try {
            object3 = new FileInputStream(theUserPropertiesFile);
            object2 = new BufferedInputStream((InputStream)object3);
            this.props.load((InputStream)object2);
            ((BufferedInputStream)object2).close();
            ((FileInputStream)object3).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        object3 = this.props.getProperty("javaplugin.console");
        this.showConsole = object3 != null ? object3 : "hide";
        object3 = this.props.getProperty("javaplugin.exception");
        this.showException = object3 != null && !((String)object3).equals("false");
        object3 = this.props.getProperty("javaplugin.enabled");
        this.javapluginEnabled = object3 == null || ((String)object3).equals("true");
        object3 = this.props.getProperty("javaplugin.debug.mode");
        this.debugMode = object3 != null && ((String)object3).equals("true");
        this.debugPort = this.props.getProperty("javaplugin.debug.port");
        if (this.debugPort == null) {
            this.debugPort = "2502";
        }
        this.useDefaultProxy = (object3 = this.props.getProperty("javaplugin.proxy.usebrowsersettings")) == null || ((String)object3).equals("true");
        this.proxySettings = this.props.getProperty("javaplugin.proxy.settings");
        this.proxyByPass = this.props.getProperty("javaplugin.proxy.bypass");
        try {
            object2 = this.props.getProperty("javaplugin.proxy.auto.url");
            if (object2 != null && !((String)object2).trim().equals("")) {
                object = new URL((String)object2);
                this.autoProxyURL = object2;
            }
        }
        catch (MalformedURLException malformedURLException) {
            DialogFactory.showExceptionDialog(malformedURLException);
            this.autoProxyURL = null;
        }
        this.javaRuntimePath = this.props.getProperty("javaplugin.jre.path");
        this.javaRuntimeType = this.props.getProperty("javaplugin.jre.type");
        this.javaRuntimeType = this.javaRuntimeType == null ? (this.javaRuntimePath != null && !this.javaRuntimePath.trim().equals("") ? "Other" : "Default") : (this.javaRuntimeType.equalsIgnoreCase("JRE") ? "JRE" : (this.javaRuntimeType.equalsIgnoreCase("JDK") ? "JDK" : (this.javaRuntimeType.equalsIgnoreCase("Other") ? (this.javaRuntimePath != null && !this.javaRuntimePath.trim().equals("") ? "Other" : "Default") : "Default")));
        if (this.javaRuntimeType == null) {
            this.javaRuntimeType = "Default";
        }
        this.javaVersion = this.props.getProperty("javaplugin.jre.version");
        this.javaParms = this.props.getProperty("javaplugin.jre.params");
        object3 = this.props.getProperty("javaplugin.cache.disabled");
        this.cacheEnabled = object3 == null || !((String)object3).equalsIgnoreCase("true");
        this.defaultCacheLocation = new File(UserProfile.getCommonCacheDir());
        this.cacheLocation = this.props.getProperty("javaplugin.cache.directory");
        if (this.cacheLocation == null) {
            this.cacheLocation = this.defaultCacheLocation.getPath();
        }
        this.cacheSize = this.props.getProperty("javaplugin.cache.size", "50m");
        object3 = this.props.getProperty("javaplugin.cache.compression");
        if (object3 != null) {
            try {
                this.JARCacheCompression = Integer.valueOf((String)object3);
            }
            catch (NumberFormatException numberFormatException) {
                this.JARCacheCompression = 0;
            }
        } else {
            this.JARCacheCompression = 0;
        }
        this.activeCertsMap.clear();
        this.inactiveCertsMap.clear();
        this.inactiveImpCertsMap.clear();
        this.activeHttpsCertsMap.clear();
        this.inactiveHttpsCertsMap.clear();
        this.inactiveImpHttpsCertsMap.clear();
        this.activeRootCACertsMap.clear();
        this.activeHttpsRootCACertsMap.clear();
        try {
            String string;
            X509Certificate x509Certificate;
            object2 = new PluginCertificateStore();
            object = new PluginHttpsCertStore();
            RootCACertificateStore rootCACertificateStore = new RootCACertificateStore();
            HttpsRootCACertStore httpsRootCACertStore = new HttpsRootCACertStore();
            object2.load();
            object.load();
            rootCACertificateStore.load();
            httpsRootCACertStore.load();
            Iterator iterator = object2.iterator();
            Iterator iterator2 = object.iterator();
            Iterator iterator3 = rootCACertificateStore.iterator();
            Iterator iterator4 = httpsRootCACertStore.iterator();
            while (iterator.hasNext()) {
                x509Certificate = (X509Certificate)iterator.next();
                string = this.extractAliasName(x509Certificate);
                this.activeCertsMap.put(string, x509Certificate);
            }
            while (iterator2.hasNext()) {
                x509Certificate = (X509Certificate)iterator2.next();
                string = this.extractAliasName(x509Certificate);
                this.activeHttpsCertsMap.put(string, x509Certificate);
            }
            while (iterator3.hasNext()) {
                x509Certificate = (X509Certificate)iterator3.next();
                string = this.extractAliasName(x509Certificate);
                this.activeRootCACertsMap.put(string, x509Certificate);
            }
            while (iterator4.hasNext()) {
                x509Certificate = (X509Certificate)iterator4.next();
                string = this.extractAliasName(x509Certificate);
                this.activeHttpsRootCACertsMap.put(string, x509Certificate);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
    }

    boolean getCacheEnabled() {
        return this.cacheEnabled;
    }

    void setCacheEnabled(boolean bl) {
        this.cacheEnabled = bl;
        this.firePropertyChange();
    }

    String getCacheLocation() {
        return this.cacheLocation;
    }

    void setCacheLocation(String string) {
        this.cacheLocation = string;
        this.firePropertyChange();
    }

    String getCacheSize() {
        return this.cacheSize;
    }

    void setCacheSize(String string) {
        this.cacheSize = string;
        this.firePropertyChange();
    }

    int getJARCacheCompression() {
        return this.JARCacheCompression;
    }

    void setJARCacheCompression(int n) {
        this.JARCacheCompression = n;
        this.firePropertyChange();
    }

    protected void firePropertyChange() {
        this.pcs.firePropertyChange(null, null, null);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void setShowBrowserPanel(boolean bl) {
        this.showBrowserPanel = bl;
    }

    public boolean isShowBrowserPanel() {
        return this.showBrowserPanel;
    }
}

