/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.security;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.security.CertificateDialog;
import sun.plugin.usability.DialogFactory;
import sun.plugin.usability.Trace;

class TrustDeciderDialog
implements ActionListener {
    public static final int TrustOption_GrantThisSession = 0;
    public static final int TrustOption_Deny = 1;
    public static final int TrustOption_GrantAlways = 2;
    private Certificate[] certs = null;
    private boolean rootCANotValid = false;
    private boolean timeNotValid = false;
    private boolean httpsDialog = false;
    CertificateDialog dialog;

    TrustDeciderDialog(Certificate[] certificateArray, boolean bl, boolean bl2) {
        this.certs = certificateArray;
        this.rootCANotValid = bl;
        this.timeNotValid = bl2;
        this.dialog = new CertificateDialog(certificateArray, 0);
    }

    int DoModal() {
        int n = -1;
        if (this.certs[0] instanceof X509Certificate && this.certs[this.certs.length - 1] instanceof X509Certificate) {
            Object[] objectArray;
            X509Certificate x509Certificate = (X509Certificate)this.certs[0];
            X509Certificate x509Certificate2 = (X509Certificate)this.certs[this.certs.length - 1];
            Principal principal = x509Certificate.getSubjectDN();
            Principal principal2 = x509Certificate2.getIssuerDN();
            String string = principal.getName();
            String string2 = null;
            int n2 = string.indexOf("CN=");
            int n3 = 0;
            if (n2 < 0) {
                string2 = TrustDeciderDialog.getMessage("security_dialog.unknown.subject");
            } else {
                try {
                    n3 = string.charAt(n2 += 3) == '\"' ? string.indexOf(34, ++n2) : string.indexOf(44, n2);
                    string2 = n3 < 0 ? string.substring(n2) : string.substring(n2, n3);
                }
                catch (Throwable throwable) {
                    string2 = TrustDeciderDialog.getMessage("security_dialog.unknown.subject");
                }
            }
            String string3 = principal2.getName();
            String string4 = null;
            n2 = string3.indexOf("O=");
            n3 = 0;
            if (n2 < 0) {
                string4 = TrustDeciderDialog.getMessage("security_dialog.unknown.issuer");
            } else {
                try {
                    n3 = string3.charAt(n2 += 2) == '\"' ? string3.indexOf(34, ++n2) : string3.indexOf(44, n2);
                    string4 = n3 < 0 ? string3.substring(n2) : string3.substring(n2, n3);
                }
                catch (Throwable throwable) {
                    string4 = TrustDeciderDialog.getMessage("security_dialog.unknown.issuer");
                }
            }
            Object[] objectArray2 = new Object[6];
            MessageFormat messageFormat = null;
            messageFormat = this.getHttpsDialog() ? new MessageFormat(TrustDeciderDialog.getMessage("security_dialog_https.text0")) : new MessageFormat(TrustDeciderDialog.getMessage("security_dialog.text0"));
            Object[] objectArray3 = new Object[]{string2, string4};
            objectArray2[0] = messageFormat.format(objectArray3);
            objectArray2[1] = "";
            if (this.rootCANotValid) {
                objectArray = new JLabel(TrustDeciderDialog.getMessage("security_dialog.rootCANotValid"));
                objectArray.setIcon(this.getWarningIcon());
                objectArray2[2] = objectArray;
            } else {
                objectArray = new JLabel(TrustDeciderDialog.getMessage("security_dialog.rootCAValid"));
                objectArray.setIcon(this.getInfoIcon());
                objectArray2[2] = objectArray;
            }
            objectArray2[3] = "";
            if (this.timeNotValid) {
                objectArray = new JLabel(TrustDeciderDialog.getMessage("security_dialog.timeNotValid"));
                objectArray.setIcon(this.getWarningIcon());
                objectArray2[4] = objectArray;
            } else {
                objectArray = new JLabel(TrustDeciderDialog.getMessage("security_dialog.timeValid"));
                objectArray.setIcon(this.getInfoIcon());
                objectArray2[4] = objectArray;
            }
            messageFormat = new MessageFormat(TrustDeciderDialog.getMessage("security_dialog.text1"));
            objectArray = new Object[]{string2, string2};
            objectArray2[5] = messageFormat.format(objectArray);
            JButton jButton = new JButton(TrustDeciderDialog.getMessage("security_dialog.buttonViewCert"));
            jButton.setMnemonic(86);
            jButton.addActionListener(this);
            Object[] objectArray4 = new Object[]{TrustDeciderDialog.getMessage("security_dialog.buttonYes"), TrustDeciderDialog.getMessage("security_dialog.buttonNo"), TrustDeciderDialog.getMessage("security_dialog.buttonAlways"), jButton};
            if (!Trace.isAutomationEnabled()) {
                n = DialogFactory.showOptionDialog(objectArray2, TrustDeciderDialog.getMessage("security_dialog.caption"), objectArray4, objectArray4[0]);
            } else {
                Trace.securityPrintln(ResourceHandler.getMessage("trustdecider.automation.trustcert"), 2);
                n = 0;
            }
        }
        return n;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.dialog.DoModal();
    }

    private static String getMessage(String string) {
        return ResourceHandler.getMessage(string);
    }

    private Icon getWarningIcon() {
        Icon icon = null;
        try {
            icon = (Icon)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    URL uRL = ClassLoader.getSystemResource("javax/swing/plaf/metal/icons/Warn.gif");
                    return new ImageIcon(uRL);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return icon;
    }

    private Icon getInfoIcon() {
        ImageIcon imageIcon = null;
        try {
            URL uRL = ClassLoader.getSystemResource("javax/swing/plaf/metal/icons/Inform.gif");
            imageIcon = new ImageIcon(uRL);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return imageIcon;
    }

    public boolean getHttpsDialog() {
        return this.httpsDialog;
    }

    public void setHttpsDialog(boolean bl) {
        this.httpsDialog = bl;
    }
}

