package Gimp::Config;

=cut

=head1 NAME

  Gimp::Config - config options found during configure time.

=head1 DESCRIPTION

The Gimp::Config module creates a tied hash %Gimp::Config which contains
all the definitions the configure script and perl deduced from the system
configuration at configure time. You can access these values just like you
access any other values, i.e.  C<$Gimp::Config{KEY}>. Some important keys are:

  IN_GIMP	=> true when gimp-perl was part of the Gimp distribution.
  GIMP		=> the path of the gimp executable
  prefix	=> the installation prefix
  libdir	=> the gimp systemwide libdir
  bindir	=> paths where gimp binaries are installed
  gimpplugindir	=> the gimp plug-in directory (without the /plug-ins-suffix)

=head1 SEE ALSO

L<Gimp>.

=cut

sub TIEHASH {
   my $pkg = shift;
   my $self;

   bless \$self, $pkg;
}

sub FETCH {
   $cfg{$_[1]};
}

tie %Gimp::Config, 'Gimp::Config';

%cfg = (
   IN_GIMP              => q[1],
   libdir               => q[/usr/lib],
   gimpplugindir        => q[/usr/lib/gimp/1.2],
   INSTALL_PROGRAM      => q[/usr/bin/ginstall -c],
   _PERL                => q[/usr/bin/perl],
   _CPPFLAGS            => q[ -DGTK_DISABLE_COMPAT_H],
   MSGMERGE             => q[@MSGMERGE@],
   _LDFLAGS             => q[],
   GIMP                 => q[/usr/bin/gimp],
   LIBS                 => q[],
   INC1                 => q[-I/tmp/gimp-1.2.3/plug-ins/perl],
   _GIMP_LIBS           => q[-L/tmp/gimp-1.2.3/plug-ins/perl/../../libgimp/.libs -L/tmp/gimp-1.2.3/plug-ins/perl/../../libgimp -lgimp -L/usr/lib -lglib  -lgimpui],
   _CFLAGS              => q[-O2 ],
   DEFINE1              => q[ -Ddatadir="\\"/usr/share\\""],
   GIMPTOOL             => q[../../gimptool-1.2],
   pdl_inc              => q[],
   datadir              => q[/usr/share],
   _GIMP_INC_NOUI       => q[-I/tmp/gimp-1.2.3/plug-ins/perl/../.. -I/usr/include/glib-1.2 -I/usr/lib/glib/include -I/usr/include/gtk-1.2 -I/usr/include/glib-1.2 -I/usr/lib/glib/include -I/usr/X11R6/include],
   INTLLIBS             => q[],
   exec_prefix          => q[/usr],
   bindir               => q[/usr/bin],
   pdl_typemaps         => q[],
   _EXTENSIVE_TESTS     => q[0],
   _GIMP_LIBS_NOUI      => q[-L/tmp/gimp-1.2.3/plug-ins/perl/../../libgimp/.libs -L/tmp/gimp-1.2.3/plug-ins/perl/../../libgimp -lgimp -L/usr/lib -lglib ],
   MSGFMT               => q[/usr/bin/msgfmt],
   _GIMP_INC            => q[-I/tmp/gimp-1.2.3/plug-ins/perl/../.. -I/usr/include/glib-1.2 -I/usr/lib/glib/include -I/usr/include/gtk-1.2 -I/usr/include/glib-1.2 -I/usr/lib/glib/include -I/usr/X11R6/include],
   GIMP_PREFIX          => q[/usr],
   INSTALL              => q[/usr/bin/ginstall -c],
   GLIB_LIBS            => q[-L/usr/lib -lglib],
   GLIB_CFLAGS          => q[-I/usr/include/glib-1.2 -I/usr/lib/glib/include],
   prefix               => q[/usr],
);

1;
