/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Conditional;
import java.awt.EventDispatchThread;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.peer.DialogPeer;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;

public class Dialog
extends Window {
    boolean resizable = true;
    boolean modal;
    String title;
    private transient boolean keepBlocking = false;
    private static final String base = "dialog";
    private static int nameCounter;
    private static final long serialVersionUID = 5920926903803293709L;

    public Dialog(Frame frame) {
        this(frame, "", false);
    }

    public Dialog(Frame frame, boolean bl) {
        this(frame, "", bl);
    }

    public Dialog(Frame frame, String string) {
        this(frame, string, false);
    }

    public Dialog(Frame frame, String string, boolean bl) {
        super(frame);
        this.title = string;
        this.modal = bl;
    }

    public Dialog(Dialog dialog) {
        this(dialog, "", false);
    }

    public Dialog(Dialog dialog, String string) {
        this(dialog, string, false);
    }

    public Dialog(Dialog dialog, String string, boolean bl) {
        super(dialog);
        this.title = string;
        this.modal = bl;
    }

    String constructComponentName() {
        Class clazz = this.getClass();
        synchronized (clazz) {
            String string = base + nameCounter++;
            return string;
        }
    }

    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.parent != null && this.parent.getPeer() == null) {
                this.parent.addNotify();
            }
            if (this.peer == null) {
                this.peer = this.getToolkit().createDialog(this);
            }
            super.addNotify();
        }
    }

    public boolean isModal() {
        return this.modal;
    }

    public void setModal(boolean bl) {
        this.modal = bl;
    }

    public String getTitle() {
        return this.title;
    }

    public synchronized void setTitle(String string) {
        this.title = string;
        DialogPeer dialogPeer = (DialogPeer)this.peer;
        if (dialogPeer != null) {
            dialogPeer.setTitle(string);
        }
    }

    private boolean conditionalShow() {
        boolean bl;
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.addNotify();
            }
            this.validate();
            if (this.visible) {
                this.toFront();
                bl = false;
            } else {
                bl = true;
                this.visible = true;
                this.peer.show();
                this.createHierarchyEvents(1400, this, this.parent, 4L);
            }
            if (bl && (this.componentListener != null || (this.eventMask & 1L) != 0L)) {
                ComponentEvent componentEvent = new ComponentEvent(this, 102);
                Toolkit.getEventQueue().postEvent(componentEvent);
            }
        }
        if (bl && (this.state & 1) == 0) {
            this.postWindowEvent(200);
            this.state |= 1;
        }
        return bl;
    }

    public void show() {
        if (!this.isModal()) {
            this.conditionalShow();
        } else {
            this.keepBlocking = true;
            if (this.conditionalShow()) {
                Toolkit.getEventQueue();
                if (EventQueue.isDispatchThread()) {
                    EventDispatchThread eventDispatchThread = (EventDispatchThread)Thread.currentThread();
                    eventDispatchThread.pumpEventsForHierarchy(new Conditional(){

                        public boolean evaluate() {
                            return Dialog.this.keepBlocking && Dialog.this.windowClosingException == null;
                        }
                    }, this);
                } else {
                    Object object = this.getTreeLock();
                    synchronized (object) {
                        while (this.keepBlocking && this.windowClosingException == null) {
                            try {
                                this.getTreeLock().wait();
                            }
                            catch (InterruptedException interruptedException) {
                                break;
                            }
                        }
                    }
                }
                if (this.windowClosingException != null) {
                    this.windowClosingException.fillInStackTrace();
                    throw this.windowClosingException;
                }
            }
        }
    }

    void interruptBlocking() {
        if (this.modal) {
            this.disposeImpl();
        } else if (this.windowClosingException != null) {
            this.windowClosingException.fillInStackTrace();
            this.windowClosingException.printStackTrace();
            this.windowClosingException = null;
        }
    }

    private void hideAndDisposeHandler() {
        if (this.keepBlocking) {
            Object object = this.getTreeLock();
            synchronized (object) {
                this.keepBlocking = false;
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                    }
                });
                this.getTreeLock().notifyAll();
            }
        }
    }

    public void hide() {
        super.hide();
        this.hideAndDisposeHandler();
    }

    public void dispose() {
        this.disposeImpl();
    }

    private void disposeImpl() {
        super.dispose();
        this.hideAndDisposeHandler();
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setResizable(boolean bl) {
        boolean bl2 = false;
        Dialog dialog = this;
        synchronized (dialog) {
            this.resizable = bl;
            DialogPeer dialogPeer = (DialogPeer)this.peer;
            if (dialogPeer != null) {
                dialogPeer.setResizable(bl);
                bl2 = true;
            }
        }
        if (bl2 && this.valid) {
            this.invalidate();
        }
    }

    protected String paramString() {
        String string = super.paramString() + (this.modal ? ",modal" : ",modeless");
        if (this.title != null) {
            string = string + ",title=" + this.title;
        }
        return string;
    }

    private static native void initIDs();

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTDialog();
        }
        return this.accessibleContext;
    }

    static {
        Toolkit.loadLibraries();
        Dialog.initIDs();
        nameCounter = 0;
    }

    protected class AccessibleAWTDialog
    extends Window.AccessibleAWTWindow {
        protected AccessibleAWTDialog() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.DIALOG;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (Dialog.this.getFocusOwner() != null) {
                accessibleStateSet.add(AccessibleState.ACTIVE);
            }
            if (Dialog.this.isModal()) {
                accessibleStateSet.add(AccessibleState.MODAL);
            }
            if (Dialog.this.isResizable()) {
                accessibleStateSet.add(AccessibleState.RESIZABLE);
            }
            return accessibleStateSet;
        }
    }
}

