/****************  Window Management *****************/


function AimSidebarPanelOnWndLoad() {
  enableSignOnButton(false);
	// Read signon prefs. We need to load at least the screen name here,
	// but might as well load the password and autoLogin prefs, too.

	var screenName = aimPrefsManager().GetCharPref("aim.session.screenname", null, true);
	
	dump("ScreenName is " + screenName);

	var password = aimSessionGetPassword(null);
	var autoLogin = aimPrefsManager().GetBoolPref("aim.session.autologin", null, false);
	var firstTime = aimPrefsManager().GetBoolPref("aim.session.firsttime", null, true); // firsttime is a GLOBAL pref
	
	
	dump("setting AIMDocumentPath \n");
        top.AIMDocumentPath=window;

  // If this is the first time the user is launching aim, pop open the wizard.
  // If not, ignore and move on.
  if (firstTime) {
    aimGlobalCmdStartupWizard();
    // Set pref so we don't pop open the wizard again automatically if the user doesn't finish the wizard the first time.
    aimPrefsManager().SetBoolPref("aim.session.firsttime",false, null, true);
  }	

	// Initialize online state
	var state = aimRDFDataSource().GetTarget(aimRDFSession(), aimRDFSessionState(), true);
	if (state == null)
		state = aimRDF().GetLiteral("Register");
      
	OnlineObserver.onAssert(aimRDFDataSource(), aimRDFSession(), aimRDFSessionState(), state);

	// Watch future changes to online state
	aimRDFDataSource().AddObserver(OnlineObserver);
	
	
  //var firstLogin = aimPrefsManager().GetBoolPref("aim.session.appfirstlogin", null,true);
  // Auto login
	//if (screenName && screenName != '' && password && password != '' && autoLogin && firstLogin != false ) {
  if (screenName && screenName != '' && password && password != '' && autoLogin) {
    if (state.EqualsNode(aimRDF().GetLiteral("Offline")))
			aimSessionLogin(screenName, password);
	}
	else
	{
		if (screenName && screenName != '')
		{
			if (!password || password == '')
				document.getElementById('fldPassword').focus();
      else
        enableSignOnButton(true); //ok..we have SN and password. Enable the signon button
		}
		else
			document.getElementById('fldScreenName').focus();
			
	}
	
}


function AimSidebarPanelSetAwayMsgBtn(){
	dump("** aimsidebarpanelsetawaymsgbtn \n")
  var sidebar_file = GetRdfFileUrl("default-messages.rdf", "dm.rdf");  
  var datasource = aimRDF().GetDataSource(sidebar_file);

	menu = window.document.getElementById("btnaway");
	var menudb=menu.database.GetDataSources();
        while   (menudb.hasMoreElements()) {
                var curDS= menudb.getNext();
				curDS=curDS.QueryInterface(Components.interfaces.nsIRDFDataSource);
                menu.database.RemoveDataSource(curDS);
        } 
	menu.database.AddDataSource(datasource);
	menu.builder.rebuild();
}

function AimSidebarPanelOnWndUnload() {

	// Save signon fields if offline. If online, we saved during signon.
	var state = aimRDFDataSource().GetTarget(aimRDFSession(), aimRDFSessionState(), true);
	if (state == null || state.EqualsNode(aimRDF().GetLiteral("Offline")))
		SaveFieldsToPrefs();

	aimRDFDataSource().RemoveObserver(OnlineObserver);
}

function InitFieldsFromPrefs( doSNAndPasswd ) {

dump( "InitFieldsFromPrefs()\n" );

    if (doSNAndPasswd == true) {
		var screenName = aimPrefsManager().GetCharPref("aim.session.screenname", null, true);
		//var password = aimPrefsManager().GetCharPref("aim.session.password", null, false);
		var password = aimSessionGetPassword(null);
		document.getElementById('fldScreenName').value = screenName;
	}
	var savePassword = aimPrefsManager().GetBoolPref("aim.session.storepassword", null, false);
	var autoLogin = aimPrefsManager().GetBoolPref("aim.session.autologin", null, false);

	document.getElementById('chkSavePassword').checked = savePassword;

	if(doSNAndPasswd == true && savePassword)
	    document.getElementById('fldPassword').value = password;
        if (doSNAndPasswd == true && !savePassword)
            document.getElementById('fldPassword').value = '';


	document.getElementById('chkAutoLogin').checked = autoLogin;
	EnableInputs();
}

function SaveFieldsToPrefs() {
dump( "SaveFieldsFromPrefs()\n" );

	var screenName = document.getElementById('fldScreenName').value;
	var password = document.getElementById('fldPassword').value;
	var autoLogin = document.getElementById('chkAutoLogin').checked;
	var savePassword = document.getElementById('chkSavePassword').checked;

  	aimPrefsManager().SetCharPref("aim.session.screenname", screenName, null, true);

	if (savePassword)
		aimSessionSavePassword(password);//prefs.SetCharPref("aim.session.password", password);
	else
		aimSessionSavePassword("");//prefs.SetCharPref("aim.session.password", "");

	aimPrefsManager().SetBoolPref("aim.session.storepassword", savePassword, null, false);
	aimPrefsManager().SetBoolPref("aim.session.autologin", autoLogin, null, false);
}

function EnableInputs() {
  var password = document.getElementById("fldPassword").value;
	var savePassword = document.getElementById("chkSavePassword").checked;

	if (password != "") {
    enableSignOnButton(true);
    document.getElementById("chkSavePassword").disabled = false;
		document.getElementById("chkAutoLogin").disabled = !savePassword;

		// XXX This is what the AIM 3.0 client does. Not sure if we should
		//     change it.
		if (!savePassword)
			document.getElementById("chkAutoLogin").checked = false;
	}
	else {
    enableSignOnButton(false);
		document.getElementById("chkSavePassword").disabled = true;
		document.getElementById("chkAutoLogin").disabled = true;

		// XXX This is what the AIM 3.0 client does. Not sure if we should
		//     change it.
		document.getElementById("chkSavePassword").checked = false;
		document.getElementById("chkAutoLogin").checked = false;
	}
}

/****************  RDF Observing ********************/

var OnlineObserver = new Object();

OnlineObserver.onAssert = function(datasource, source, property, target)
{
	if(source.EqualsNode(aimRDFSession()))
	{
		if(property.EqualsNode(aimRDFSessionState()))
		{
			var state = target.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;

			dump('OnlineState: ' + state + '\n');

      // flip to the appropriate panel in the deck
      var deck = document.getElementById("PanelDeck");
      var newIndex = deck.getAttribute("index");
      switch (state) {
        case "Register":
          newIndex = 4; // register panel
          break;
        case "Offline":
          newIndex = 0; // sign-on panel
          break;
        case "Online":
          newIndex = 3; // online panel
          break;
        case "OnlineAway":
          newIndex = 2; // away panel
          break;
        case "Connecting":
        case "Requesting":
        case "Negotiating":
        case "Validating":
        case "Transferring":
        case "Starting":
          newIndex = 1;
      }
      
      deck.setAttribute("index", newIndex);
      
			if (state != "Offline" && state != "Online" && state != "Register" && state != "OnlineAway")
			{
        var str = aimString("btnSignOnProgress." + state);
				document.getElementById("btnSignOnProgress").setAttribute("value", str);
				var theProgressBar = document.getElementById("spconnectingprogressbar001");
				theProgressBar.setAttribute("value",parseInt(theProgressBar.getAttribute("value"))+15)
			}

			if(state == "Online" || state == "OnlineAway")
			{
					aimMigrateBuddyList( aimSessionCurrentScreenName() );
			}

			// If returning to offline state, reinitialize the signon screen fields,
			// which appear to be cleared out when they are hidden. We also do this
			// when the form is loaded.
			if (state == "Offline") {
				progress = window.document.getElementById("spconnectingprogressbar001");
          			if ( progress && progress != undefined )
          				progress.setAttribute("value", "0");
        InitFieldsFromPrefs(true);
			}
			if (state == "Online") { 
			    AimSidebarPanelSetAwayMsgBtn();    
          UpdateUserWarning(null);
          }
		}
   
   if(property.EqualsNode(aimRDFWarningStatus())) {
      var st = target.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
      UpdateUserWarning(st);
   }
    
	}
};

OnlineObserver.onUnassert = function(datasource, source, property, target)
{
	// XXX Do we need to remove the attribute here ???
};
	
OnlineObserver.onChange = function(datasource, source, property, oldTarget, newTarget)
{
	OnlineObserver.onAssert(datasource, source, property, newTarget);
};
	
OnlineObserver.onMove = function(datasource, oldSource, newSource, property, target)
{
	OnlineObserver.onAssert(datasource, newSource, property, target);
};

OnlineObserver.beginUpdateBatch = function(datasource)
{
};

OnlineObserver.endUpdateBatch = function(datasource)
{
};

/**************** Command Handlers ******************/

function cmdPanelSignOn() 
{
	SaveFieldsToPrefs();

	var screenName = document.getElementById('fldScreenName').value;
	var password = document.getElementById('fldPassword').value;

	aimSessionLogin(screenName, password);
  	
}

function cmdPasswordKeyup(event) {
	// Enabled state of savePassword checkbox depends on
	// empty/non-empty password field
  EnableInputs();
  InitFieldsFromPrefs(false);
  var password = document.getElementById('fldPassword').value;
  if (password.length > 0)
    enableSignOnButton(true);
  else
    enableSignOnButton(false);
	if (event.keyCode == 13 && password.length > 0)
		cmdPanelSignOn();
}

function cmdScreenName(event) {
	var screenName = document.getElementById('fldScreenName').value;
  dump("cmdScreenName" + screenName + "\n");

	/* for (i in event) {
		dump(i); dump ("->");
		var j;
		for (j in i) {
			dump (j); dump (" ") ;  
		} 
		dump("\t");
	}
	//dump("which is " + event.which); */

	try {
	    var password = "";
      try {
		password = aimSessionGetPassword(screenName);
	    } catch (e) {}
		document.getElementById('fldPassword').value = password; 
		document.getElementById('fldPassword').setAttribute("value",password);
	} catch (e) {dump("exception\n");}
  EnableInputs();
  InitFieldsFromPrefs(false);

  // if the user types in screenname and if find the password from pref, enable the send button.
  if ((password.length != 0) && (screenName.length != 0))
    enableSignOnButton(true);
  else
    enableSignOnButton(false);
  // ..so.. if the user enters username and password is filled from prefs, then on enter key sign on.
  if ((event.keyCode == 13) && (password.length != 0) && (screenName.length != 0))
    cmdPanelSignOn();

  // if the user presses Enter and password fiels is empty, put the focus in password field.
  if ((event.keyCode == 13) && (password.length == 0))
    document.getElementById('fldPassword').focus();
}

  /*
  * Name: enableSignOnButton
  *
  * Arguments: flag. 
  *
  * Description:
  *
  * This function enables or disables the signon button based on the flag.
  *    true = enables the button
  *    false = disables the button
  *
  * Return Value: none
  *
  * Author: Suresh Kasinathan<suresh@netscape.com> 8/20/01
  *
  */

function enableSignOnButton(flag) {
  var signOnButton = document.getElementById('spsignonSignOn2');
  if (signOnButton) {
    if (flag)
      signOnButton.setAttribute("disabled", "false");
    else
      signOnButton.setAttribute("disabled", "true");
  }
}

function cmdClickSavePassword() {
	// Enabled state of autoLogin checkbox depends on
	// state of savePassword checkbox
  EnableInputs();
}

function cmdClickAutoLogin() {
}

function cmdRegisterScreenName() {
	var screenName = document.getElementById('fldRegisterName').value;

	if (screenName == '') {
		aimErrorBox(aimString("msg.NoScreenName"));
		return;
	}
  
  // this will call into nsIAimSession, save the screen name in prefs and
  // notify our observers to go from the register panel to the signon panel
  aimSessionRegister(screenName);

	document.getElementById('fldScreenName').value = screenName;
}

function cmdDoubleClick(event)
{
	var t = event.originalTarget;
	if (t.localName != "treecell" &&
		t.localName != "treeitem" &&
		t.localName != "image" ) 

		return;

	var screenName = event.target.parentNode.parentNode.getAttribute('ScreenName');

	if(screenName) 
		cmdNewIM();
/*
		if ( aimIMDoesIMExist(screenName) )
			// XXX should be entity
			aimErrorBox(aimString("msg.DuplicateIM"));
		else {
			if ( aimBuddyIsOnline(screenName) )
				aimIMInvokeIMForm(screenName, null);
			else
				aimIMInvokeIMForm("", null);
		}
	}
*/
}
function cmdFocus(event)
	{
	dump('focus: ' + event.target.tagName + '\n');
	}
function cmdBlur(event)
	{
	dump('blur: ' + event.target.tagName + '\n');
	}
function cmdGroupKeyUp(event)
	{
	if (event.keyCode == 13)
		{
		var item = event.target.parentNode.parentNode.parentNode;
		var name = item.getAttribute('Name');
		var newName = event.target.value;

		dump('renameGroup: ' + name + ', ' + newName + '\n');
		aimBuddyRenameBuddyGroup(name, newName);
		}
	}
function cmdBuddyKeyUp(event)
	{
	if (event.keyCode == 13)
		{
		var item = event.target.parentNode.parentNode.parentNode;
		var screenName = item.getAttribute('ScreenName');
		var newName = event.target.value;

		var groupItem = item.parentNode.parentNode;
		var groupName = groupItem.getAttribute('Name');

		var nextBuddy = null;
		if (item.nextSibling)
			nextBuddy = item.nextSibling.getAttribute('ScreenName');

		// XXX aimBuddyReplaceBuddy(groupName, screenName, newName);
		aimBuddyRemoveBuddy(groupName, screenName);
		aimBuddyAddBuddy(groupName, newName, nextBuddy);
		}
	}
function spInPlaceAddBuddy()
	{
	dump('spInPlaceAddBuddy\n');
	spInPlaceAddDelete( "AddBuddy" );
	}
function spAddBuddy()
	{
	val = prompt( "Enter Buddy Name","" );
	}
function spAddGroup()
	{
	val = prompt( "Enter Group Name", "" );
	}
function spInPlaceAddGroup()
	{
	dump('spInPlaceAddGroup\n');
	spInPlaceAddDelete( "AddGroup" );
	}
function spInPlaceDelete()
	{
	dump('spDelete\n');
	spInPlaceAddDelete( "Delete" );
	}

function spInPlaceAddDelete( what )	// "Delete", "AddGroup", "AddBuddy"
	{
	// Locate selection in setup list
	// XXX There must be a better way to do this
	var selectedGroup = null;
	var selectedBuddy = null;
	var tree = document.getElementById("ListSetup");
	var groups = tree.childNodes[2].childNodes;
	for (var i = 0; i != groups.length; i++)
		{
		if (groups[i].getAttribute("selected") == "true")
			{
			selectedGroup = groups[i].getAttribute("Name");
			break;
			}

		var buddies = null;
		for (var j = 0; j != groups[i].childNodes.length; j++)
			{
			if (groups[i].childNodes[j].nodeName == "treechildren")
				{
				buddies = groups[i].childNodes[j].childNodes;
				break;
				}
			}

		if (buddies)
			{
			for (var j = 0; j != buddies.length; j++)
				{
				if (buddies[j].getAttribute("selected") == "true")
					{
					selectedBuddy = buddies[j].getAttribute("ScreenName");
					break;
					}
				}

			if (selectedBuddy)
				{
				selectedGroup = groups[i].getAttribute("Name");
				break;
				}
			}
		}

	dump('  selectedGroup: ' + selectedGroup + '\n');
	dump('  selectedBuddy: ' + selectedBuddy + '\n');

	if (what == "AddBuddy")
		aimBuddyAddBuddy(selectedGroup, null, selectedBuddy);
	else if (what == "AddGroup")
		aimBuddyAddBuddyGroup(null, selectedGroup);
	else if (what == "Delete")
		{
		if (selectedBuddy)
			aimBuddyRemoveBuddy(selectedGroup, selectedBuddy);
		else if (selectedGroup)
			aimBuddyRemoveBuddyGroup(selectedGroup);
		}
	}

function spFindEmpty( display )	
{
	// Locate selection in setup list
	// XXX There must be a better way to do this
	var selectedGroup = null;
	var selectedBuddy = null;
	var tree = document.getElementById("ListSetup");
	var groups = tree.childNodes[2].childNodes;

	dump( "In spFindEmpty\n" );
	for (var i = 0; i != groups.length; i++)
	{
		var buddies = null;
		for (var j = 0; j != groups[i].childNodes.length; j++)
		{
			if (groups[i].childNodes[j].nodeName == "treechildren")
			{
				buddies = groups[i].childNodes[j].childNodes;
				break;
			}
		}

		if (buddies)
		{
			for (var j = 0; j != buddies.length; j++)
			{
				if (buddies[j].getAttribute("ScreenName") == "")
				{
					dump( "Found a screen name that is empty\n" );
					selectedBuddy = buddies[j];
					if ( display == "none" ) {
						dump( "Setting style to display: none\n" );
						selectedBuddy.setAttribute("style", "visibility: hidden;");
						selectedBuddy.setAttribute("Yabba", "Dabba;");
					}
					else {
						dump( "Setting style to display: block\n" );
						selectedBuddy.setAttribute("style", "visibility: visible;");
					}
				}
				if (buddies[j].getAttribute("type") == "text")
				{
					dump( "Found an object that has a type of 'text'\n" );
				}
			}
		}
	}

	dump('  selectedGroup: ' + selectedGroup + '\n');
	dump('  selectedBuddy: ' + selectedBuddy + '\n');
}
/*
function displayFrontTab(tabObj)
{
	tabOne=document.getElementById('tabOnline');
	tabTwo=document.getElementById('tabSetup');
	tabOne.setAttribute("style","");
	tabTwo.setAttribute("style","");
	tabObj.setAttribute("style","");
}

*/

/*** setup chat callbacks for rendezvous ***/
/** start services **/
var IMServiceClass = Components.classes['@netscape.com/aim/IMManager;1'];
var pIIMManager  = IMServiceClass.getService(Components.interfaces.nsIIMManager);
var ChatManager = pIIMManager.QueryInterface(Components.interfaces.nsIAimChatManager);

/*** setup the chat call backs **/
 var ChatCallback = new Object();

 ChatCallback.OnRequestRoomComplete =  function(roomName,chatRoomObj){
  dump("OnRequestRoomComplete: success on " + roomName + "\n");

  chatRoomObj.SetChatRoomCallback(ChatRoomCallback);

 top.chatRoomObj = chatRoomObj;
  window.setTimeout('top.chatRoomObj.Join()', 5000);
  window.setTimeout('top.chatRoomObj.Invite("vishy26aug", "Join this MAAN")', 10000);
  window.setTimeout('top.chatRoomObj.SendMessage("This is working!!")', 30000);
  window.setTimeout('top.chatRoomObj.SendWhisper("vishy26aug", "Private message for vishy26aug")', 30000);
 }


 ChatCallback.OnRequestRoomError =  function(roomName,errMsg){
  dump("OnRequestRoomError: there was an error \n");

 }

/** setup the chat Room callbacks **/

 var ChatRoomCallback = new Object();

 ChatRoomCallback.OnJoined = function()
 {
  dump("Yes I Joined\n");
 }

 ChatRoomCallback.OnUserJoined = function(screenName)
 {
  dump( screenName + "joined the chat\n");
 }

 ChatRoomCallback.OnInfoUpdate = function()
 {
 }

 ChatRoomCallback.OnMessageReceived = function(screenName, language, message)
 {
  dump (screenName + " SAYETH " + message + " IN " + language +"\n");
 }



var rendezvousCallback = new Object();

rendezvousCallback.OnProposalReceived = function (screenname, proposal)
{
    dump ("got a proposal from " + screenname + "\n");

     //proposal.Accept();
     inviteArgsObj = {
     	inviteProposalScreenName: screenname, 
     	inviteProposalObj: proposal,
     	invitedScreenNames: '',
     	inviteToExistingWindow: false,
     	inviteMode: 'incomingchat'
     	}
     dump('send proposal to dialog! \n;')
	window.openDialog('chrome://aim/content/chatInviteBuddy.xul','_blank','chrome,all,dialog=no',inviteArgsObj); 
	
     //dump("accepted the proposal");

     //ChatManager.RequestProposedRoom(ChatCallback, proposal);

 }
 
function setupChatRendezvous(){
	dump("entering setupChatRendezvous 3\n");
	ChatManager.SetChatRendezvousCallback(rendezvousCallback)
	dump("exiting setupChatRendezvous \n");
}


/***  end setup chat callbacks for rendezvous ***/

function cmdNewChatSidebar(invScreenName,invProposal,invScreenNames,toExistingWindow,invMode){

     inviteArgsObj = {
     	inviteProposalScreenName: invScreenName, 
     	inviteProposalObj: invProposal,
     	invitedScreenNames: getSelectedBuddiesFromList(), //invScreenNames, (getSelectedBuddiesFromList is in App.js)
     	inviteToExistingWindow: toExistingWindow,
     	inviteMode: invMode
     	}
     	
	window.openDialog('chrome://aim/content/chatInviteBuddy.xul','_blank','chrome,all,dialog=no',inviteArgsObj);
}

// Function to open a new window for password lookup
function openPassLink()
{
  aimRegionBundle = document.getElementById('bundle_aim_region');
  passLink = aimRegionBundle.getString("aim.password.url");
  openTopWin(passLink);
}

function UpdateUserWarning(warning)
{
  var name = document.getElementById("warnname");
  var warn = document.getElementById("warnamount");
  if (warning != null)
  {
    if (warning > 0)
    {
      warn.setAttribute("value", " - " + warning + "%");
      name.setAttribute("class", "warned");
    }
    else
    {
      warn.setAttribute("value", "");
      name.setAttribute("class", "not-warned");
    }
    
    return
  }
  
  var curname=aimSessionCurrentScreenName();
  
  name.setAttribute("value",curname);
  
  var locateManager = aimLocateManager();
  var LocateCallbackObject = new Object();
  
  LocateCallbackObject.OnRequestUserInfoDefaultComplete = function(screenname, userobj)
  {
    var percent = userobj.GetWarningPercent();
    if (percent > 0 )
    {
      warn.setAttribute("value", " - " + percent + "%");
      name.setAttribute("class", "warned");
    }
    else
    {
      warn.setAttribute("value", "");
      name.setAttribute("class", "not-warned");
    }
  }

  LocateCallbackObject.OnRequestUserInfoDefaultError = function(screenname, error)
  {
    //nothing
  }

  locateManager.RequestUserInfoDefault( LocateCallbackObject, curname); 
}
