/* This overlay JS file contains the JS necessary for integrating
   AIM presence into the messenger msg header pane overlay (msgHdrViewOverlay).

   It allows us to dynamically modify the msg hdr view overlay to add 
   presence indication for email addresses in that pane.
*/

/* we need to implement a data source observer on the buddy list so we
   are notified when people are online or not 
*/ 


// cache the properties we are interested in...
var buddyStateString = RDF.GetResource("http://home.netscape.com/NC-rdf#BuddyStateString");

// This array of dom nodes is an array indexed by URI that keeps track of the
// dom nodes in the msg header pane we care about...
var domNodes = new Object();

var AimDataSourceObserver = 
{
  onAssert: function(datasource, source, property, target)
  {
    // onAssert is going to be called a lot, so make sure you try to kick out
    // as early as possible to avoid any extra over head.....
	  if(source.EqualsNode(aimRDFSession()))
	  {
		  if(property.EqualsNode(aimRDFSessionState()))
		  {
        var state = target.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
        // if we are going offline then be sure to clear the presence state for 
        // all of the aim resources we are interested in.
        if (state && state == "Offline")
        {
          for (i in domNodes)
            domNodes[i].setAttribute("BuddyStateString", "Offline");
        }
      }
    }
    else if (property.EqualsNode(buddyStateString))
    {
      var targetString = target.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
      // dump("changing buddy state for" + source.Value + "with target: " + targetString + "\n");
	  var node = domNodes[source.Value];
      //var node = domNodes[node];
      if (node)
        SetPresence(node, target);
    }
  },

  onUnassert: function(datasource, source, property, target)
  {
  },

  onChange: function(datasource, source, property, oldTarget, newTarget)
  {
    AimDataSourceObserver.onAssert(datasource, source, property, newTarget);
  },

  onMove: function(datasource, oldSource, newSource, property, target)
  {
    AimDataSourceObserver.onAssert(datasource, newSource, property, target);
  },

  beginUpdateBatch: function(datasource)
  {
  },

  endUpdateBatch: function(datasource)
  {
  }
};

/* SetPresence updates the titled button image (node)
   based on the property value of presence
*/
function SetPresence(node, presence)
{
  if (node)
  {
   // if we have a node that corresponds to this URI, then we need to poke
   // it....
    var targetString = presence.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
    node.setAttribute("BuddyStateString", targetString);
    // this silly align hack is because css isn't noticing the alignment
    // attribute unless I set it to something...then set it back to what
    // I really want...
    node.setAttribute("align", "left");
    node.setAttribute("align", "right");
    node.setAttribute("max-height", "15px");
  }
}

/* Extract the AIM ID from the node and send an instant message
*/
function SendIMFor (node)
{
//XXXjelwellXXX might need to change state from OnlineAway to Online
  var target = aimRDFDataSource().GetTarget(aimRDFSession(), aimRDFSessionState(), true);
  var state = target.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
  if ("OnlineAway" == state)
  {
	if ( aimLocateManager() ) {
		aimLocateManager().SetUserInfoAwayMessage(null);
	}
  }

  if (node)
  {
    var screenName = node.getAttribute("IMScreenName");
    if (screenName)
    {
      aimIMInvokeIMForm(screenName, null);
    }
    else
      aimIMInvokeIMForm(null, null);
  }
}

function AddToBuddyListFor(node)
{
//XXXjelwellXXX might need to change state from OnlineAway to Online
  if (node)
  {
    var screenName = node.getAttribute("IMScreenName");
    openDialog("chrome://aim/content/BuddyAddBuddy.xul", "", "modal=yes,titlebar,chrome", null, null, screenName);
  }
}

/* OnLoadAimHdrViewOverlay --> called when the overlay is first loaded...
   This is where we will register ourself as an observer on the AIM data source.
*/

function OnLoadAimHdrViewOverlay ()
{
  aimRDFDataSource().AddObserver(AimDataSourceObserver);
}

function OnUnLoadAimHdrViewOverlay ()
{
  aimRDFDataSource().RemoveObserver(AimDataSourceObserver);
}

// Install our load handler
addEventListener("load", OnLoadAimHdrViewOverlay, false);
addEventListener("unload", OnUnLoadAimHdrViewOverlay, false);
