/*
 *  Copyright (C) 2001 Jorn Baayen
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __page_info_h
#define __page_info_h

#ifdef __cplusplus
extern "C" {
#endif

#include "galeon_types.h"
	
typedef enum
{
	PAGE_INFO_GENERAL     = 0,
	PAGE_INFO_IMAGES      = 1,
	PAGE_INFO_FORMS       = 2,
	PAGE_INFO_STYLESHEETS = 3,
	PAGE_INFO_LINKS       = 4
} PageInfoPage;

typedef struct
{
	/* main widgets */
	GtkWidget *dialog;
	GtkWidget *notebook;
	GtkWidget *paned;

	/* general page */
	GtkWidget *title;
	GtkWidget *url;
	GtkWidget *date;

	/* images page */
	GtkWidget *images_clist;
	GtkWidget *image;
	gchar *selected_url;
	gpointer selected_row;

	/* forms page */
	GtkWidget *forms_clist;

	/* stylesheets page */
	GtkWidget *css_clist;

	/* links page */
	GtkWidget *links_clist;

	/* associated embed */
	GaleonEmbed *embed;
} PageInfoDialog;

/* page_info.c */
void page_info_show_dialog (GaleonEmbed *embed, PageInfoPage page);

#ifdef __cplusplus
}
#endif

#endif /* __page_info_h */
