/* GnomeICU
 * Copyright (C) 1998-2002 Jeremy Wise
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * Functions for facilitating authorization (GUI)
 * first created by Patrick Sung (Jan 2002)
 */

#include "common.h"
#include "gnomeicu.h"
#include "auth.h"
#include "v7snac13.h"

static UIN_T req_uin = 0;

void auth_sendbutton_clicked (GtkWidget *w, gpointer d);
void auth_cancelbutton_clicked (GtkWidget *w, gpointer d);
gboolean auth_receive_dialog (gchar *msg);
void auth_grantbutton_clicked (GtkWidget *w, gpointer d);
void auth_denybutton_clicked (GtkWidget *w, gpointer d);

void
auth_request_msg_box (const gchar *nick, UIN_T uin)
{
  GladeXML *authbox;
  GtkWidget *authlabel;
  GtkWidget *authmsg;
  GtkWidget *sendbutton;
  gint pos;
  gchar *str;

#ifdef TRACE_FUNCTION
  g_print( "auth_request_msg_box\n" );
#endif

  authbox = glade_xml_new (GNOMEICU_GLADEDIR "auth.glade", "auth_request");

  if (authbox == NULL) {
    gnome_dialog_run (GNOME_DIALOG
		      (gnome_message_box_new
		       (_("Unable to load Authorization Dialog interface (auth_request)!"),
			GNOME_MESSAGE_BOX_ERROR, GNOME_STOCK_BUTTON_OK, NULL)));
    return;
  }

  authlabel = glade_xml_get_widget (authbox, "authlabel");
  str = g_strdup_printf (_("User %s (%d) need authorization. GnomeICU is going "
			   "to send an authorization message to your friend."),
			 nick, uin);
  gtk_label_set_text (GTK_LABEL (authlabel), str);
  g_free (str);

  authmsg = glade_xml_get_widget (authbox, "authmsgtext");
  gtk_text_set_word_wrap (GTK_TEXT (authmsg), TRUE);
  str = g_strdup_printf (_("Please authorize my request and add me to your "
			   "Contact List. %s (%d)."),
			 our_info->nick, our_info->uin);
  pos = 0;
  gtk_editable_insert_text (GTK_EDITABLE (authmsg), str, strlen (str), &pos);
  g_free (str);

  gtk_object_set_data (GTK_OBJECT (glade_xml_get_widget (authbox, "cancelbutton")),
		       "dlg", glade_xml_get_widget (authbox, "auth_request"));
  gtk_object_set_data (GTK_OBJECT (glade_xml_get_widget (authbox, "sendbutton")),
		       "dlg", glade_xml_get_widget (authbox, "auth_request"));
  gtk_object_set_data (GTK_OBJECT (glade_xml_get_widget (authbox, "sendbutton")),
		       "text", authmsg);

  glade_xml_signal_autoconnect (authbox);

  sendbutton = glade_xml_get_widget (authbox, "sendbutton");
  gtk_widget_grab_focus (sendbutton);

  gtk_object_unref (GTK_OBJECT (authbox));
}

void
auth_sendbutton_clicked (GtkWidget *w, gpointer d)
{
  GtkWidget *dialog;
  GtkWidget *text;
  gchar *msg;

#ifdef TRACE_FUNCTION
  g_print( "auth_sendbutton_clicked\n" );
#endif

  dialog = gtk_object_get_data (GTK_OBJECT (w), "dlg");
  text = gtk_object_get_data (GTK_OBJECT (w), "text");
  
  msg = gtk_editable_get_chars (GTK_EDITABLE (text), 0, -1);

  v7_ask_uin_for_auth (msg);

  g_free (msg);
  gtk_widget_destroy (dialog);
}

void
auth_cancelbutton_clicked (GtkWidget *w, gpointer d)
{
  GtkWidget *dialog;

#ifdef TRACE_FUNCTION
  g_print( "auth_cancelbutton_clicked\n" );
#endif

  dialog = gtk_object_get_data (GTK_OBJECT (w), "dlg");
  gtk_widget_destroy (dialog);
}

void
auth_receive_request (UIN_T uin, const gchar *msg)
{
  gchar *mymsg;

  req_uin = uin;
  mymsg = g_strdup (msg);

  /* do the auth stuff */
  g_idle_add ((GSourceFunc)auth_receive_dialog, mymsg);
}

gboolean
auth_receive_dialog (gchar *msg)
{
  GladeXML *authbox;
  GtkWidget *grantlabel;
  GtkWidget *reqmsg;
  GtkWidget *grantbutton;
  gint pos;
  gchar *str;

#ifdef TRACE_FUNCTION
  g_print( "auth_receive_dialog\n" );
#endif

  authbox = glade_xml_new (GNOMEICU_GLADEDIR "auth.glade", "auth_recv");

  if (authbox == NULL) {
    gnome_dialog_run (GNOME_DIALOG
		      (gnome_message_box_new
		       (_("Unable to load Authorization Dialog interface (auth_recv)!"),
			GNOME_MESSAGE_BOX_ERROR, GNOME_STOCK_BUTTON_OK, NULL)));
    return FALSE;
  }

  grantlabel = glade_xml_get_widget (authbox, "grantlabel");
  str = g_strdup_printf (_("User %d is requesting authorization. Do you want to "
                           "grant the authorization so he/she can add you?"),
                         req_uin);
  gtk_label_set_text (GTK_LABEL (grantlabel), str);
  g_free (str);

  reqmsg = glade_xml_get_widget (authbox, "grantmsgtext");
  gtk_text_set_word_wrap (GTK_TEXT (reqmsg), TRUE);
  pos = 0;
  gtk_editable_insert_text (GTK_EDITABLE (reqmsg), msg, strlen (msg), &pos);

  gtk_object_set_data (GTK_OBJECT (glade_xml_get_widget (authbox, "denybutton")),
		       "dlg", glade_xml_get_widget (authbox, "auth_recv"));
  gtk_object_set_data (GTK_OBJECT (glade_xml_get_widget (authbox, "grantbutton")),
		       "dlg", glade_xml_get_widget (authbox, "auth_recv"));

  glade_xml_signal_autoconnect (authbox);

  grantbutton = glade_xml_get_widget (authbox, "grantbutton");
  gtk_widget_grab_focus (grantbutton);

  gtk_object_unref (GTK_OBJECT (authbox));

  /* make sure we free the allocated str malloc from auth_receive_request() */
  g_free (msg);

  return FALSE;

  /* Additional features: (TODO) */
  /*  - also get user info from server using the UIN? */
  /*  - provide button to add user as well? if user is not on your list already
   *    which should be doing something similar to add_from_search() in search.c
   */
}


void
auth_grantbutton_clicked (GtkWidget *w, gpointer d)
{
  GtkWidget *dialog;

  dialog = gtk_object_get_data (GTK_OBJECT (w), "dlg");
  gtk_widget_destroy (dialog);

  v7_grant_auth_request (req_uin);
}

void
auth_denybutton_clicked (GtkWidget *w, gpointer d)
{
  GtkWidget *dialog;

  dialog = gtk_object_get_data (GTK_OBJECT (w), "dlg");
  gtk_widget_destroy (dialog);
}
