#include "common.h"
#include "listwindow.h"
#include "sendcontact.h"
#include "util.h"
#include "v7send.h"

static void move_contacts_to_list( GtkWidget *widget, gpointer data );
void send_contact_list( GtkWidget *widget, gpointer data );

void contact_list_window( CONTACT_PTR contact )
{
	GtkWidget *dlg;
        gchar *msg;
	
        msg = g_strdup_printf( _("Drag the users you wish to send\n"
				 "to %s to this window, and then click the\n"
				 "\"Send\" button below."), contact->nick );
	dlg = list_window_new_with_drag_drop(
		_("GnomeICU: Send Contact List"), "Send_Contact_List",
		msg, _("Send"), GNOME_STOCK_PIXMAP_JUMP_TO,
		GTK_SIGNAL_FUNC (send_contact_list),
		NULL
	);
	gtk_object_set_data( GTK_OBJECT( GNOME_DIALOG (dlg)->buttons->data ),
			     "uin", GINT_TO_POINTER( contact->uin ) );
	gtk_widget_show( dlg );
}

void received_contact_list_window( CONTACT_PTR contact, GSList *contacts )
{
	GtkWidget *dlg;
	GtkCList *clist;
        GSList *contactnow;
	char *caption;
	char *buf[2];
	
        caption = g_strdup_printf( _("The following contact list was sent by %s.\n"
				   "Please remove the users you don't want to add\n "
				   "and then click the \"Add to List\"\n button below."),
				   contact->nick );
	dlg = list_window_new_with_drag_drop(
		_("GnomeICU: Received Contact List"), "Recd_Contact_List",
		caption, _("Add to List"), GNOME_STOCK_PIXMAP_ADD,
		GTK_SIGNAL_FUNC (move_contacts_to_list),
		NULL
	);

	gtk_widget_show( dlg );

	clist = gtk_object_get_data( GTK_OBJECT( GNOME_DIALOG (dlg)->buttons->data ),
			     "clist" );


        for (contactnow = contacts; contactnow != NULL;
             contactnow = contactnow->next) {
          buf[0] = ((ContactPair *)contactnow->data)->textuin;
          buf[1] = ((ContactPair *)contactnow->data)->nick;
          gtk_clist_append( clist, buf );
        }
        
        /* Free the list */
        
        while (contacts != NULL) {
          g_free(contacts->data);
          contacts = g_slist_remove(contacts, contacts->data);
        }

}

void move_contacts_to_list( GtkWidget *widget, gpointer data )
{
	GtkCList *clist = GTK_CLIST( data );
	gchar *nick;
	UIN_T uin;
	int cx;

	for( cx = 0; cx < clist->rows; cx ++ )
	{
		gtk_clist_get_text( clist, cx, 0, &nick );
		uin = atoi( nick );
		gtk_clist_get_text( clist, cx, 1, &nick );
		Add_User( uin, nick, TRUE );
	}
}


void send_contact_list( GtkWidget *widget, gpointer data )
{

  GtkCList *clist = GTK_CLIST( data );
  GList *contacts = NULL;
  UIN_T uin;
  ContactPair *cpair;
  int i;
  gchar *nick;

#ifdef TRACE_FUNCTION
  g_print( "send_contact_list\n" );
#endif
        
  uin = GPOINTER_TO_INT( gtk_object_get_data( GTK_OBJECT( widget ), "uin" ) );

  if (clist->rows == 0)
    return;
  
  for( i = 0; i < clist->rows; i ++ ) {
    cpair = g_malloc(sizeof(ContactPair));
    gtk_clist_get_text( clist, i, 0, &nick );
    cpair->textuin = g_strdup(nick);
    gtk_clist_get_text( clist, i, 1, &nick );
    cpair->nick = g_strdup(nick);
    contacts = g_list_append(contacts, cpair);
  }
        
  v7_sendcontacts(uin, contacts);

  while (contacts != NULL) {
    g_free(contacts->data);
    contacts = g_list_remove(contacts, contacts->data);
  }

}
