/* vi:set ts=8 sts=0 sw=8:
 * $Id: gtkefilesel.h,v 1.2 1999/07/14 17:23:41 kahn Exp kahn $
 * 
 * GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * Enhanced File Selection Dialog (GtkEfileSel) by Andy Kahn, 1999.
 * Modified from the original File Selection Dialog found in gtk+-1.2.3.
 * See below for details on modifications.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * Modified by the GTK+ Team and others 1997-1999.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/. 
 */

#ifndef __GTK_EFILESEL_H__
#define __GTK_EFILESEL_H__


#include <gdk/gdk.h>
#include <gtk/gtkwindow.h>
#include "main.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifdef USE_ENHANCED_FSEL

#define GTK_TYPE_EFILESEL            (gtk_efilesel_get_type ())
#define GTK_EFILESEL(obj)            (GTK_CHECK_CAST ((obj), GTK_TYPE_EFILESEL, GtkEfileSel))
#define GTK_EFILESEL_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_EFILESEL, GtkEfileSelClass))
#define GTK_IS_EFILESEL(obj)         (GTK_CHECK_TYPE ((obj), GTK_TYPE_EFILESEL))
#define GTK_IS_EFILESEL_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_EFILESEL))


typedef struct _GtkEfileSel GtkEfileSel;
typedef struct _GtkEfileSelClass GtkEfileSelClass;

struct _GtkEfileSel {
	/*
	 * these are "public" members, and the user is allowed to at least look
	 * at them.
	 */
	GtkWindow window;
	GtkWidget *ok_button;		/* allow user callback */
	GtkWidget *cancel_button;	/* allow user callback */

	/*
	 * these are all "private" members, and the user should not directly
	 * muck with any of them.
	 */
	GtkWidget *dir_list;		/* CList containing subdirectories */
	GtkWidget *file_list;		/* CList containing filenames */
	GtkWidget *selection_entry;	/* filename entry text space */
	GtkWidget *selection_text;	/* filename selected */
	GtkWidget *history_pulldown;
	GtkWidget *history_menu;
	GList *history_list;
	GtkWidget *fileop_dialog;
	GtkWidget *fileop_entry;
	char *fileop_file;
	gpointer cmpl_state;

	GtkWidget *button_area;		/* contains the fileop buttons */
	GtkWidget *fileop_c_dir;
	GtkWidget *fileop_del_file;
	GtkWidget *fileop_ren_file;

	GtkWidget *fileinfo;		/* table with file detail widgets */
	GtkWidget *fname;		/* filename */
	GtkWidget *mtime;		/* file's modification time */
	GtkWidget *fsize;		/* file's size in bytes */
	GtkWidget *owner;		/* file's owner */
	GSList	  *fname_list;		/* linked list of selected file(s) */
};

struct _GtkEfileSelClass {
	GtkWindowClass parent_class;
};


GtkType gtk_efilesel_get_type(void);
GtkWidget *gtk_efilesel_new(const char *title);
void gtk_efilesel_set_filename(GtkEfileSel *fsel, const char *filename);
void gtk_efilesel_complete(GtkEfileSel *fsel, const char *pattern);
void gtk_efilesel_show_fileop_buttons(GtkEfileSel *fsel);
void gtk_efilesel_hide_fileop_buttons(GtkEfileSel *fsel);

/*
 * Returns the selected filename.  If more than one filename is selected, only
 * the first one is returned.  The filename string will *NOT* be in a newly
 * allocated buffer.  You should use g_strdup() to make yourself a copy.
 */
char *gtk_efilesel_get_filename(GtkEfileSel *fsel);


/*
 * If one or more filenames are selected, return them all in a singly linked
 * list.  The filename will be in each list node's 'data' field.  The list as
 * well as its 'data' field are *NOT* newly allocated, and thus, you should not
 * free them.
 */
GSList *gtk_efilesel_get_filename_list(GtkEfileSel *fsel);


/*
 * Not all modes available in a typical clist (see GtkCList) are available in
 * the file clist of a GtkEfileSel widget.  Only two are valid:
 *
 * 1. GTK_SELECTION_SINGLE
 * 2. GTK_SELECTION_MULTIPLE	(this is the default)
 *
 * You can change the selection mode with gtk_efilesel_set_mode().
 */
void gtk_efilesel_set_mode(GtkEfileSel *fsel, GtkSelectionMode mode);


/*
 * File details can be shown/hidden with the following two functions.
 */
void gtk_efilesel_show_file_details(GtkEfileSel *fsel);
void gtk_efilesel_hide_file_details(GtkEfileSel *fsel);
#else

/*
 * If not using the Enhanced File Selection dialog, simply default to the
 * regular File Selection dialog.
 */

#define GTK_TYPE_EFILESEL            GTK_TYPE_FILE_SELECTION
#define GTK_EFILESEL(obj)            GTK_FILE_SELECTION(obj)
#define GTK_EFILESEL_CLASS(klass)    GTK_FILE_SELECTION_CLASS(klass)
#define GTK_IS_EFILESEL(obj)         GTK_IS_FILE_SELECTION(obj)
#define GTK_IS_EFILESEL_CLASS(klass) GTK_IS_FILE_SELECTION_CLASS(klass)

#define gtk_efilesel_get_type		gtk_file_selection_get_type

#define gtk_efilesel_new(title)		gtk_file_selection_new(title)

#define gtk_efilesel_set_filename(fs, fn) \
					gtk_file_selection_set_filename(fs, fn)

#define gtk_efilesel_get_filename(fs)	gtk_file_selection_get_filename(fs)

#define gtk_efilesel_complete(fs, pat)	gtk_file_selection_complete(fs, pat)

#define gtk_efilesel_show_fileop_buttons(fs) \
				gtk_file_selection_show_fileop_buttons(fs)

#define gtk_efilesel_hide_fileop_buttons(fs) \
				gtk_file_selection_hide_fileop_buttons(fs)

#endif	/* USE_ENHANCED_FSEL */

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GTK_EFILESEL_H__ */
