#ifndef LYRICS_H
#define LYRICS_H

#include <noatun/plugin.h>
#include <noatun/player.h>
#include <noatun/app.h>
#include <kmainwindow.h>
#include <khtml_part.h>
#include <kaction.h>
#include <qvaluestack.h>

class HistoryManager;

class Lyrics : public KMainWindow, public Plugin {
Q_OBJECT
NOATUNPLUGIND;

public:
  Lyrics();
  ~Lyrics();
  void go(const KURL &);

public slots:
  void viewLyrics();
  void back();
  void forward();

protected:
	bool queryClose();

protected slots:
  void changeUI(int, bool);
  void openURLRequest( const KURL &, const KParts::URLArgs & );
  void loadingURL(KIO::Job *);
  void loadedURL();
  void newSong();

private:
	int menuID;
  KAction *back_act, *forward_act;
  KToggleAction *follow_act;
	KHTMLPart *htmlpart;
  HistoryManager *history;

};

class HistoryManager : public QObject {
  Q_OBJECT
  public:
    HistoryManager();
    ~HistoryManager();
    KURL back();
    KURL forward();
    void addURL(const KURL &);
    enum Buttons {
      Back,
      Forward
    };
  signals:
    void uiChanged(int, bool);
  protected:
    QValueStack<KURL> back_stack;
    QValueStack<KURL> forward_stack;
    KURL currentURL;
};
  

#endif
