//////////////////////////////////////////////////////////////
//      $Id: debInterface.h,v 1.20 2001/11/09 15:34:10 toivo Exp $ 
//
// Author: Toivo Pedaste
//
//////////////////////////////////////////////////////////////

#ifndef DEB_IFACE_H
#define DEB_IFACE_H

#include "../config.h"

#include <qptrlist.h>
#include <qdir.h> 
#include <qfile.h> 
#include <qfileinf.h> 
#include <qtextstream.h>
#include <qstringlist.h> 

#include <kprocess.h>

#include "pkgInterface.h"

class packageInfo;
class updateLoc;
class cacheObj;

#define AVAIL          "/var/lib/dpkg/available"
#define STATUS          "/var/lib/dpkg/status"

#define INFODIR         "/var/lib/dpkg/info/"


class DEB: public pkgInterface
{
  Q_OBJECT

public:
  DEB();
  ~DEB();
  
  virtual bool isType(char *buf, const QString &fname);

  virtual packageInfo *getPackageInfo(char mode, const QString &name,
			      const QString &version);
  virtual QStringList getFileList(packageInfo *p);

  virtual void listInstalledPackages(QPtrList<packageInfo> *pki);

  virtual QStringList FindFile(const QString &name);
  virtual bool parseName(QString name, QString *n, QString *v);

  virtual packageInfo* collectInfo(QStringList &inp);

  QString uninstall(int uninstallFlags, QPtrList<packageInfo> *p,
				  bool &test);
  QString install(int installFlags, QPtrList<packageInfo> *p,
				  bool &test);
  QString doInstall(int installFlags, QString packs, bool &test);

public slots:
  void setLocation();
  void setAvail(LcacheObj *);

protected:
  packageInfo *getIPackageInfo(const QString &name);
  packageInfo *getIRPackageInfo(const QString &name);
  packageInfo *getUPackageInfo(const QString &name);

  void listPackList(QPtrList<packageInfo> *pki,
		    const QString &fname, cacheObj *cp);

  void distPackages(QPtrList<packageInfo> *pki, cacheObj *cp);
  void listUnIPackages(QPtrList<packageInfo> *pki, LcacheObj *pCache);

  QStringList getIFileList(packageInfo *p);
  QStringList getUFileList(QString fn);
};

#endif



