/***************************************************************************
                            KConfigBase.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Abstract base class for KDE configuration entries.

 This class forms the base for all KDE configuration. It is an
 abstract base class, meaning that you cannot directly instantiate
 objects of this class. Either use {@link #KConfig} or {@link #KSimpleConfig}, or
 even KSharedConfig (stores values in shared memory).

 All configuration entries are key, value pairs.  Each entry also
 belongs to a specific group of related entries.  All configuration
 entries that do not explicitly specify which group they are in are
 in a special group called the default group.

 If there is a $ character in an entry, KConfigBase tries to expand
 environment variable and uses its value instead of its name. You
 can avoid this feature by having two consecutive $ characters in
 your config file which get expanded to one.

 @author Kalle Dalheimer <kalle@kde.org>, Preston Brown <pbrown@kde.org>

 @version $Id: KConfigBase.java,v 1.6 2002/02/13 22:42:40 rdale Exp $

 @short KDE Configuration Management abstract base class.
*/
public class KConfigBase extends QObject  {
	protected KConfigBase(Class dummy){super((Class) null);}


/** 
 Destructs the KConfigBase object.
   
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Specifies the group in which keys will be searched.

  Subsequent
 calls to {@link #readEntry} will look only for keys in the currently
 activated group.

 Switch back to the default group by passing a null string.

*/
	public native void setGroup( String group);

/** 
 Sets the group to the "Desktop Entry" group used for
 desktop configuration files for applications, mime types, etc.
   
*/
	public native void setDesktopGroup();

/** 
 Returns the name of the group in which we are
  searching for keys and from which we are retrieving entries.

*/
	public native String group();

/** 
 Returns true if the specified group is known about.

*/
	public native boolean hasGroup( String group);

/** 
 Returns a list of groups that are known about.

*/
	public native ArrayList groupList();

/** 
 Returns a the current locale.

*/
	public native String locale();

/** 
 Reads the value of an entry specified by <code>pKey</code> in the current group.

*/
	public native String readEntry( String pKey, String aDefault);
	public native String readEntry( String pKey);
//	public native String readEntry( String pKey, String aDefault);
//	public native String readEntry( String pKey);

/** 
 Reads the value of an entry specified by <code>pKey</code> in the current group.
 The value is treated as if it is of the given type.

 Note that only the following {@link QVariant#Type} are allowed : String,
 StringList, List, Font, Point, Rect, Size, Color, Int, UInt, Bool,
 Double, DateTime and Date.
   
*/
	public native QVariant readPropertyEntry( String pKey, int arg1);
//	public native QVariant readPropertyEntry( String pKey, int arg1);

/** 
 Reads the value of an entry specified by <code>pKey</code> in the current group.
 The value is treated as if it is of the type of the given default value.

 Note that only the following {@link QVariant#Type} are allowed : String,
 StringList, List, Font, Point, Rect, Size, Color, Int, UInt, Bool,
 Double, DateTime and Date.
   
*/
	public native QVariant readPropertyEntry( String pKey, QVariant adefault);
//	public native QVariant readPropertyEntry( String pKey, QVariant aDefault);

/** 
 Reads a list of strings.

*/
//	public native int readListEntry( String pKey, String[] list, char sep ' arg1, '  arg2);
	public native int readListEntry( String pKey, ArrayList list);
//	public native int readListEntry( String pKey, String[] list, char sep ' arg1, '  arg2);
//	public native int readListEntry( String pKey, String[] list);

/** 
 Reads a list of strings.

*/
//	public native ArrayList readListEntry( String pKey, char sep ' arg1, '  arg2);
//	public native ArrayList readListEntry( String pKey, char sep ' arg1, '  arg2);

/** 
 Reads a list of Integers.

*/
	public native int[] readIntListEntry( String pKey);
//	public native int[] readIntListEntry( String pKey);

/** 
 Reads a path.

 Read the value of an entry specified by <code>pKey</code> in the current group
 and interpret it as a path. This means, dollar expansion is activated
 for this value, so that e.g. $HOME gets expanded.

*/
	public native String readPathEntry( String pKey, String aDefault);
	public native String readPathEntry( String pKey);
//	public native String readPathEntry( String pKey, String aDefault);
//	public native String readPathEntry( String pKey);

/** 
 Reads a numerical value.

 Read the value of an entry specified by <code>pKey</code> in the current group
 and interpret it numerically.

*/
	public native int readNumEntry( String pKey, int nDefault);
	public native int readNumEntry( String pKey);
//	public native int readNumEntry( String pKey, int nDefault);
//	public native int readNumEntry( String pKey);

/** 
 Reads an unsigned numerical value.

 Read the value of an entry specified by <code>pKey</code> in the current group
 and interpret it numerically.

*/
	public native int readUnsignedNumEntry( String pKey, int nDefault);
	public native int readUnsignedNumEntry( String pKey);
//	public native int readUnsignedNumEntry( String pKey, int nDefault);
//	public native int readUnsignedNumEntry( String pKey);

/** 
 Reads a numerical value.

 Read the value of an entry specified by <code>pKey</code> in the current group
 and interpret it numerically.

*/
	public native long readLongNumEntry( String pKey, long nDefault);
	public native long readLongNumEntry( String pKey);
//	public native long readLongNumEntry( String pKey, long nDefault);
//	public native long readLongNumEntry( String pKey);

/** 
 Read an unsigned numerical value.

 Read the value of an entry specified by <code>pKey</code> in the current group
 and interpret it numerically.

*/
	public native long readUnsignedLongNumEntry( String pKey, long nDefault);
	public native long readUnsignedLongNumEntry( String pKey);
//	public native long readUnsignedLongNumEntry( String pKey, long nDefault);
//	public native long readUnsignedLongNumEntry( String pKey);

/** 
 Reads a floating point value.

 Read the value of an entry specified by <code>pKey</code> in the current group
 and interpret it numerically.

*/
	public native double readDoubleNumEntry( String pKey, double nDefault);
	public native double readDoubleNumEntry( String pKey);
//	public native double readDoubleNumEntry( String pKey, double nDefault);
//	public native double readDoubleNumEntry( String pKey);

/** 
 Reads a {@link QFont} value.

 Read the value of an entry specified by <code>pKey</code> in the current group
 and interpret it as a font object.

*/
	public native QFont readFontEntry( String pKey, QFont pDefault);
	public native QFont readFontEntry( String pKey);
//	public native QFont readFontEntry( String pKey, QFont pDefault);
//	public native QFont readFontEntry( String pKey);

/** 
 Reads a boolean entry.

 Read the value of an entry specified by <code>pKey</code> in the current group
 and interpret it as a boolean value. Currently "on" and "true" are
 accepted as true, everything else if false.

*/
	public native boolean readBoolEntry( String pKey, boolean bDefault);
	public native boolean readBoolEntry( String pKey);
//	public native boolean readBoolEntry( String pKey, boolean bDefault);
//	public native boolean readBoolEntry( String pKey);

/** 
 Reads a {@link QRect} entry.

 Read the value of an entry specified by pKey in the current group
 and interpret it as a {@link QRect} object.

*/
	public native QRect readRectEntry( String pKey, QRect pDefault);
//	public native QRect readRectEntry( String pKey, QRect pDefault);

/** 
 Reads a {@link QPoint} entry.

 Read the value of an entry specified by <code>pKey</code> in the current group
 and interpret it as a {@link QPoint} object.

*/
	public native QPoint readPointEntry( String pKey, QPoint pDefault);
//	public native QPoint readPointEntry( String pKey, QPoint pDefault);

/** 
 Reads a {@link QSize} entry.

 Read the value of an entry specified by <code>pKey</code> in the current group
 and interpret it as a {@link QSize} object.

*/
	public native QSize readSizeEntry( String pKey, QSize pDefault);
//	public native QSize readSizeEntry( String pKey, QSize pDefault);

/** 
 Reads a {@link QColor} entry.

 Read the value of an entry specified by <code>pKey</code> in the current group
 and interpret it as a color.

*/
	public native QColor readColorEntry( String pKey, QColor pDefault);
	public native QColor readColorEntry( String pKey);
//	public native QColor readColorEntry( String pKey, QColor pDefault);
//	public native QColor readColorEntry( String pKey);

/** 
 Reads a {@link QDateTime} entry.

 Read the value of an entry specified by <code>pKey</code> in the current group
 and interpret it as a date and time.

*/
	public native Calendar readDateTimeEntry( String pKey, Calendar pDefault);
//	public native Calendar readDateTimeEntry( String pKey, Calendar pDefault);

/** 
 Writes a key/value pair.

 This is stored in the most specific config file when destroying the
 config object or when calling {@link #sync}.

*/
	public native void writeEntry( String pKey, String pValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
	public native void writeEntry( String pKey, String pValue);
//	public native void writeEntry( String pKey, String pValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
//	public native void writeEntry( String pKey, String pValue);

/** 
 {@link #writeEntry} Overridden to accept a property.

 Note: Unlike the other {@link #writeEntry} functions, the old value is
 _not_ returned here!

*/
	public native void writeEntry( String pKey, QVariant rValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
	public native void writeEntry( String pKey, QVariant rValue);
//	public native void writeEntry( String pKey, QVariant rValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
//	public native void writeEntry( String pKey, QVariant rValue);

/** 
 {@link #writeEntry} overridden to accept a list of strings.

 Note: Unlike the other {@link #writeEntry} functions, the old value is
 _not_ returned here!

*/
	public native void writeEntry( String pKey, String[] rValue, char sep, boolean bPersistent, boolean bGlobal, boolean bNLS);
	public native void writeEntry( String pKey, String[] rValue);
//	public native void writeEntry( String pKey, String[] rValue, char sep, boolean bPersistent, boolean bGlobal, boolean bNLS);
//	public native void writeEntry( String pKey, String[] rValue);

/** 
 {@link #writeEntry} overridden to accept a list of strings.

 Note: Unlike the other {@link #writeEntry} functions, the old value is
 _not_ returned here!

*/
//	public native void writeEntry( String pKey, String[] rValue, char sep ' arg1, ' arg2, boolean bPersistent, boolean bGlobal, boolean bNLS);
//	public native void writeEntry( String pKey, String[] rValue);
//	public native void writeEntry( String pKey, String[] rValue, char sep ' arg1, ' arg2, boolean bPersistent, boolean bGlobal, boolean bNLS);
//	public native void writeEntry( String pKey, String[] rValue);

/** 
 {@link #writeEntry} overridden to accept a list of Integers.

 Note: Unlike the other {@link #writeEntry} functions, the old value is
 _not_ returned here!

*/
	public native void writeEntry( String pKey, int[] rValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
	public native void writeEntry( String pKey, int[] rValue);
//	public native void writeEntry( String pKey, int[] rValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
//	public native void writeEntry( String pKey, int[] rValue);

/** 
 Write a (key/value) pair.

 This is stored to the most specific config file when destroying the
 config object or when calling {@link #sync}.

*/
//	public native void writeEntry( String pKey, String pValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
//	public native void writeEntry( String pKey, String pValue);
//	public native void writeEntry( String pKey, String pValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
//	public native void writeEntry( String pKey, String pValue);

/** 
 Write a (key/value) pair.
 Same as above, but writes a numerical value.

*/
	public native void writeEntry( String pKey, int nValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
	public native void writeEntry( String pKey, int nValue);
//	public native void writeEntry( String pKey, int nValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
//	public native void writeEntry( String pKey, int nValue);

/** 
 Writes a (key/value) pair.
 Same as above, but writes an unsigned numerical value.

*/
//	public native void writeEntry( String pKey, int nValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
//	public native void writeEntry( String pKey, int nValue);
//	public native void writeEntry( String pKey, int nValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
//	public native void writeEntry( String pKey, int nValue);

/** 
 Writes a (key/value) pair.
 Same as above, but write a long numerical value.

*/
	public native void writeEntry( String pKey, long nValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
	public native void writeEntry( String pKey, long nValue);
//	public native void writeEntry( String pKey, long nValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
//	public native void writeEntry( String pKey, long nValue);

/** 
 Writes a (key/value) pair.
 Same as above, but writes an unsigned long numerical value.

*/
//	public native void writeEntry( String pKey, long nValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
//	public native void writeEntry( String pKey, long nValue);
//	public native void writeEntry( String pKey, long nValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
//	public native void writeEntry( String pKey, long nValue);

/** 
 Writes a (key/value) pair.
 Same as above, but writes a floating-point value.

*/
	public native void writeEntry( String pKey, double nValue, boolean bPersistent, boolean bGlobal, char format, int precision, boolean bNLS);
	public native void writeEntry( String pKey, double nValue);
//	public native void writeEntry( String pKey, double nValue, boolean bPersistent, boolean bGlobal, char format, int precision, boolean bNLS);
//	public native void writeEntry( String pKey, double nValue);

/** 
 Writes a (key/value) pair.
 Same as above, but writes a boolean value.

*/
	public native void writeEntry( String pKey, boolean bValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
	public native void writeEntry( String pKey, boolean bValue);
//	public native void writeEntry( String pKey, boolean bValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
//	public native void writeEntry( String pKey, boolean bValue);

/** 
 Writes a (key/value) pair.
 Same as above, but writes a font value.

*/
	public native void writeEntry( String pKey, QFont rFont, boolean bPersistent, boolean bGlobal, boolean bNLS);
	public native void writeEntry( String pKey, QFont rFont);
//	public native void writeEntry( String pKey, QFont rFont, boolean bPersistent, boolean bGlobal, boolean bNLS);
//	public native void writeEntry( String pKey, QFont rFont);

/** 
 Writes a (key/value) pair.
 Same as above, but write a color entry.

 Note: Unlike the other {@link #writeEntry} functions, the old value is
 _not_ returned here!

*/
	public native void writeEntry( String pKey, QColor rColor, boolean bPersistent, boolean bGlobal, boolean bNLS);
	public native void writeEntry( String pKey, QColor rColor);
//	public native void writeEntry( String pKey, QColor rColor, boolean bPersistent, boolean bGlobal, boolean bNLS);
//	public native void writeEntry( String pKey, QColor rColor);

/** 
 Writes a (key/value) pair.
 Same as above, but writes a date and time entry.

 Note: Unlike the other {@link #writeEntry} functions, the old value is
 <em>not</em> returned here!

*/
	public native void writeEntry( String pKey, Calendar rDateTime, boolean bPersistent, boolean bGlobal, boolean bNLS);
	public native void writeEntry( String pKey, Calendar rDateTime);
//	public native void writeEntry( String pKey, Calendar rDateTime, boolean bPersistent, boolean bGlobal, boolean bNLS);
//	public native void writeEntry( String pKey, Calendar rDateTime);

/** 
 Writes a (key/value) pair.
 Same as above, but writes a rectangle.

 Note: Unlike the other {@link #writeEntry} functions, the old value is
 _not_ returned here!

*/
	public native void writeEntry( String pKey, QRect rValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
	public native void writeEntry( String pKey, QRect rValue);
//	public native void writeEntry( String pKey, QRect rValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
//	public native void writeEntry( String pKey, QRect rValue);

/** 
 Writes a (key/value) pair.
 Same as above, but writes a point.

 Note: Unlike the other {@link #writeEntry} functions, the old value is
 _not_ returned here!

*/
	public native void writeEntry( String pKey, QPoint rValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
	public native void writeEntry( String pKey, QPoint rValue);
//	public native void writeEntry( String pKey, QPoint rValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
//	public native void writeEntry( String pKey, QPoint rValue);

/** 
 Writes a (key/value) pair.
 Same as above, but writes a size.

 Note: Unlike the other {@link #writeEntry} functions, the old value is
 _not_ returned here!

*/
	public native void writeEntry( String pKey, QSize rValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
	public native void writeEntry( String pKey, QSize rValue);
//	public native void writeEntry( String pKey, QSize rValue, boolean bPersistent, boolean bGlobal, boolean bNLS);
//	public native void writeEntry( String pKey, QSize rValue);

/** 
 Writes a file path.

 It is checked whether the path is located under $HOME. If so the
 path is written out with the user's home-directory replaced with
 $HOME. The path should be read back with {@link #readPathEntry}

*/
	public native void writePathEntry( String pKey, String path, boolean bPersistent, boolean bGlobal, boolean bNLS);
	public native void writePathEntry( String pKey, String path);
//	public native void writePathEntry( String pKey, String path, boolean bPersistent, boolean bGlobal, boolean bNLS);
//	public native void writePathEntry( String pKey, String path);

/** 
 Deletes the entry specified by <code>pKey</code> in the current group.

*/
	public native void deleteEntry( String pKey, boolean bNLS, boolean bGlobal);
	public native void deleteEntry( String pKey);
//	public native void deleteEntry( String pKey, boolean bNLS, boolean bGlobal);
//	public native void deleteEntry( String pKey);

/** 
 Deletes a configuration entry group

 If the group is not empty and bDeep is false, nothing gets
 deleted and false is returned.
 If this group is the current group and it is deleted, the
 current group is undefined and should be set with setGroup()
 before the next operation on the configuration object.

*/
	public native boolean deleteGroup( String group, boolean bDeep, boolean bGlobal);
	public native boolean deleteGroup( String group);

/** 
 Turns on or off "dollar  expansion" (see KConfigBase introduction)
  when reading config entries.
 Dollar sign expansion is initially OFF.

*/
	public native void setDollarExpansion( boolean _bExpand);
	public native void setDollarExpansion();

/** 
 Returns whether dollar expansion is on or off.  It is initially OFF.

*/
	public native boolean isDollarExpansion();

/** 
 Mark the config object as "clean," i.e. don't write dirty entries
 at destruction time. If <code>bDeep</code> is false, only the global dirty
 flag of the KConfig object gets cleared. If you then call
 {@link #writeEntry} again, the global dirty flag is set again and all
 dirty entries will be written at a subsequent {@link #sync} call.

 Classes that derive from KConfigBase should override this
 method and implement storage-specific behavior, as well as
 calling the {@link KConfigBase#rollback} explicitly in the initializer.

*/
	public native void rollback( boolean bDeep);
	public native void rollback();

/** 
 Flushes all changes that currently reside only in memory
 back to disk / permanent storage. Dirty configuration entries are
 written to the most specific file available.

 Asks the back end to flush out all pending writes, and then calls
 {@link #rollback}.  No changes are made if the object has <code>readOnly</code>
 status.

 You should call this from your destructor in derivative classes.

*/
	public native void sync();

/** 

*/
	public native boolean isDirty();

/** 
 Sets the config object's read-only status.

   
*/
	public native void setReadOnly( boolean _ro);

/** 
 Returns the read-only status of the config object.

*/
	public native boolean isReadOnly();

/** 
 Checks whether the key has an entry in the currently active group.
 Use this to determine whether a key is not specified for the current
 group (hasKey() returns false). Keys with null data are considered
 nonexistent.

*/
	public native boolean hasKey( String key);

/** 
 Returns a map (tree) of entries for all entries in a particular
 group.  Only the actual entry string is returned, none of the
 other internal data should be included.

*/
	public native String entryMap( String group);

/** 
 Reparses all configuration files. This is useful for programs
 that use stand alone graphical configuration tools. The base
 method implemented here only clears the group list and then
 appends the default group.

 Derivative classes should clear any internal data structures and
 then simply call {@link #parseConfigFiles} when implementing this
 method.

*/
	public native void reparseConfiguration();

/** 

*/
	public native boolean isImmutable();

/** 

*/
	public native boolean groupIsImmutable( String group);

/** 

*/
	public native boolean entryIsImmutable( String key);

/** 
 Returns the state of the app-config object.

 Possible return values
 are NoAccess (the application-specific config file could not be
 opened neither read-write nor read-only), ReadOnly (the
 application-specific config file is opened read-only, but not
 read-write) and ReadWrite (the application-specific config
 file is opened read-write).

*/
	public native int getConfigState();

/** 
 Overloaded public methods:
   
*/
//	public native void setGroup( String pGroup);
//	public native void setGroup( String pGroup);
//	public native boolean hasGroup( String _pGroup);
//	public native boolean hasGroup( String _pGroup);
//	public native boolean hasKey( String pKey);
	public static final int NoAccess = 0;
	public static final int ReadOnly = 1;
	public static final int ReadWrite = 2;
}
