/***************************************************************************
                            KToolBarPopupAction.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This action is a normal action everywhere, except in a toolbar
 where it also has a delayed popupmenu. This action is designed
 for history actions (back/forward, undo/redo) and for any other action
 that has more detail in a toolbar than in a menu (e.g. tool chooser
 with "Other" leading to a dialog...).
 
 See {@link KToolBarPopupActionSignals} for signals emitted by KToolBarPopupAction.

 See {@link KToolBarPopupActionEventHandling} for event handlers to override in subclasses of KToolBarPopupAction.

 @short 
 This action is a normal action everywhere, except in a toolbar
 where it also has a delayed popupmenu.
*/
public class KToolBarPopupAction extends KAction  {
	protected KToolBarPopupAction(Class dummy){super((Class) null);}

	private native void newKToolBarPopupAction( String text, String icon, KShortcut cut, QObject parent, String name);

/** 
 Create a KToolBarPopupAction, with a text, an icon, an optionnal accelerator,
 parent and name.

*/
	public KToolBarPopupAction( String text, String icon, KShortcut cut, QObject parent, String name) {
		super((Class) null);
		newKToolBarPopupAction( text, icon, cut, parent, name);
	}
	private native void newKToolBarPopupAction( String text, String icon);
	public KToolBarPopupAction( String text, String icon) {
		super((Class) null);
		newKToolBarPopupAction( text, icon);
	}
	private native void newKToolBarPopupAction( String text, String icon, KShortcut cut, QObject receiver, String slot, QObject parent, String name);

/** 
 Create a KToolBarPopupAction, with a text, an icon, an accelerator,
 a slot connected to the action, parent and name.

 If you do not want or have a keyboard accelerator, set the
 <code>accel</code> param to 0.

*/
	public KToolBarPopupAction( String text, String icon, KShortcut cut, QObject receiver, String slot, QObject parent, String name) {
		super((Class) null);
		newKToolBarPopupAction( text, icon, cut, receiver, slot, parent, name);
	}
//	private native void newKToolBarPopupAction( String text, String icon, KShortcut cut, QObject receiver, String slot);
//	public KToolBarPopupAction( String text, String icon, KShortcut cut, QObject receiver, String slot) {
//		super((Class) null);
//		newKToolBarPopupAction( text, icon, cut, receiver, slot);
//	}
	private native void newKToolBarPopupAction( KGuiItem item, KShortcut cut, QObject receiver, String slot, KActionCollection parent, String name);

/** 
 Create a KToolBarPopupAction, with a KGuiItem, an accelerator,
 a slot connected to the action, parent and name. The text and the
 icon are taken from the KGuiItem.

 If you do not want or have a keyboard accelerator, set the
 <code>accel</code> param to 0.

*/
	public KToolBarPopupAction( KGuiItem item, KShortcut cut, QObject receiver, String slot, KActionCollection parent, String name) {
		super((Class) null);
		newKToolBarPopupAction( item, cut, receiver, slot, parent, name);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();
	public native int plug( QWidget widget, int index);
	public native int plug( QWidget widget);
	public native void unplug( QWidget widget);

/** 
 The popup menu that is shown when clicking (some time) on the toolbar
 button. You may want to plug items into it on creation, or connect to
 aboutToShow for a more dynamic menu.
     
*/
	public native KPopupMenu popupMenu();

/** 
 Returns true if this action creates a delayed popup menu
 when plugged in a KToolbar.
     
*/
	public native boolean delayed();

/** 
 If set to true, this action will create a delayed popup menu
 when plugged in a KToolbar. Otherwise it creates a normal popup.
 Default: delayed.
     
*/
	public native void setDelayed( boolean delayed);

/** 
 Returns true if this action creates a sticky popup menu.
 See {@link setStickyMenu}.
     
*/
	public native boolean stickyMenu();

/** 
 If set to true, this action will create a sticky popup menu
 when plugged in a KToolbar.
 "Sticky", means it's visible until a selection is made or the mouse is
 clicked elsewhere. This feature allows you to make a selection without
 having to press and hold down the mouse while making a selection.
 Only available if delayed() is true.
 Default: sticky.
     
*/
	public native void setStickyMenu( boolean sticky);
}
