#ifndef BASE_FIELD_H
#define BASE_FIELD_H

#include <qlabel.h>
#include <qpushbutton.h>
#include <qlayout.h>

#include "ghighscores.h"
#include "gmisc_ui.h"
#include "canvas.h"


class BaseBoard;
class GTInitData;

class BaseField
{
 public:
    BaseField(QWidget *widget);
    virtual ~BaseField();

    virtual void settingsChanged();
    virtual KExtHighscores::Score currentScore() const = 0;

 protected:
    QGridLayout *top, *lcds;
    LCD         *showScore;
    LCDList     *showRemoved;
    BaseBoard   *board;

    void scoreUpdated(int score);
    void init(const GTInitData &);
    void init(bool AI, bool multiplayer, bool server, bool first,
              const QString &name);
    virtual void pause(bool pause);
    void stop(bool gameover);
    void hideButton() { midButton(QString::null, QString::null); }

 private:
    QWidget     *widget;
	bool         button, multiplayers;
	QPushButton *pb;
	QLabel      *msg;
    KCanvasRootPixmap *_boardRootPixmap;
    KExtHighscores::Score firstScore, lastScore;

	void midButton(const QString &pt, const QString &mt, bool start = true);
};

#endif
