/*
 * Decompiled with CFR 0.152.
 */
package org.kde.kjas.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PushbackInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import org.kde.kjas.server.KJASAppletClassLoader;
import org.kde.kjas.server.KJASAppletContext;
import org.kde.kjas.server.Main;

public class KJASProtocolHandler {
    private static final int CreateContextCode = 1;
    private static final int DestroyContextCode = 2;
    private static final int CreateAppletCode = 3;
    private static final int DestroyAppletCode = 4;
    private static final int StartAppletCode = 5;
    private static final int StopAppletCode = 6;
    private static final int InitAppletCode = 7;
    private static final int ShowDocumentCode = 8;
    private static final int ShowURLInFrameCode = 9;
    private static final int ShowStatusCode = 10;
    private static final int ResizeAppletCode = 11;
    private static final int GetURLDataCode = 12;
    private static final int URLDataCode = 13;
    private static final int ShutdownServerCode = 14;
    private static final int EvalulateJavaScript = 15;
    private static final int GetMember = 16;
    private static final int CallMember = 17;
    private Hashtable contexts;
    private PushbackInputStream commands;
    private PrintStream signals;
    private int cmd_index;
    private final char sep = '\u0000';

    public KJASProtocolHandler(InputStream inputStream, OutputStream outputStream) {
        this.commands = new PushbackInputStream(inputStream);
        this.signals = new PrintStream(outputStream);
        this.contexts = new Hashtable();
    }

    /*
     * Unable to fully structure code
     */
    public void commandLoop() {
        try {
            while (true) lbl-1000:
            // 3 sources

            {
                try {
                    while (true) {
                        var1_1 = this.readPaddedLength(8);
                        Main.debug("PH: cmd_length = " + var1_1);
                        var2_4 = new byte[var1_1];
                        var3_6 = 0;
                        while (var3_6 < var1_1) {
                            var4_7 = this.commands.read(var2_4, var3_6, var1_1 - var3_6);
                            Main.debug("PH: read in " + var4_7 + " bytes for command");
                            var3_6 += var4_7;
                        }
                        this.processCommand(var2_4);
                    }
                }
                catch (NumberFormatException var1_2) {
                    Main.kjas_err("Could not parse out message length", var1_2);
                    System.exit(1);
                }
                catch (Throwable var2_5) {
                    Main.debug("commandLoop caught a throwable, still going");
                    var2_5.printStackTrace();
                    continue;
                }
                break;
            }
        }
        catch (Exception var1_3) {
            Main.kjas_err("commandLoop exited on exception: ", var1_3);
            System.exit(1);
            return;
        }
        ** GOTO lbl-1000
    }

    public void processCommand(byte[] byArray) {
        byte by;
        if (byArray == null) {
            return;
        }
        int n = byArray.length;
        this.cmd_index = 0;
        if ((by = byArray[this.cmd_index++]) == 1) {
            String string = this.getArg(byArray);
            Main.debug("createContext, id = " + string);
            KJASAppletContext kJASAppletContext = new KJASAppletContext(string);
            this.contexts.put(string, kJASAppletContext);
        } else if (by == 2) {
            String string = this.getArg(byArray);
            Main.debug("destroyContext, id = " + string);
            KJASAppletContext kJASAppletContext = (KJASAppletContext)this.contexts.get(string);
            if (this.contexts != null) {
                kJASAppletContext.destroy();
                this.contexts.remove(string);
            }
        } else if (by == 3) {
            Object object;
            String string = this.getArg(byArray);
            String string2 = this.getArg(byArray);
            String string3 = this.getArg(byArray);
            String string4 = this.getArg(byArray);
            String string5 = this.getArg(byArray);
            String string6 = this.getArg(byArray);
            String string7 = this.getArg(byArray);
            String string8 = this.getArg(byArray);
            String string9 = this.getArg(byArray);
            String string10 = this.getArg(byArray);
            String string11 = this.getArg(byArray);
            int n2 = Integer.parseInt(string11.trim());
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            int n3 = 0;
            while (n3 < n2) {
                String string12;
                object = this.getArg(byArray);
                if (object == null) {
                    object = new String();
                }
                if ((string12 = this.getArg(byArray)) == null) {
                    string12 = new String();
                }
                hashtable.put(((String)object).toUpperCase(), string12);
                ++n3;
            }
            Main.debug("createApplet, context = " + string + ", applet = " + string2);
            Main.debug("              name = " + string3 + ", classname = " + string4);
            Main.debug("              baseURL = " + string5 + ", codeBase = " + string6);
            Main.debug("              archives = " + string7 + ", width = " + string8 + ", height = " + string9);
            object = (KJASAppletContext)this.contexts.get(string);
            if (object != null) {
                ((KJASAppletContext)object).createApplet(string2, string3, string4, string5, string6, string7, string8, string9, string10, hashtable);
            }
        } else if (by == 4) {
            String string = this.getArg(byArray);
            String string13 = this.getArg(byArray);
            Main.debug("destroyApplet, context = " + string + ", applet = " + string13);
            KJASAppletContext kJASAppletContext = (KJASAppletContext)this.contexts.get(string);
            if (kJASAppletContext != null) {
                kJASAppletContext.destroyApplet(string13);
            }
        } else if (by == 5) {
            String string = this.getArg(byArray);
            String string14 = this.getArg(byArray);
            Main.debug("startApplet, context = " + string + ", applet = " + string14);
            KJASAppletContext kJASAppletContext = (KJASAppletContext)this.contexts.get(string);
            if (kJASAppletContext != null) {
                kJASAppletContext.startApplet(string14);
            }
        } else if (by == 6) {
            String string = this.getArg(byArray);
            String string15 = this.getArg(byArray);
            Main.debug("stopApplet, context = " + string + ", applet = " + string15);
            KJASAppletContext kJASAppletContext = (KJASAppletContext)this.contexts.get(string);
            if (kJASAppletContext != null) {
                kJASAppletContext.stopApplet(string15);
            }
        } else if (by == 14) {
            Main.debug("shutDownServer recieved");
            System.exit(1);
        } else if (by == 13) {
            Main.debug("URLData recieved");
            String string = this.getArg(byArray);
            String string16 = this.getArg(byArray);
            Main.debug("data is for loader: " + string);
            Main.debug("URL is " + string16);
            byte[] byArray2 = new byte[n - this.cmd_index];
            System.arraycopy(byArray, this.cmd_index, byArray2, 0, byArray2.length);
            KJASAppletClassLoader kJASAppletClassLoader = KJASAppletClassLoader.getLoader(string);
            if (kJASAppletClassLoader != null) {
                Main.debug("this is a class loader request");
                kJASAppletClassLoader.addResource(string16, byArray2);
            } else {
                KJASAppletContext kJASAppletContext = (KJASAppletContext)this.contexts.get(string);
                if (kJASAppletContext != null) {
                    Main.debug("this is  a context request for an image");
                    kJASAppletContext.addImage(string16, byArray2);
                }
            }
        } else if (by == 15) {
            String string = this.getArg(byArray);
            Main.debug("EvalulateJavaScript return value: " + string);
            Main.liveconnect_returnval = string;
            try {
                Main.liveconnect_thread.interrupt();
            }
            catch (SecurityException securityException) {}
        } else if (by == 16) {
            String string = this.getArg(byArray);
            String string17 = this.getArg(byArray);
            String string18 = this.getArg(byArray);
            StringBuffer stringBuffer = new StringBuffer();
            int n4 = 0;
            KJASAppletContext kJASAppletContext = (KJASAppletContext)this.contexts.get(string);
            if (kJASAppletContext != null) {
                n4 = kJASAppletContext.getMember(string17, string18, stringBuffer);
            }
            Main.debug("GetMember " + string18);
            this.sendMemberValue(string, 16, stringBuffer.toString(), n4);
        } else if (by == 17) {
            String string = this.getArg(byArray);
            String string19 = this.getArg(byArray);
            String string20 = this.getArg(byArray);
            StringBuffer stringBuffer = new StringBuffer();
            Vector<String> vector = new Vector<String>();
            try {
                String string21 = this.getArg(byArray);
                while (string21 != null) {
                    vector.add(string21);
                    string21 = this.getArg(byArray);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n5 = 0;
            Main.debug("stopApplet, context = " + string + ", applet = " + string19);
            KJASAppletContext kJASAppletContext = (KJASAppletContext)this.contexts.get(string);
            if (kJASAppletContext != null) {
                n5 = kJASAppletContext.callMember(string19, string20, stringBuffer, vector);
            }
            Main.debug("CallMember " + string20);
            this.sendMemberValue(string, 17, stringBuffer.toString(), n5);
        } else {
            throw new IllegalArgumentException("Unknown command code");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendGetURLDataCmd(String string, String string2) {
        int n;
        Main.debug("sendGetURLCmd from loader: " + string + " url = " + string2);
        String string3 = null;
        String string4 = null;
        try {
            try {
                string3 = string;
                string4 = new URL(new URL(string), string2).toString();
            }
            catch (MalformedURLException malformedURLException) {
                string3 = string;
                string4 = string2;
                Object var7_6 = null;
                int n5 = string3.length() + string4.length() + 4;
                char[] cArray4 = new char[n5 + 8];
                char[] cArray5 = this.getPaddedLength(n5);
                int n6 = 0;
                System.arraycopy(cArray5, 0, cArray4, n6, cArray5.length);
                n6 += cArray5.length;
                cArray4[n6++] = 12;
                cArray4[n6++] = '\u0000';
                cArray5 = string3.toCharArray();
                System.arraycopy(cArray5, 0, cArray4, n6, cArray5.length);
                n6 += cArray5.length;
                cArray4[n6++] = '\u0000';
                cArray5 = string4.toCharArray();
                System.arraycopy(cArray5, 0, cArray4, n6, cArray5.length);
                n6 += cArray5.length;
                cArray4[n6++] = '\u0000';
                this.signals.print(cArray4);
                return;
            }
            Object var7_5 = null;
            n = string3.length() + string4.length() + 4;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            int n2 = string3.length() + string4.length() + 4;
            char[] cArray = new char[n2 + 8];
            char[] cArray2 = this.getPaddedLength(n2);
            int n3 = 0;
            System.arraycopy(cArray2, 0, cArray, n3, cArray2.length);
            n3 += cArray2.length;
            cArray[n3++] = 12;
            cArray[n3++] = '\u0000';
            cArray2 = string3.toCharArray();
            System.arraycopy(cArray2, 0, cArray, n3, cArray2.length);
            n3 += cArray2.length;
            cArray[n3++] = '\u0000';
            cArray2 = string4.toCharArray();
            System.arraycopy(cArray2, 0, cArray, n3, cArray2.length);
            n3 += cArray2.length;
            cArray[n3++] = '\u0000';
            this.signals.print(cArray);
            throw throwable;
        }
        char[] cArray = new char[n + 8];
        char[] cArray3 = this.getPaddedLength(n);
        int n4 = 0;
        System.arraycopy(cArray3, 0, cArray, n4, cArray3.length);
        n4 += cArray3.length;
        cArray[n4++] = 12;
        cArray[n4++] = '\u0000';
        cArray3 = string3.toCharArray();
        System.arraycopy(cArray3, 0, cArray, n4, cArray3.length);
        n4 += cArray3.length;
        cArray[n4++] = '\u0000';
        cArray3 = string4.toCharArray();
        System.arraycopy(cArray3, 0, cArray, n4, cArray3.length);
        n4 += cArray3.length;
        cArray[n4++] = '\u0000';
        this.signals.print(cArray);
    }

    public void sendShowDocumentCmd(String string, String string2) {
        Main.debug("sendShowDocumentCmd from context#" + string + " url = " + string2);
        int n = string.length() + string2.length() + 4;
        char[] cArray = new char[n + 8];
        char[] cArray2 = this.getPaddedLength(n);
        int n2 = 0;
        System.arraycopy(cArray2, 0, cArray, n2, cArray2.length);
        n2 += cArray2.length;
        cArray[n2++] = 8;
        cArray[n2++] = '\u0000';
        cArray2 = string.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n2, cArray2.length);
        n2 += cArray2.length;
        cArray[n2++] = '\u0000';
        cArray2 = string2.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n2, cArray2.length);
        n2 += cArray2.length;
        cArray[n2++] = '\u0000';
        this.signals.print(cArray);
    }

    public void sendShowDocumentCmd(String string, String string2, String string3) {
        Main.debug("sendShowDocumentCmd from context#" + string + " url = " + string2 + ", frame = " + string3);
        int n = string.length() + string2.length() + string3.length() + 5;
        char[] cArray = new char[n + 8];
        char[] cArray2 = this.getPaddedLength(n);
        int n2 = 0;
        System.arraycopy(cArray2, 0, cArray, n2, cArray2.length);
        n2 += cArray2.length;
        cArray[n2++] = 9;
        cArray[n2++] = '\u0000';
        cArray2 = string.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n2, cArray2.length);
        n2 += cArray2.length;
        cArray[n2++] = '\u0000';
        cArray2 = string2.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n2, cArray2.length);
        n2 += cArray2.length;
        cArray[n2++] = '\u0000';
        cArray2 = string3.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n2, cArray2.length);
        n2 += cArray2.length;
        cArray[n2++] = '\u0000';
        this.signals.print(cArray);
    }

    public void sendShowStatusCmd(String string, String string2) {
        Main.debug("sendShowStatusCmd, contextID = " + string + " msg = " + string2);
        int n = string.length() + string2.length() + 4;
        char[] cArray = new char[n + 8];
        char[] cArray2 = this.getPaddedLength(n);
        int n2 = 0;
        System.arraycopy(cArray2, 0, cArray, n2, cArray2.length);
        n2 += cArray2.length;
        cArray[n2++] = 10;
        cArray[n2++] = '\u0000';
        cArray2 = string.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n2, cArray2.length);
        n2 += cArray2.length;
        cArray[n2++] = '\u0000';
        cArray2 = string2.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n2, cArray2.length);
        n2 += cArray2.length;
        cArray[n2++] = '\u0000';
        this.signals.print(cArray);
    }

    public void sendResizeAppletCmd(String string, String string2, int n, int n2) {
        Main.debug("sendResizeAppletCmd, contextID = " + string + ", appletID = " + string2 + ", width = " + n + ", height = " + n2);
        String string3 = String.valueOf(n);
        String string4 = String.valueOf(n2);
        int n3 = string.length() + string2.length() + string3.length() + string4.length() + 6;
        char[] cArray = new char[n3 + 8];
        char[] cArray2 = this.getPaddedLength(n3);
        int n4 = 0;
        System.arraycopy(cArray2, 0, cArray, n4, cArray2.length);
        n4 += cArray2.length;
        cArray[n4++] = 10;
        cArray[n4++] = '\u0000';
        cArray2 = string.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n4, cArray2.length);
        n4 += cArray2.length;
        cArray[n4++] = '\u0000';
        cArray2 = string2.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n4, cArray2.length);
        n4 += cArray2.length;
        cArray[n4++] = '\u0000';
        cArray2 = string3.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n4, cArray2.length);
        n4 += cArray2.length;
        cArray[n4++] = '\u0000';
        cArray2 = string4.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n4, cArray2.length);
        n4 += cArray2.length;
        cArray[n4++] = '\u0000';
        this.signals.print(cArray);
    }

    public void sendEvaluateJavaScriptCmd(String string, String string2) {
        Main.debug("sendEvaluateJavaScriptCmd, contextID = " + string + " script = " + string2);
        int n = string.length() + string2.length() + 4;
        char[] cArray = new char[n + 8];
        char[] cArray2 = this.getPaddedLength(n);
        int n2 = 0;
        System.arraycopy(cArray2, 0, cArray, n2, cArray2.length);
        n2 += cArray2.length;
        cArray[n2++] = 15;
        cArray[n2++] = '\u0000';
        cArray2 = string.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n2, cArray2.length);
        n2 += cArray2.length;
        cArray[n2++] = '\u0000';
        cArray2 = string2.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n2, cArray2.length);
        n2 += cArray2.length;
        cArray[n2++] = '\u0000';
        this.signals.print(cArray);
    }

    public void sendMemberValue(String string, int n, String string2, int n2) {
        Main.debug("sendMemberValue, contextID = " + string + " value = " + string2);
        String string3 = new String("" + n2);
        int n3 = string.length() + string2.length() + string3.length() + 5;
        char[] cArray = new char[n3 + 8];
        char[] cArray2 = this.getPaddedLength(n3);
        int n4 = 0;
        System.arraycopy(cArray2, 0, cArray, n4, cArray2.length);
        n4 += cArray2.length;
        cArray[n4++] = (char)n;
        cArray[n4++] = '\u0000';
        cArray2 = string.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n4, cArray2.length);
        n4 += cArray2.length;
        cArray[n4++] = '\u0000';
        cArray2 = string2.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n4, cArray2.length);
        n4 += cArray2.length;
        cArray[n4++] = '\u0000';
        cArray2 = string3.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n4, cArray2.length);
        n4 += cArray2.length;
        cArray[n4++] = '\u0000';
        this.signals.print(cArray);
    }

    private String getArg(byte[] byArray) {
        int n = this.cmd_index;
        while (0 != byArray[this.cmd_index++]) {
        }
        if (this.cmd_index > n + 1) {
            String string = new String(byArray, n, this.cmd_index - n - 1);
            return string;
        }
        return null;
    }

    private char[] getPaddedLength(int n) {
        String string = String.valueOf(n);
        int n2 = 8 - string.length();
        String string2 = new String(" ");
        String string3 = string;
        int n3 = 0;
        while (n3 < n2) {
            string3 = string2.concat(string3);
            ++n3;
        }
        if (string3.length() != 8) {
            throw new IllegalArgumentException("can't create string number of length = 8");
        }
        return string3.toCharArray();
    }

    private int readPaddedLength(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.commands.read(byArray, 0, n);
        String string = new String(byArray);
        return Integer.parseInt(string.trim());
    }
}

