/**
 * This file is part of the html renderer for KDE.
 *
 * Copyright (C) 2000 Lars Knoll (knoll@kde.org)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * $Id: render_html.cpp,v 1.24 2002/01/14 19:56:45 mueller Exp $
 */
#include "rendering/render_html.h"
#include "rendering/render_root.h"
#include "html/html_elementimpl.h"

#include "khtmlview.h"

#include <kdebug.h>

using namespace khtml;

RenderHtml::RenderHtml(DOM::HTMLElementImpl* node)
    : RenderFlow(node)
{
}

RenderHtml::~RenderHtml()
{
}

void RenderHtml::setStyle(RenderStyle *style)
{
    RenderFlow::setStyle(style);
    setSpecialObjects(true);
}

void RenderHtml::print(QPainter *p, int _x, int _y, int _w, int _h, int _tx, int _ty)
{
    _tx += m_x;
    _ty += m_y;

    //kdDebug(0) << "html:print " << _tx << "/" << _ty << endl;
    printObject(p, _x, _y, _w, _h, _tx, _ty);
}

void RenderHtml::printBoxDecorations(QPainter *p,int, int _y,
				       int, int _h, int _tx, int _ty)
{
    //kdDebug( 6040 ) << renderName() << "::printDecorations()" << _tx << "/" << _ty << endl;

    QColor c = style()->backgroundColor();
    CachedImage *bg = style()->backgroundImage();

    if( firstChild() ) {
	if( !c.isValid() )
	    c = firstChild()->style()->backgroundColor();
	if( !bg )
	    bg = firstChild()->style()->backgroundImage();
        if( !c.isValid() && root()->view())
            c = root()->view()->palette().active().color(QColorGroup::Base);
    }

    int w = width();
    int h = height();

//    kdDebug(0) << "width = " << w <<endl;

    int rw;
    if (root()->view())
        rw=root()->view()->contentsWidth();
    else
        rw=root()->width();

//    kdDebug(0) << "rw = " << rw <<endl;

    int bx = _tx - marginLeft();
    int by = _ty - marginTop();
    int bw = QMAX(w + marginLeft() + marginRight() + borderLeft() + borderRight(), rw);
    int bh = QMAX(h + marginTop() + marginBottom() + borderTop() + borderBottom(), parent()->height());

    // CSS2 14.2:
    // " The background of the box generated by the root element covers the entire canvas."
    // hence, print the background even in the margin areas (unlike for every other element!)
    // I just love these little inconsistencies .. :-( (Dirk)
    int my = QMAX(by,_y);

    printBackground(p, c, bg, my, _h, bx, by, bw, bh);

    if(style()->hasBorder())
	printBorder( p, _tx, _ty, w, h, style() );
}

void RenderHtml::repaint()
{
    RenderObject *cb = containingBlock();
    if(cb != this)
	cb->repaint();
}

void RenderHtml::layout()
{
    RenderFlow::layout();

    //kdDebug(0) << renderName() << " height = " << m_height << endl;
    int lp = lowestPosition();
    // margins of Html element can only be fixed, right?
    int margins  = style()->marginTop().isFixed() ? style()->marginTop().value : 0;
        margins += style()->marginBottom().isFixed() ? style()->marginBottom().value : 0;

    if( m_height + margins < lp )
	m_height = lp - margins;

    //kdDebug(0) << "docHeight = " << m_height << endl;
}

short RenderHtml::containingBlockWidth() const
{
    if (root()->view())
        return root()->view()->visibleWidth();
    else
        return RenderFlow::containingBlockWidth();
}
